/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.FilePluginCache;
import com.dtolabs.rundeck.core.plugins.JarPluginScanner;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.PluginCache;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginScanner;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginManagerService
implements FrameworkSupportService,
ServiceProviderLoader {
    private static final Logger log = Logger.getLogger((String)PluginManagerService.class.getName());
    public static final String SERVICE_NAME = "PluginManager";
    private static final Map<File, PluginManagerService> managerRegistry = new HashMap<File, PluginManagerService>();
    private File extdir;
    private File cachedir;
    private final PluginCache cache;

    public PluginManagerService(File extdir, File cachedir) {
        this.extdir = extdir;
        this.cachedir = cachedir;
        FileCache<ProviderLoader> filecache = new FileCache<ProviderLoader>();
        this.cache = new FilePluginCache(filecache);
        int rescanInterval = 5000;
        this.cache.addScanner(new JarPluginScanner(extdir, cachedir, filecache, 5000));
        this.cache.addScanner(new ScriptPluginScanner(extdir, cachedir, filecache, 5000));
        log.debug((Object)"Create PluginManagerService");
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public static PluginManagerService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            PluginManagerService instanceForExtDir = PluginManagerService.getInstanceForExtDir(framework.getLibextDir(), framework.getLibextCacheDir());
            framework.setService(SERVICE_NAME, instanceForExtDir);
            return instanceForExtDir;
        }
        return (PluginManagerService)framework.getService(SERVICE_NAME);
    }

    public static synchronized PluginManagerService getInstanceForExtDir(File libextDir, File cachedir) {
        if (null == managerRegistry.get(libextDir)) {
            PluginManagerService service = new PluginManagerService(libextDir, cachedir);
            managerRegistry.put(libextDir, service);
        }
        return managerRegistry.get(libextDir);
    }

    @Override
    public synchronized List<ProviderIdent> listProviders() {
        return this.cache.listProviders();
    }

    @Override
    public synchronized <T> T loadProvider(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        ProviderLoader loaderForIdent = this.cache.getLoaderForIdent(ident);
        if (null == loaderForIdent) {
            throw new MissingProviderException("No matching plugin found", service.getName(), providerName);
        }
        T load = loaderForIdent.load(service, providerName);
        if (null != load) {
            return load;
        }
        throw new ProviderLoaderException("Unable to load provider: " + providerName + ", for service: " + service.getName(), service.getName(), providerName);
    }
}

