/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

class ScriptResourceUtil {
    ScriptResourceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INodeSet executeScript(File scriptfile, String scriptargs, String scriptinterpreter, String pluginname, Map<String, Map<String, String>> dataContext, String fileformat, Framework framework, String project, Logger logger, boolean interpreterArgsQuoted) throws ResourceModelSourceException {
        Process exec;
        File destinationTempFile;
        File workingdir = null;
        int result = -1;
        boolean success = false;
        Streams.StreamCopyThread errthread = null;
        Streams.StreamCopyThread outthread = null;
        try {
            destinationTempFile = File.createTempFile("script-plugin", ".resources");
            destinationTempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new ResourceModelSourceException(e);
        }
        logger.info((Object)("Tempfile: " + destinationTempFile.getAbsolutePath()));
        try {
            exec = null != scriptinterpreter ? ScriptResourceUtil.execShellScript(logger, workingdir, scriptfile, scriptargs, dataContext, dataContext, scriptinterpreter, pluginname, interpreterArgsQuoted) : ScriptResourceUtil.execScript(logger, workingdir, scriptfile, scriptargs, dataContext, dataContext, pluginname);
        }
        catch (IOException e) {
            throw new ResourceModelSourceException("Script execution could not start: " + e.getMessage(), e);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(destinationTempFile);
            try {
                errthread = Streams.copyStreamThread(exec.getErrorStream(), System.err);
                outthread = Streams.copyStreamThread(exec.getInputStream(), fileOutputStream);
                errthread.start();
                outthread.start();
                exec.getOutputStream().close();
                result = exec.waitFor();
                errthread.join();
                outthread.join();
                success = 0 == result;
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)("[" + pluginname + "]: " + e.getMessage()));
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            logger.error((Object)("[" + pluginname + "]: " + e.getMessage()));
            e.printStackTrace(System.err);
        }
        logger.debug((Object)("[" + pluginname + "]: result code: " + result + ", success: " + success));
        if (null != outthread && null != outthread.getException()) {
            logger.error((Object)("[" + pluginname + "]: stream copy error: " + outthread.getException().getMessage()), (Throwable)outthread.getException());
        }
        if (null != errthread && null != errthread.getException()) {
            logger.error((Object)("[" + pluginname + "]: stream copy error: " + errthread.getException().getMessage()), (Throwable)errthread.getException());
        }
        try {
            if (!success) {
                throw new ResourceModelSourceException("Script execution failed with result: " + result);
            }
            if (destinationTempFile.isFile() && destinationTempFile.length() > 0L) {
                try {
                    INodeSet e = FileResourceModelSource.parseFile(destinationTempFile, fileformat, framework, project);
                    return e;
                }
                catch (ConfigurationException e) {
                    throw new ResourceModelSourceException(e);
                }
            }
            throw new ResourceModelSourceException("Script output was empty");
        }
        finally {
            if (!destinationTempFile.delete()) {
                logger.warn((Object)("[" + pluginname + "]: could not delete temp file: " + destinationTempFile.getAbsolutePath()));
            }
        }
    }

    static Process execShellScript(Logger logger, File workingdir, File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String interpreter, String logName, boolean interpreterArgsQuoted) throws IOException {
        ProcessBuilder processBuilder = ScriptResourceUtil.buildProcess(workingdir, scriptfile, scriptargs, envContext, newDataContext, interpreter, interpreterArgsQuoted);
        logger.info((Object)("[" + logName + "] executing: " + processBuilder.command()));
        return processBuilder.start();
    }

    static ProcessBuilder buildProcess(File workingdir, File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String interpreter, boolean interpreterArgsQuoted) {
        ArrayList<String> shells = new ArrayList<String>();
        if (null != interpreter) {
            shells.addAll(Arrays.asList(interpreter.split(" ")));
        }
        if (null != scriptargs) {
            if (interpreterArgsQuoted) {
                String newargs = DataContextUtils.replaceDataReferences(scriptargs, newDataContext);
                shells.add(scriptfile.getAbsolutePath() + " " + newargs);
            } else {
                shells.add(scriptfile.getAbsolutePath());
                shells.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), newDataContext)));
            }
        } else {
            shells.add(scriptfile.getAbsolutePath());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(shells).directory(workingdir);
        Map<String, String> environment = processBuilder.environment();
        if (null != envContext) {
            environment.putAll(DataContextUtils.generateEnvVarsFromContext(envContext));
        }
        return processBuilder;
    }

    static Process execScript(Logger logger, File workingdir, File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext, String logName) throws IOException {
        ExecParams execArgs = ScriptResourceUtil.buildExecParams(scriptfile, scriptargs, envContext, newDataContext);
        String[] args = execArgs.getArgs();
        String[] envarr = execArgs.getEnvarr();
        Runtime runtime = Runtime.getRuntime();
        logger.info((Object)("[" + logName + "] executing: " + StringArrayUtil.asString(args, " ")));
        return runtime.exec(args, envarr, workingdir);
    }

    static ExecParams buildExecParams(File scriptfile, String scriptargs, Map<String, Map<String, String>> envContext, Map<String, Map<String, String>> newDataContext) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(scriptfile.getAbsolutePath());
        if (null != scriptargs && !"".equals(scriptargs)) {
            list.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), newDataContext)));
        }
        String[] args = list.toArray(new String[list.size()]);
        Map<String, String> envMap = DataContextUtils.generateEnvVarsFromContext(envContext);
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        String[] envarr = envlist.toArray(new String[envlist.size()]);
        return new ExecParams(args, envarr);
    }

    static class ExecParams {
        private String[] args;
        private String[] envarr;

        ExecParams(String[] args, String[] envarr) {
            this.args = args;
            this.envarr = envarr;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String[] getEnvarr() {
            return this.envarr;
        }
    }
}

