/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.tasks.net;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.tasks.net.ExtSSHExec;
import com.dtolabs.rundeck.core.tasks.net.ExtScp;
import com.dtolabs.rundeck.plugins.PluginLogger;
import com.dtolabs.utils.Streams;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHUserInfo;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;
import org.apache.tools.ant.types.Environment;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.StorageException;

public class SSHTaskBuilder {
    private static Map<String, String> DEFAULT_SSH_CONFIG = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("PreferredAuthentications", "publickey,password,keyboard-interactive");
            this.put("MaxAuthTries", "1");
        }
    });

    public static Map<String, String> getDefaultSshConfig() {
        return DEFAULT_SSH_CONFIG;
    }

    public static Session openSession(SSHBaseInterface base) throws JSchException {
        JSch jsch = new JSch();
        if (null != base.getUserInfo().getKeyfile()) {
            jsch.addIdentity(base.getUserInfo().getKeyfile());
        }
        if (null != base.getSshKeyData()) {
            try {
                jsch.addIdentity("sshkey", SSHTaskBuilder.streamBytes(base.getSshKeyData()), null, null);
            }
            catch (IOException e) {
                throw new JSchException("Failed to ready private ssh key data");
            }
        }
        if (!base.getUserInfo().getTrust() && base.getKnownhosts() != null) {
            base.getPluginLogger().log(4, "Using known hosts: " + base.getKnownhosts());
            jsch.setKnownHosts(base.getKnownhosts());
        }
        Session session = jsch.getSession(base.getUserInfo().getName(), base.getHost(), base.getPort());
        session.setTimeout((int)base.getTimeout());
        if (base.getVerbose()) {
            base.getPluginLogger().log(2, "Set timeout to " + base.getTimeout());
        }
        session.setUserInfo((UserInfo)base.getUserInfo());
        if (base.getVerbose()) {
            base.getPluginLogger().log(2, "Connecting to " + base.getHost() + ":" + base.getPort());
        }
        SSHTaskBuilder.configureSession(base.getSshConfig(), session);
        session.connect();
        return session;
    }

    public static void configureSession(Map<String, String> config, Session session) {
        Properties newconf = new Properties();
        newconf.putAll(config);
        session.setConfig(newconf);
    }

    public static byte[] streamBytes(InputStream sshKeyData) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.copyStream(sshKeyData, out);
        return out.toByteArray();
    }

    public static ExtSSHExec build(INodeEntry nodeentry, String[] args, Project project, Map<String, Map<String, String>> dataContext, SSHConnectionInfo sshConnectionInfo, int loglevel, PluginLogger logger) throws BuilderException {
        ExtSSHExec extSSHExec = new ExtSSHExec();
        SSHTaskBuilder.build(extSSHExec, nodeentry, args, project, dataContext, sshConnectionInfo, loglevel, logger);
        extSSHExec.setAntLogLevel(loglevel);
        return extSSHExec;
    }

    static void build(SSHExecInterface sshexecTask, INodeEntry nodeentry, String[] args, Project project, Map<String, Map<String, String>> dataContext, SSHConnectionInfo sshConnectionInfo, int loglevel, PluginLogger logger) throws BuilderException {
        SSHTaskBuilder.configureSSHBase(nodeentry, project, sshConnectionInfo, sshexecTask, loglevel, logger);
        String commandString = StringUtils.join((Object[])args, (String)" ");
        sshexecTask.setCommand(commandString);
        sshexecTask.setTimeout(sshConnectionInfo.getSSHTimeout());
        DataContextUtils.addEnvVars(sshexecTask, dataContext);
    }

    private static void configureSSHBase(INodeEntry nodeentry, Project project, SSHConnectionInfo sshConnectionInfo, SSHBaseInterface sshbase, double loglevel, PluginLogger logger) throws BuilderException {
        String username;
        sshbase.setFailonerror(true);
        sshbase.setTrust(true);
        sshbase.setProject(project);
        sshbase.setVerbose(loglevel >= 3.0);
        sshbase.setHost(nodeentry.extractHostname());
        if (nodeentry.containsPort()) {
            int portNum;
            try {
                portNum = Integer.parseInt(nodeentry.extractPort());
            }
            catch (NumberFormatException e) {
                throw new BuilderException("Port number is not valid: " + nodeentry.extractPort(), e);
            }
            sshbase.setPort(portNum);
        }
        if (null == (username = sshConnectionInfo.getUsername())) {
            throw new BuilderException("username was not set");
        }
        sshbase.setUsername(username);
        AuthenticationType authenticationType = sshConnectionInfo.getAuthenticationType();
        if (null == authenticationType) {
            throw new BuilderException("SSH authentication type undetermined");
        }
        switch (authenticationType) {
            case privateKey: {
                String sshKeypath = sshConnectionInfo.getPrivateKeyfilePath();
                String sshKeyResource = sshConnectionInfo.getPrivateKeyResourcePath();
                if (null != sshKeyResource) {
                    if (!PathUtil.asPath((String)sshKeyResource).getPath().startsWith("keys/")) {
                        throw new BuilderException("SSH Private key path is expected to start with \"keys/\": " + sshKeyResource);
                    }
                    logger.log(4, "Using ssh key storage path: " + sshKeyResource);
                    try {
                        InputStream privateKeyResourceData = sshConnectionInfo.getPrivateKeyResourceData();
                        sshbase.setSshKeyData(privateKeyResourceData);
                    }
                    catch (StorageException e) {
                        logger.log(0, "Failed to read SSH Private key stored at path: " + sshKeyResource + ": " + (Object)((Object)e));
                        throw new BuilderException("Failed to read SSH Private key stored at path: " + sshKeyResource, e);
                    }
                    catch (IOException e) {
                        logger.log(0, "Failed to read SSH Private key stored at path: " + sshKeyResource + ": " + e);
                        throw new BuilderException("Failed to read SSH Private key stored at path: " + sshKeyResource, e);
                    }
                } else if (null != sshKeypath && !"".equals(sshKeypath)) {
                    if (!new File(sshKeypath).exists()) {
                        throw new BuilderException("SSH Keyfile does not exist: " + sshKeypath);
                    }
                    logger.log(4, "Using ssh keyfile: " + sshKeypath);
                    sshbase.setKeyfile(sshKeypath);
                } else {
                    throw new BuilderException("SSH Keyfile or storage path must be set to use privateKey authentication");
                }
                String passphrase = sshConnectionInfo.getPrivateKeyPassphrase();
                if (null != passphrase) {
                    sshbase.setPassphrase(passphrase);
                    break;
                }
                sshbase.setPassphrase("");
                break;
            }
            case password: {
                boolean valid;
                String password = sshConnectionInfo.getPassword();
                boolean bl = valid = null != password && !"".equals(password);
                if (!valid) {
                    throw new BuilderException("SSH Password was not set");
                }
                sshbase.setPassword(password);
            }
        }
        Map<String, String> sshConfig = sshConnectionInfo.getSshConfig();
        HashMap<String, String> baseConfig = new HashMap<String, String>(SSHTaskBuilder.getDefaultSshConfig());
        if (null != sshConfig) {
            baseConfig.putAll(sshConfig);
        }
        sshbase.setSshConfig(baseConfig);
        sshbase.setPluginLogger(logger);
    }

    public static Scp buildScp(INodeEntry nodeentry, Project project, String remotepath, File sourceFile, SSHConnectionInfo sshConnectionInfo, int loglevel, PluginLogger logger) throws BuilderException {
        ExtScp scp = new ExtScp();
        SSHTaskBuilder.buildScp(scp, nodeentry, project, remotepath, sourceFile, sshConnectionInfo, loglevel, logger);
        return scp;
    }

    static void buildScp(SCPInterface scp, INodeEntry nodeentry, Project project, String remotepath, File sourceFile, SSHConnectionInfo sshConnectionInfo, int loglevel, PluginLogger logger) throws BuilderException {
        if (null == sourceFile) {
            throw new BuilderException("sourceFile was not set");
        }
        if (null == remotepath) {
            throw new BuilderException("remotePath was not set");
        }
        String username = sshConnectionInfo.getUsername();
        if (null == username) {
            throw new BuilderException("username was not set");
        }
        SSHTaskBuilder.configureSSHBase(nodeentry, project, sshConnectionInfo, scp, loglevel, logger);
        scp.setLocalFile(sourceFile.getAbsolutePath());
        String sshUriPrefix = username + "@" + nodeentry.extractHostname() + ":";
        scp.setRemoteTofile(sshUriPrefix + remotepath);
    }

    public static interface SSHConnectionInfo {
        public AuthenticationType getAuthenticationType();

        public String getPrivateKeyfilePath();

        public String getPrivateKeyResourcePath();

        public InputStream getPrivateKeyResourceData() throws IOException;

        public String getPrivateKeyPassphrase();

        public String getPassword();

        public int getSSHTimeout();

        public String getUsername();

        public Map<String, String> getSshConfig();
    }

    public static enum AuthenticationType {
        privateKey,
        password;

    }

    public static class BuilderException
    extends Exception {
        public BuilderException() {
        }

        public BuilderException(String s) {
            super(s);
        }

        public BuilderException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public BuilderException(Throwable throwable) {
            super(throwable);
        }
    }

    private static final class SCPImpl
    extends SSHBaseImpl
    implements SCPInterface {
        ExtScp instance;

        private SCPImpl(ExtScp instance) {
            super(instance);
            this.instance = instance;
        }

        @Override
        public void setLocalFile(String absolutePath) {
            this.instance.setLocalFile(absolutePath);
        }

        @Override
        public void setRemoteTofile(String s) {
            this.instance.setRemoteTofile(s);
        }
    }

    private static final class SSHExecImpl
    extends SSHBaseImpl
    implements SSHExecInterface {
        ExtSSHExec instance;

        private SSHExecImpl(ExtSSHExec instance) {
            super(instance);
            this.instance = instance;
        }

        @Override
        public void setCommand(String commandString) {
            this.instance.setCommand(commandString);
        }

        @Override
        public void setOutputproperty(String s) {
            this.instance.setOutputproperty(s);
        }

        @Override
        public void addEnv(Environment.Variable env) {
            this.instance.addEnv(env);
        }
    }

    private static abstract class SSHBaseImpl
    implements SSHBaseInterface {
        SSHBaseInterface instance;

        @Override
        public void setFailonerror(boolean b) {
            this.instance.setFailonerror(b);
        }

        @Override
        public void setTrust(boolean b) {
            this.instance.setTrust(b);
        }

        @Override
        public void setProject(Project project) {
            this.instance.setProject(project);
        }

        @Override
        public void setVerbose(boolean b) {
            this.instance.setVerbose(b);
        }

        @Override
        public void setHost(String s) {
            this.instance.setHost(s);
        }

        @Override
        public void setPort(int portNum) {
            this.instance.setPort(portNum);
        }

        @Override
        public void setUsername(String username) {
            this.instance.setUsername(username);
        }

        @Override
        public void setTimeout(long sshTimeout) {
            this.instance.setTimeout(sshTimeout);
        }

        @Override
        public void setKeyfile(String sshKeypath) {
            this.instance.setKeyfile(sshKeypath);
        }

        @Override
        public void setSshKeyData(InputStream sshKeyData) {
            this.instance.setSshKeyData(sshKeyData);
        }

        @Override
        public void setPassphrase(String s) {
            this.instance.setPassphrase(s);
        }

        @Override
        public void setPassword(String password) {
            this.instance.setPassword(password);
        }

        private SSHBaseImpl(SSHBaseInterface instance) {
            this.instance = instance;
        }

        @Override
        public void setKnownhosts(String knownhosts) {
            this.instance.setKnownhosts(knownhosts);
        }

        @Override
        public SSHUserInfo getUserInfo() {
            return this.instance.getUserInfo();
        }

        @Override
        public boolean getVerbose() {
            return this.instance.getVerbose();
        }

        @Override
        public String getHost() {
            return this.instance.getHost();
        }

        @Override
        public int getPort() {
            return this.instance.getPort();
        }

        @Override
        public long getTimeout() {
            return this.instance.getTimeout();
        }

        @Override
        public String getKeyfile() {
            return this.instance.getKeyfile();
        }

        @Override
        public InputStream getSshKeyData() {
            return this.instance.getSshKeyData();
        }

        @Override
        public String getKnownhosts() {
            return this.instance.getKnownhosts();
        }

        @Override
        public void setSshConfig(Map<String, String> config) {
            this.instance.setSshConfig(config);
        }

        @Override
        public Map<String, String> getSshConfig() {
            return this.instance.getSshConfig();
        }

        @Override
        public PluginLogger getPluginLogger() {
            return this.instance.getPluginLogger();
        }

        @Override
        public void setPluginLogger(PluginLogger pluginLogger) {
            this.instance.setPluginLogger(pluginLogger);
        }
    }

    static interface SCPInterface
    extends SSHBaseInterface {
        public void setLocalFile(String var1);

        public void setRemoteTofile(String var1);
    }

    static interface SSHExecInterface
    extends SSHBaseInterface,
    DataContextUtils.EnvironmentConfigurable {
        public void setCommand(String var1);

        @Override
        public void setTimeout(long var1);

        public void setOutputproperty(String var1);
    }

    public static interface SSHBaseInterface {
        public SSHUserInfo getUserInfo();

        public void setFailonerror(boolean var1);

        public void setTrust(boolean var1);

        public void setProject(Project var1);

        public void setVerbose(boolean var1);

        public boolean getVerbose();

        public void setHost(String var1);

        public String getHost();

        public void setPort(int var1);

        public int getPort();

        public void setUsername(String var1);

        public void setTimeout(long var1);

        public long getTimeout();

        public void setKeyfile(String var1);

        public String getKeyfile();

        public void setSshKeyData(InputStream var1);

        public InputStream getSshKeyData();

        public void setPassphrase(String var1);

        public void setPassword(String var1);

        public void setKnownhosts(String var1);

        public String getKnownhosts();

        public void setSshConfig(Map<String, String> var1);

        public Map<String, String> getSshConfig();

        public PluginLogger getPluginLogger();

        public void setPluginLogger(PluginLogger var1);
    }
}

