/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.util;

import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyBuilder {
    private Property.Type type;
    private String name;
    private String title;
    private String description;
    private boolean required;
    private String value;
    private List<String> values;
    private PropertyValidator validator;
    private PropertyScope scope;
    private Map<String, Object> renderingOptions = new HashMap<String, Object>();

    private PropertyBuilder() {
    }

    public static PropertyBuilder builder() {
        return new PropertyBuilder();
    }

    public static PropertyBuilder builder(Property orig) {
        return new PropertyBuilder().name(orig.getName()).defaultValue(orig.getDefaultValue()).required(orig.isRequired()).type(orig.getType()).description(orig.getDescription()).title(orig.getTitle()).values(orig.getSelectValues()).validator(orig.getValidator()).scope(orig.getScope()).renderingOptions(orig.getRenderingOptions());
    }

    public PropertyBuilder string(String name) {
        this.name(name);
        this.type(Property.Type.String);
        return this;
    }

    public PropertyBuilder booleanType(String name) {
        this.name(name);
        this.type(Property.Type.Boolean);
        return this;
    }

    public PropertyBuilder integer(String name) {
        this.name(name);
        this.type(Property.Type.Integer);
        return this;
    }

    public PropertyBuilder longType(String name) {
        this.name(name);
        this.type(Property.Type.Long);
        return this;
    }

    public PropertyBuilder select(String name) {
        this.name(name);
        this.type(Property.Type.Select);
        return this;
    }

    public PropertyBuilder freeSelect(String name) {
        this.name(name);
        this.type(Property.Type.FreeSelect);
        return this;
    }

    public PropertyBuilder type(Property.Type type) {
        this.type = type;
        return this;
    }

    public PropertyBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PropertyBuilder title(String title) {
        this.title = title;
        return this;
    }

    public PropertyBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PropertyBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public PropertyBuilder defaultValue(String value) {
        this.value = value;
        return this;
    }

    public PropertyBuilder values(List<String> values) {
        this.values = values;
        return this;
    }

    public PropertyBuilder values(String ... values) {
        this.values = Arrays.asList(values);
        return this;
    }

    public PropertyBuilder validator(PropertyValidator validator) {
        this.validator = validator;
        return this;
    }

    public PropertyBuilder scope(PropertyScope scope) {
        this.scope = scope;
        return this;
    }

    public PropertyBuilder renderingOptions(Map<String, Object> renderingOptions) {
        this.renderingOptions.putAll(renderingOptions);
        return this;
    }

    public PropertyBuilder renderingOption(String optionKey, Object optionValue) {
        this.renderingOptions.put(optionKey, optionValue);
        return this;
    }

    public Property build() {
        if (null == this.type) {
            throw new IllegalStateException("type is required");
        }
        if (null == this.name) {
            throw new IllegalStateException("name is required");
        }
        return PropertyUtil.forType(this.type, this.name, this.title, this.description, this.required, this.value, this.values, this.validator, this.scope, this.renderingOptions);
    }

    public Property.Type getType() {
        return this.type;
    }
}

