/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;

public class Policies {
    private final List<File> policyFiles = new ArrayList<File>();
    private Iterable<PolicyCollection> cache;

    public Policies(Iterable<PolicyCollection> cache) {
        this.cache = cache;
    }

    public int count() {
        int count = 0;
        for (PolicyCollection f : this.cache) {
            count = (int)((long)count + f.countPolicies());
        }
        return count;
    }

    public static Policies load(File rootPath) throws IOException, PoliciesParseException {
        Policies p = null;
        try {
            p = new Policies(new PoliciesCache(rootPath));
        }
        catch (ParserConfigurationException e) {
            throw new PoliciesParseException(e);
        }
        return p;
    }

    public static Policies loadFile(File singleFile) throws IOException, PoliciesParseException {
        Policies p = null;
        try {
            PoliciesCache policyCollections = new PoliciesCache(singleFile, true);
            p = new Policies(policyCollections);
        }
        catch (ParserConfigurationException e) {
            throw new PoliciesParseException(e);
        }
        return p;
    }

    public List<AclContext> narrowContext(Subject subject, Set<Attribute> environment) {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        for (PolicyCollection f : this.cache) {
            matchedContexts.addAll(f.matchedContexts(subject, environment));
        }
        return matchedContexts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" [");
        Iterator<File> iter = this.policyFiles.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    @Deprecated
    public List<String> listAllRoles() {
        ArrayList<String> results = new ArrayList<String>();
        for (PolicyCollection f : this.cache) {
            results.addAll(f.groupNames());
        }
        return results;
    }
}

