/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.VersionConstants;
import com.dtolabs.rundeck.core.cli.CLITool;
import com.dtolabs.rundeck.core.cli.CLIToolException;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.HelpOptions;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.PropertyConfigurator;

public abstract class BaseTool
implements CLITool {
    private final Options options = new Options();
    private CommandLine commandLine;
    private final List<CLIToolOptions> toolOptions = new ArrayList<CLIToolOptions>();
    private boolean shouldExit = false;
    private CentralDispatcher centralDispatcher;
    private HelpOptions helpOptions;
    private boolean optionsHaveInited = false;

    protected void addToolOptions(CLIToolOptions option) {
        this.toolOptions.add(option);
    }

    protected BaseTool() {
        if (this.isUseHelpOption()) {
            this.helpOptions = new HelpOptions();
            this.toolOptions.add(this.helpOptions);
        }
    }

    protected abstract boolean isUseHelpOption();

    protected void initOptions() {
        if (null != this.toolOptions && !this.optionsHaveInited) {
            for (CLIToolOptions toolOpts : this.toolOptions) {
                toolOpts.addOptions(this.options);
            }
            this.optionsHaveInited = true;
        }
    }

    protected Options getOptions() {
        return this.options;
    }

    protected String optionDisplayString(String opt) {
        return this.optionDisplayString(opt, true);
    }

    protected String optionDisplayString(String opt, boolean extended) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-").append(opt);
        Option option = this.getOption(opt);
        if (null != option) {
            if (option.getLongOpt() != null) {
                stringBuffer.append("/--");
                stringBuffer.append(option.getLongOpt());
            }
            if (option.getArgName() != null && extended) {
                stringBuffer.append(" <");
                stringBuffer.append(option.getArgName());
                stringBuffer.append(">");
            }
        }
        return stringBuffer.toString();
    }

    private Option getOption(String opt) {
        for (Object o : this.getOptions().getOptions()) {
            Option opto = (Option)o;
            if (!opto.getOpt().equals(opt)) continue;
            return opto;
        }
        return null;
    }

    @Override
    public void run(String[] args) throws CLIToolException {
        PropertyConfigurator.configure((String)Constants.getLog4jProperties(Constants.getSystemBaseDir()));
        CommandLine cli = this.parseArgs(args);
        this.validateOptions(cli, args);
        this.go();
    }

    @Override
    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        this.initOptions();
        PosixParser parser = new PosixParser();
        try {
            this.commandLine = parser.parse(this.getOptions(), args);
        }
        catch (ParseException e) {
            this.help();
            throw new CLIToolOptionsException((Exception)((Object)e));
        }
        if (null != this.toolOptions) {
            for (CLIToolOptions toolOpts : this.toolOptions) {
                toolOpts.parseArgs(this.commandLine, args);
            }
        }
        return this.commandLine;
    }

    public void validateOptions(CommandLine cli, String[] args) throws CLIToolOptionsException {
        if (null != this.toolOptions) {
            for (CLIToolOptions toolOpts : this.toolOptions) {
                toolOpts.validate(cli, args);
            }
        }
    }

    protected abstract void go() throws CLIToolException;

    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    public abstract String getHelpString();

    @Override
    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        String helpString = this.getHelpString();
        formatter.printHelp(80, helpString, "options:", this.getOptions(), "[RUNDECK version " + VersionConstants.VERSION + " (" + VersionConstants.BUILD + ")]");
    }

    @Override
    public void exit(int exitcode) {
        if (this.isShouldExit()) {
            System.exit(exitcode);
        }
    }

    private boolean isShouldExit() {
        return this.shouldExit;
    }

    protected void setShouldExit(boolean shouldExit) {
        this.shouldExit = shouldExit;
    }

    public CentralDispatcher getCentralDispatcher() {
        return this.centralDispatcher;
    }

    public void setCentralDispatcher(CentralDispatcher centralDispatcher) {
        this.centralDispatcher = centralDispatcher;
    }
}

