/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.VersionConstants;
import com.dtolabs.rundeck.core.cli.CLILoggerParams;
import com.dtolabs.rundeck.core.cli.CLITool;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.cli.queue.ConsoleExecutionFollowReceiver;
import com.dtolabs.rundeck.core.cli.queue.QueueTool;
import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.IFilesystemFramework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodesGeneratorException;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.NodesYamlGenerator;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedScript;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.dispatcher.QueuedItemResult;
import com.dtolabs.rundeck.core.utils.NodeSet;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.rundeck.core.utils.ThreadBoundOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.PropertyConfigurator;

public class ExecTool
implements CLITool,
IDispatchedScript,
CLILoggerParams {
    static final String FILTER_EXCLUDE_PRECEDENCE_OPT = "Z";
    static final String FILTER_EXCLUDE_PRECEDENCE_LONG = "filter-exclude-precedence";
    private boolean argVerbose = false;
    private boolean argDebug = false;
    private boolean argQuiet = false;
    private boolean argKeepgoing;
    private Integer nodeThreadcount = 1;
    private String argProject;
    private boolean argFollow;
    private boolean argProgress;
    private boolean shouldExit = false;
    protected PrintStream err = System.err;
    protected PrintStream out = System.out;
    protected CommandLine cli;
    protected static final Options options = new Options();
    private IFilesystemFramework filesystemFramework;
    private String baseDir;
    protected NodeFormatter nodeFormatter;
    private String nodeFilter;
    private CentralDispatcher centralDispatcher;
    private boolean nodeExcludePrecedence = true;
    private String scriptpath;
    private InputStream scriptAsStream;
    private boolean inlineScript;
    private String inlineScriptContent;
    private String scriptURLString;
    private String[] argsDeferred;
    private Map excludeMap = new HashMap();
    private Map includeMap = new HashMap();
    public static final int NODESET_EMPTY_EXIT_CODE = 3;
    public static final String DEFAULT_LOG_FORMAT = "[%user@%node %command][%level] %message";
    InputStream instream = System.in;

    ExecTool() {
        this(Constants.getSystemBaseDir());
    }

    ExecTool(String baseDir) {
        this(FrameworkFactory.createFilesystemFramework(new File(baseDir)));
    }

    public ExecTool(FilesystemFramework framework) {
        this.filesystemFramework = framework;
        this.nodeFormatter = new NodeYAMLFormatter();
        this.centralDispatcher = FrameworkFactory.createDispatcher(framework.getPropertyLookup());
    }

    @Override
    public CommandLine parseArgs(String[] args) {
        int lastArg = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!"--".equals(args[i])) continue;
            lastArg = i;
            break;
        }
        if (lastArg >= 0) {
            int argslen = args.length - (lastArg + 1);
            this.argsDeferred = new String[argslen];
            System.arraycopy(args, lastArg + 1, this.argsDeferred, 0, argslen);
        }
        PosixParser parser = new PosixParser();
        try {
            this.cli = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.help();
            throw new ProjectToolException(e);
        }
        if (this.cli.hasOption("K")) {
            this.argKeepgoing = true;
        }
        if (this.cli.hasOption("v")) {
            this.argVerbose = true;
        }
        if (this.cli.hasOption("V")) {
            this.argDebug = true;
        }
        if (this.cli.hasOption("q")) {
            this.argQuiet = true;
        }
        if (this.cli.hasOption("S") && this.cli.hasOption("s")) {
            throw new CoreException("-s and -S options are mutually exclusive");
        }
        if (this.cli.hasOption("s")) {
            this.scriptpath = new File(this.cli.getOptionValue("s")).getAbsolutePath();
        }
        if (this.cli.hasOption("u")) {
            this.scriptURLString = this.cli.getOptionValue("u");
        }
        if (this.cli.hasOption("S")) {
            this.inlineScript = true;
        }
        if (this.cli.hasOption("f")) {
            this.argFollow = true;
            if (this.cli.hasOption("r")) {
                this.argProgress = true;
            }
        }
        if (this.cli.hasOption("F")) {
            this.setNodeFilter(this.cli.getOptionValue("F"));
        }
        if (this.cli.hasOption('p')) {
            this.argProject = this.cli.getOptionValue("p");
        } else if (!this.cli.hasOption("p")) {
            List<String> projects = null;
            try {
                projects = this.listProjectNames();
            }
            catch (CentralDispatcherException e) {
                throw new ProjectToolException(e);
            }
            if (projects.size() == 1) {
                this.argProject = projects.get(0);
            }
        }
        if (this.cli.hasOption("C")) {
            try {
                this.setNodeThreadcount(Integer.valueOf(this.cli.getOptionValue("C")));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("threadcount must be an integer");
            }
        }
        if (this.cli.hasOption("h")) {
            this.help();
            this.exit(1);
        }
        if (this.cli.hasOption("I") || this.cli.hasOption("X")) {
            this.warn("-I/-X are deprecated, use -F with a filter string. This option will be removed in a future version.");
        }
        String[] keys = NodeSet.FILTER_KEYS_LIST.toArray(new String[NodeSet.FILTER_KEYS_LIST.size()]);
        this.excludeMap = this.parseExcludeArgs(keys);
        this.includeMap = this.parseIncludeArgs(keys);
        this.setNodeExcludePrecedence(ExecTool.determineExclusionPrecedenceForArgs(args, this.cli));
        if (null == this.argProject) {
            throw new IllegalArgumentException("project parameter not specified");
        }
        return this.cli;
    }

    private List<String> listProjectNames() throws CentralDispatcherException {
        return this.centralDispatcher.listProjectNames();
    }

    public String generateExecLine(Map<String, String> filterArgs) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.argKeepgoing) {
            list.add("-K");
        }
        if (this.argVerbose) {
            list.add("-v");
        }
        if (this.argDebug) {
            list.add("-V");
        }
        if (this.argQuiet) {
            list.add("-q");
        }
        if (null != this.scriptpath) {
            list.add("-s");
            list.add(this.scriptpath);
        }
        if (null != this.scriptURLString) {
            list.add("-u");
            list.add(this.scriptURLString);
        }
        if (this.inlineScript) {
            list.add("-S");
        }
        if (null != this.argProject) {
            list.add("-p");
            list.add(this.argProject);
        }
        if (1 != this.getNodeThreadcount()) {
            list.add("-C");
            list.add(Integer.toString(this.getNodeThreadcount()));
        }
        if (null != filterArgs) {
            for (Map.Entry<String, String> entry : filterArgs.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
        }
        if (null != this.argsDeferred && this.argsDeferred.length > 0) {
            list.add("--");
            list.addAll(Arrays.asList(this.argsDeferred));
        }
        list.add(0, "dispatch");
        return StringArrayUtil.asString(list.toArray(new String[list.size()]), " ");
    }

    protected Map parseExcludeArgs(String[] keys) {
        return ExecTool.parseFilterArgs(keys, this.cli, "X");
    }

    protected Map parseIncludeArgs(String[] keys) {
        return ExecTool.parseFilterArgs(keys, this.cli, "I");
    }

    @Override
    public void run(String[] args) {
        int exitCode;
        block5: {
            exitCode = 1;
            ThreadBoundOutputStream.bindSystemOut();
            ThreadBoundOutputStream.bindSystemErr();
            this.out = System.out;
            this.err = System.err;
            try {
                this.parseArgs(args);
                if (!this.hasNecessaryRunArgs()) {
                    this.listAction();
                } else {
                    this.queueAction();
                }
                exitCode = 0;
            }
            catch (Throwable t) {
                if (null == t.getMessage() || this.argVerbose || "true".equals(System.getProperty("rdeck.traceExceptions"))) {
                    t.printStackTrace();
                }
                this.error(t);
                if (!(t instanceof NodesetEmptyException)) break block5;
                exitCode = 3;
            }
        }
        this.exit(exitCode);
    }

    private boolean hasNecessaryRunArgs() {
        return this.hasArgsDeferred() || null != this.getScript() || null != this.getServerScriptFilePath() || this.isInlineScript() || null != this.getScriptURLString();
    }

    private boolean hasArgsDeferred() {
        return null != this.argsDeferred && 0 != this.argsDeferred.length;
    }

    void listAction() {
        try {
            this.log((this.argVerbose ? this.getNodeFormatter() : new DefaultNodeFormatter()).formatNodes(this.filterNodes(false).getNodes()).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    NodeFormatter getNodeFormatter() {
        return this.nodeFormatter;
    }

    private void queueAction() {
        QueuedItemResult result;
        try {
            if (this.inlineScript && null == this.inlineScriptContent) {
                this.setScriptAsStream(this.instream);
            }
            result = this.getCentralDispatcher().queueDispatcherScript(this);
        }
        catch (CentralDispatcherException e) {
            throw new CoreException("Unable to queue the execution: " + e.getMessage(), e);
        }
        if (null == result || !result.isSuccessful()) {
            throw new CoreException("Queued job request failed: " + (null != result ? result.getMessage() : "Result was null"));
        }
        if (null != result.getMessage()) {
            this.out.println(result.getMessage());
        }
        this.out.println("Queued Execution ID: " + result.getItem().getId() + " <" + result.getItem().getUrl() + ">");
        if (this.argFollow) {
            this.followOutput(result.getItem(), this.argQuiet, this.argProgress);
        }
    }

    private void followOutput(QueuedItem item, boolean quiet, boolean progress) throws CoreException {
        boolean successful = false;
        try {
            ConsoleExecutionFollowReceiver.Mode mode = ConsoleExecutionFollowReceiver.Mode.output;
            if (quiet) {
                mode = ConsoleExecutionFollowReceiver.Mode.quiet;
            } else if (progress) {
                mode = ConsoleExecutionFollowReceiver.Mode.progress;
            }
            successful = QueueTool.followAction(item.getId(), true, mode, System.out, this, this.getCentralDispatcher());
        }
        catch (CentralDispatcherException e) {
            throw new CoreException("Failed following output for execution: " + item.getId(), e);
        }
        if (!successful) {
            this.exit(3);
        }
    }

    protected NodeSet createFilterNodeSelector() {
        if (null != this.nodeFilter) {
            NodeSet nodeSet = NodeSet.fromFilter(this.nodeFilter);
            nodeSet.setKeepgoing(this.isKeepgoing());
            nodeSet.setThreadCount(this.getNodeThreadcount());
            nodeSet.getInclude().setDominant(this.getNodeExcludePrecedence() == false);
            nodeSet.getExclude().setDominant(this.getNodeExcludePrecedence());
            return nodeSet;
        }
        return ExecTool.createNodeSet(this.includeMap, this.excludeMap, this.getNodeExcludePrecedence(), this.getNodeThreadcount(), this.argKeepgoing, null);
    }

    protected NodeSet createNodeSet(Map includeMap, Map excludeMap) {
        return ExecTool.createNodeSet(includeMap, excludeMap, true, this.getNodeThreadcount(), this.argKeepgoing, null);
    }

    protected static NodeSet createNodeSet(Map includeMap, Map excludeMap, boolean excludePrecedence, Integer threadCount, boolean keepgoing, File failedNodesfile) {
        NodeSet nodeset = new NodeSet();
        nodeset.createExclude(excludeMap).setDominant(excludePrecedence);
        nodeset.createInclude(includeMap).setDominant(!excludePrecedence);
        nodeset.setThreadCount(threadCount);
        nodeset.setKeepgoing(keepgoing);
        nodeset.setFailedNodesfile(failedNodesfile);
        return nodeset;
    }

    public static void main(String[] args) throws Exception {
        File configDir = Constants.getFrameworkConfigFile();
        PropertyConfigurator.configure((String)new File(configDir, "log4j.properties").getAbsolutePath());
        File systemBaseDir = new File(Constants.getSystemBaseDir());
        ExecTool ExecTool2 = new ExecTool(systemBaseDir.getAbsolutePath());
        ExecTool2.shouldExit = true;
        ExecTool2.run(args);
    }

    @Override
    public void exit(int exitcode) {
        if (this.shouldExit) {
            System.exit(exitcode);
        } else if (0 != exitcode) {
            this.warn("ExecTool.exit() called while in embedded usage, not exitting.");
        }
    }

    @Override
    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "dispatch [-h] [-v] [-V] [-q] [-p project] [-F node-filter] [--threadcount <1>] [--keepgoing] [[-S] | [-s <>] | [-u <url>] | [-- command-args]]", null, options, "Examples:\n| dispatch\n | => Prints all nodes\n| dispatch -p default -f -- whoami\n | => Runs the whoami command on all nodes\n| dispatch -F '!name: node1' -f -- uptime\n | => Runs the uptime command on all nodes except node1\n| dispatch -s myscript.sh -f\n | => Copies and then runs myscript.sh to matching nodes\n| dispatch -u http://server/script.sh\n | => Downloads script URL, then runs on matching nodes\n\n[RUNDECK version " + VersionConstants.VERSION + " (" + VersionConstants.BUILD + ")]");
    }

    @Override
    public void log(String message) {
        System.out.println(message);
    }

    @Override
    public void warn(String message) {
        System.err.println("warn: " + message);
    }

    @Override
    public void error(String message) {
        System.err.println("error: " + message);
    }

    private void error(Throwable t) {
        this.error(t.getMessage());
    }

    @Override
    public void debug(String message) {
        if (this.argDebug) {
            this.log("debug: " + message);
        }
    }

    @Override
    public void verbose(String message) {
        if (this.argVerbose) {
            this.log("verbose: " + message);
        }
    }

    public String getArgFrameworkProject() {
        return this.argProject;
    }

    public String[] getArgsDeferred() {
        return null != this.argsDeferred ? (String[])this.argsDeferred.clone() : null;
    }

    public String getScriptpath() {
        return this.scriptpath;
    }

    public boolean isInlineScript() {
        return this.inlineScript;
    }

    public String getInlineScriptContent() {
        return this.inlineScriptContent;
    }

    public NodesSelector getNodeSelector() {
        return this.createFilterNodeSelector().nodeSelectorWithDefault(this.getFrameworkNodeName());
    }

    public String getFrameworkNodeName() {
        return this.filesystemFramework.getPropertyLookup().getProperty("framework.node.name");
    }

    public INodeSet getNodes() throws CentralDispatcherException {
        return this.filterNodes(true);
    }

    public int getThreadCount() {
        return this.getNodeThreadcount();
    }

    public String getNodeRankAttribute() {
        return null;
    }

    public boolean isNodeRankOrderAscending() {
        return true;
    }

    @Override
    public Boolean isKeepgoing() {
        return this.argKeepgoing;
    }

    @Override
    public String getFrameworkProject() {
        return this.getArgFrameworkProject();
    }

    @Override
    public String getScript() {
        return this.getInlineScriptContent();
    }

    @Override
    public InputStream getScriptAsStream() {
        return this.scriptAsStream;
    }

    public void setScriptAsStream(InputStream scriptAsStream) {
        this.scriptAsStream = scriptAsStream;
    }

    @Override
    public String getServerScriptFilePath() {
        return this.getScriptpath();
    }

    public NodeSet getNodeSet() {
        return this.createFilterNodeSelector();
    }

    @Override
    public String[] getArgs() {
        return this.getArgsDeferred();
    }

    @Override
    public int getLoglevel() {
        if (this.argDebug) {
            return 4;
        }
        if (this.argQuiet && this.argVerbose) {
            return 1;
        }
        if (this.argVerbose) {
            return 3;
        }
        if (this.argQuiet) {
            return 0;
        }
        return 2;
    }

    @Override
    public Map<String, Map<String, String>> getDataContext() {
        return null;
    }

    static boolean determineExclusionPrecedenceForArgs(String[] args, CommandLine cli) {
        if (cli.hasOption(FILTER_EXCLUDE_PRECEDENCE_OPT)) {
            return "true".equals(cli.getOptionValue(FILTER_EXCLUDE_PRECEDENCE_OPT));
        }
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            if ("-X".equals(option) || "--xnodes".equals(option)) {
                return true;
            }
            if (!"-I".equals(option) && !"--nodes".equals(option)) continue;
            return false;
        }
        return true;
    }

    protected static Map<String, String> parseMultiNodeArgs(String[] keys, String[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != values && values.length > 0) {
            for (String exclude : values) {
                int i1 = exclude.indexOf("=");
                if (i1 > 0 && i1 <= exclude.length() - 1) {
                    String k = exclude.substring(0, i1);
                    String v = exclude.substring(i1 + 1);
                    map.put(k, v);
                    continue;
                }
                if (i1 >= 0) continue;
                map.put(keys[0], exclude);
            }
        }
        return map;
    }

    protected static Map<String, String> parseFilterArgs(String[] keys, CommandLine cli, String opt) {
        String[] strings = cli.getOptionValues(opt);
        if ((null == strings || strings.length == 0) && null != cli.getOptionValue(opt)) {
            strings = new String[]{cli.getOptionValue(opt)};
        }
        return ExecTool.parseMultiNodeArgs(keys, strings);
    }

    INodeSet filterNodes() throws CentralDispatcherException {
        return this.filterNodes(false);
    }

    INodeSet filterNodes(boolean singleNodeDefault) throws CentralDispatcherException {
        NodeSet filterNodeSelector = this.createFilterNodeSelector();
        String usedFilter = filterNodeSelector.isBlank() ? (singleNodeDefault ? this.getFrameworkNodeName() : ".*") : NodeSet.generateFilter(filterNodeSelector);
        INodeSet n = this.centralDispatcher.filterProjectNodes(this.getFrameworkProject(), usedFilter);
        if (0 == n.getNodeNames().size()) {
            this.verbose("Empty node list");
        }
        return n;
    }

    void setNodeFormatter(NodeFormatter nodeFormatter) {
        this.nodeFormatter = nodeFormatter;
    }

    @Override
    public String getScriptURLString() {
        return this.scriptURLString;
    }

    @Override
    public String getNodeFilter() {
        if (null != this.nodeFilter) {
            return this.nodeFilter;
        }
        NodeSet nodeSet = this.getNodeSet();
        if (null != nodeSet) {
            return NodeSet.generateFilter(nodeSet);
        }
        return null;
    }

    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    @Override
    public Boolean getNodeExcludePrecedence() {
        return this.nodeExcludePrecedence;
    }

    public void setNodeExcludePrecedence(boolean nodeExcludePrecedence) {
        this.nodeExcludePrecedence = nodeExcludePrecedence;
    }

    @Override
    public int getNodeThreadcount() {
        return this.nodeThreadcount;
    }

    public void setNodeThreadcount(Integer nodeThreadcount) {
        this.nodeThreadcount = nodeThreadcount;
    }

    public CentralDispatcher getCentralDispatcher() {
        return this.centralDispatcher;
    }

    public void setCentralDispatcher(CentralDispatcher centralDispatcher) {
        this.centralDispatcher = centralDispatcher;
    }

    public int getAntLoglevel() {
        if (this.argDebug) {
            return 4;
        }
        if (this.argQuiet && this.argVerbose) {
            return 1;
        }
        if (this.argVerbose) {
            return 3;
        }
        if (this.argQuiet) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isDebug() {
        return this.argDebug;
    }

    @Override
    public boolean isVerbose() {
        return this.argVerbose;
    }

    @Override
    public boolean isQuiet() {
        return this.argQuiet;
    }

    public void log(String message, Map<String, String> context) {
        if (this.getAntLoglevel() >= 2) {
            this.log(message);
        }
    }

    public void error(String message, Map<String, String> context) {
        if (this.getAntLoglevel() >= 0) {
            this.log(message);
        }
    }

    public void warn(String message, Map<String, String> context) {
        if (this.getAntLoglevel() >= 1) {
            this.log(message);
        }
    }

    public void verbose(String message, Map<String, String> context) {
        if (this.getAntLoglevel() >= 3) {
            this.log(message);
        }
    }

    public void debug(String message, Map<String, String> context) {
        if (this.getAntLoglevel() >= 4) {
            this.log(message);
        }
    }

    static {
        options.addOption("h", "help", false, "print usage");
        options.addOption("v", "verbose", false, "verbose mode");
        options.addOption("V", "debug", false, "Debug output mode");
        options.addOption("q", "quiet", false, "quiet mode");
        options.addOption("K", "keepgoing", false, "keep going if there are errors");
        options.addOption("C", "threadcount", true, "number of threads");
        options.addOption("F", "filter", true, "node filter string");
        options.addOption("I", "nodes", true, "include node list (deprecated, use --filter)");
        options.addOption("X", "xnodes", true, "exclude node list (deprecated, use --filter)");
        options.addOption("p", "project", true, "project name");
        options.addOption(FILTER_EXCLUDE_PRECEDENCE_OPT, FILTER_EXCLUDE_PRECEDENCE_LONG, true, "true/false. if true, exclusion filters have precedence over inclusion filters");
        options.addOption("s", "scriptfile", true, "scriptfile script file");
        options.addOption("u", "url", true, "script URL");
        options.addOption("S", "stdin", false, "read script from stdin");
        options.addOption("f", "follow", false, "Follow queued execution output");
        options.addOption("r", "progress", false, "In follow mode, print progress indicator chars");
    }

    static class NodeYAMLFormatter
    implements NodeFormatter {
        NodeYAMLFormatter() {
        }

        @Override
        public StringBuffer formatNodes(Collection nodes) throws Exception {
            return this.generate(nodes);
        }

        StringBuffer generate(Collection c) throws NodesGeneratorException, IOException {
            StringWriter writer = new StringWriter();
            NodesYamlGenerator gen = new NodesYamlGenerator(writer);
            for (Object aC : c) {
                gen.addNode((INodeEntry)aC);
            }
            gen.generate();
            return writer.getBuffer();
        }
    }

    public static interface NodeFormatter {
        public StringBuffer formatNodes(Collection var1) throws Exception;
    }

    static class DefaultNodeFormatter
    implements NodeFormatter {
        DefaultNodeFormatter() {
        }

        @Override
        public StringBuffer formatNodes(Collection nodes) throws Exception {
            return this.formatResults(nodes);
        }

        StringBuffer formatResults(Collection c) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (Object aC : c) {
                INodeEntry node = (INodeEntry)aC;
                sb.append(node.getNodename());
                if (i < c.size() - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb;
        }
    }
}

