/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.ProjectNodeSupport;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FrameworkProject
extends FrameworkResourceParent
implements IRundeckProject {
    public static final String PROP_FILENAME = "project.properties";
    public static final String ETC_DIR_NAME = "etc";
    public static final String NODES_XML = "resources.xml";
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String PROJECT_RESOURCES_FILEFORMAT_PROPERTY = "project.resources.file.format";
    public static final String PROJECT_RESOURCES_ALLOWED_URL_PREFIX = "project.resources.allowedURL.";
    public static final String FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX = "framework.resources.allowedURL.";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    private final File resourcesBaseDir;
    private final File etcDir;
    private final IFrameworkProjectMgr projectResourceMgr;
    private final File propertyFile;
    private PropertyLookup lookup;
    private PropertyLookup projectLookup;
    private FilesystemFramework filesystemFramework;
    private Framework framework;
    private IProjectNodes projectNodes;
    private long propertiesLastReload = 0L;

    public static Set<Attribute> authorizationEnvironment(String project) {
        return Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), project));
    }

    public FrameworkProject(String name, File basedir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr) {
        this(name, basedir, filesystemFramework, resourceMgr, null);
    }

    public FrameworkProject(String name, File basedir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr, Properties properties) {
        super(name, basedir, null);
        this.filesystemFramework = filesystemFramework;
        this.projectResourceMgr = resourceMgr;
        this.resourcesBaseDir = new File(this.getBaseDir(), "resources");
        this.etcDir = FrameworkProject.getProjectEtcDir(this.getBaseDir());
        if (!this.etcDir.exists() && !this.etcDir.mkdirs()) {
            throw new FrameworkResourceException("error while creating project structure. failed creating directory: " + this.etcDir.getAbsolutePath(), this);
        }
        this.propertyFile = FrameworkProject.getProjectPropertyFile(this.getBaseDir());
        if (!this.propertyFile.exists()) {
            this.generateProjectPropertiesFile(false, properties, true);
        }
        this.loadProperties();
        this.initialize();
    }

    private static File getProjectEtcDir(File baseDir) {
        return new File(baseDir, ETC_DIR_NAME);
    }

    private static File getProjectPropertyFile(File baseDir) {
        return new File(FrameworkProject.getProjectEtcDir(baseDir), PROP_FILENAME);
    }

    private synchronized void checkReloadProperties() {
        if (this.needsPropertiesReload()) {
            this.loadProperties();
        }
    }

    private boolean needsPropertiesReload() {
        File fwkProjectPropertyFile = this.getFrameworkPropertyFile();
        long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
        if (this.propertyFile.exists()) {
            return this.propertyFile.lastModified() > this.propertiesLastReload || fwkPropsLastModified > this.propertiesLastReload;
        }
        return fwkPropsLastModified > this.propertiesLastReload;
    }

    private synchronized void loadProperties() {
        File fwkProjectPropertyFile = this.getFrameworkPropertyFile();
        this.lookup = FrameworkProject.createProjectPropertyLookup(this.filesystemFramework, this.getName());
        this.projectLookup = FrameworkProject.createDirectProjectPropertyLookup(this.filesystemFramework, this.getName());
        if (this.propertyFile.exists()) {
            this.getLogger().debug((Object)("loading existing project.properties: " + this.propertyFile.getAbsolutePath()));
            long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
            long propsLastMod = this.propertyFile.lastModified();
            this.propertiesLastReload = propsLastMod > fwkPropsLastModified ? propsLastMod : fwkPropsLastModified;
        } else {
            this.getLogger().debug((Object)("loading instance-level project.properties: " + this.propertyFile.getAbsolutePath()));
            this.propertiesLastReload = fwkProjectPropertyFile.lastModified();
        }
    }

    private File getFrameworkPropertyFile() {
        return new File(this.filesystemFramework.getConfigDir(), PROP_FILENAME);
    }

    private static PropertyLookup createProjectPropertyLookup(FilesystemFramework filesystemFramework, String projectName) {
        Properties ownProps = new Properties();
        ownProps.setProperty("project.name", projectName);
        File baseDir = filesystemFramework.getBaseDir();
        File projectsBaseDir = filesystemFramework.getFrameworkProjectsBaseDir();
        File fwkProjectPropertyFile = FilesystemFramework.getPropertyFile(filesystemFramework.getConfigDir());
        Properties nodeWideDepotProps = PropertyLookup.fetchProperties(fwkProjectPropertyFile);
        nodeWideDepotProps.putAll((Map<?, ?>)ownProps);
        File propertyFile = FrameworkProject.getProjectPropertyFile(new File(projectsBaseDir, projectName));
        PropertyLookup lookup = propertyFile.exists() ? PropertyLookup.create(propertyFile, nodeWideDepotProps, FilesystemFramework.createPropertyLookupFromBasedir(baseDir)) : PropertyLookup.create(fwkProjectPropertyFile, ownProps, FilesystemFramework.createPropertyLookupFromBasedir(baseDir));
        lookup.expand();
        return lookup;
    }

    private static PropertyLookup createDirectProjectPropertyLookup(FilesystemFramework filesystemFramework, String projectName) {
        Properties ownProps = new Properties();
        ownProps.setProperty("project.name", projectName);
        File projectsBaseDir = filesystemFramework.getFrameworkProjectsBaseDir();
        File propertyFile = FrameworkProject.getProjectPropertyFile(new File(projectsBaseDir, projectName));
        Properties projectProps = PropertyLookup.fetchProperties(propertyFile);
        PropertyLookup lookup = PropertyLookup.create(projectProps, (IPropertyLookup)PropertyLookup.create(ownProps));
        lookup.expand();
        return lookup;
    }

    public static PropertyRetriever createProjectPropertyRetriever(FilesystemFramework filesystemFramework, String projectName) {
        return FrameworkProject.createProjectPropertyLookup(filesystemFramework, projectName).safe();
    }

    @Override
    public synchronized List<Map<String, Object>> listResourceModelConfigurations() {
        return this.projectNodes.listResourceModelConfigurations();
    }

    public static FrameworkProject create(String name, File projectsDir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr) {
        return FrameworkFactory.createFrameworkProject(name, new File(projectsDir, name), filesystemFramework, resourceMgr, null);
    }

    public static FrameworkProject create(String name, File projectsDir, FilesystemFramework filesystemFramework, IFrameworkProjectMgr resourceMgr, Properties properties) {
        return FrameworkFactory.createFrameworkProject(name, new File(projectsDir, name), filesystemFramework, resourceMgr, properties);
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        throw new FrameworkResourceParent.NoSuchResourceException("project named " + name + " doesn't exist", this);
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        File file = new File(this.resourcesBaseDir, name);
        return file.exists() && file.isDirectory();
    }

    @Override
    public Collection listChildNames() {
        String[] list;
        HashSet<String> childnames = new HashSet<String>();
        if (this.resourcesBaseDir.isDirectory() && null != (list = this.resourcesBaseDir.list())) {
            for (int i = 0; i < list.length; ++i) {
                File dir = new File(this.resourcesBaseDir, list[i]);
                if (!dir.isDirectory()) continue;
                childnames.add(dir.getName());
            }
        }
        return childnames;
    }

    @Override
    public IFrameworkResource createChild(String resourceType) {
        throw new UnsupportedOperationException("createChild");
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public IFrameworkProjectMgr getFrameworkProjectMgr() {
        return this.projectResourceMgr;
    }

    public static boolean exists(String project, IFrameworkProjectMgr projectResourceMgr) {
        return projectResourceMgr.existsFrameworkProject(project);
    }

    public File getEtcDir() {
        return this.etcDir;
    }

    @Override
    public INodeSet getNodeSet() throws NodeFileParserException {
        return this.projectNodes.getNodeSet();
    }

    @Override
    public boolean updateNodesResourceFile() throws UpdateUtils.UpdateException {
        return this.projectNodes.updateNodesResourceFile(ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    @Override
    public void updateNodesResourceFileFromUrl(String providerURL, String username, String password) throws UpdateUtils.UpdateException {
        this.projectNodes.updateNodesResourceFileFromUrl(providerURL, username, password, ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    @Override
    public void updateNodesResourceFile(INodeSet nodeset) throws UpdateUtils.UpdateException {
        this.projectNodes.updateNodesResourceFile(nodeset, ProjectNodeSupport.getNodesResourceFilePath(this, this.framework));
    }

    @Override
    public synchronized String getProperty(String name) {
        this.checkReloadProperties();
        return this.lookup.getProperty(name);
    }

    @Override
    public synchronized boolean hasProperty(String key) {
        this.checkReloadProperties();
        return this.lookup.hasProperty(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.lookup.getPropertiesMap();
    }

    @Override
    public Map<String, String> getProjectProperties() {
        return this.projectLookup.getPropertiesMap();
    }

    public synchronized PropertyRetriever getPropertyRetriever() {
        this.checkReloadProperties();
        return this.lookup.safe();
    }

    public static void createFileStructure(File projectDir) throws IOException {
        if (!projectDir.exists() && !projectDir.mkdirs()) {
            throw new IOException("failed creating project base dir: " + projectDir.getAbsolutePath());
        }
        File etcDir = new File(projectDir, ETC_DIR_NAME);
        if (!etcDir.exists() && !etcDir.mkdirs()) {
            throw new IOException("failed creating project etc dir: " + etcDir.getAbsolutePath());
        }
    }

    @Override
    public boolean existsFileResource(String path) {
        File result = new File(this.getBaseDir(), path);
        return result.exists() && result.isFile();
    }

    @Override
    public boolean deleteFileResource(String path) {
        File result = new File(this.getBaseDir(), path);
        return !result.exists() || result.delete();
    }

    @Override
    public long storeFileResource(String path, InputStream input) throws IOException {
        File result = new File(this.getBaseDir(), path);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(result);){
            long l = Streams.copyStream(input, fos);
            return l;
        }
    }

    @Override
    public long loadFileResource(String path, OutputStream output) throws IOException {
        File result = new File(this.getBaseDir(), path);
        try (FileInputStream fis = new FileInputStream(result);){
            long l = Streams.copyStream(fis, output);
            return l;
        }
    }

    protected void generateProjectPropertiesFile(boolean overwrite) {
        this.generateProjectPropertiesFile(overwrite, null, false);
    }

    protected void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean addDefaultProps) {
        this.generateProjectPropertiesFile(overwrite, properties, false, null, addDefaultProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean merge, Set<String> removePrefixes, boolean addDefaultProps) {
        File destfile = this.getPropertyFile();
        if (destfile.exists() && !overwrite) {
            return;
        }
        Properties newProps = new Properties();
        newProps.setProperty("project.name", this.getName());
        if (addDefaultProps) {
            if (null == properties || !properties.containsKey("resources.source.1.type")) {
                newProps.setProperty("resources.source.1.type", "file");
                newProps.setProperty("resources.source.1.config.file", new File(this.getEtcDir(), NODES_XML).getAbsolutePath());
                newProps.setProperty("resources.source.1.config.includeServerNode", "true");
                newProps.setProperty("resources.source.1.config.generateFileAutomatically", "true");
            }
            if (null == properties || !properties.containsKey("service.NodeExecutor.default.provider")) {
                newProps.setProperty("service.NodeExecutor.default.provider", "jsch-ssh");
            }
            if (null == properties || !properties.containsKey("service.FileCopier.default.provider")) {
                newProps.setProperty("service.FileCopier.default.provider", "jsch-scp");
            }
            if (null == properties || !properties.containsKey("project.ssh-keypath")) {
                newProps.setProperty("project.ssh-keypath", new File(System.getProperty("user.home"), ".ssh/id_rsa").getAbsolutePath());
            }
            if (null == properties || !properties.containsKey("project.ssh-authentication")) {
                newProps.setProperty("project.ssh-authentication", "privateKey");
            }
        }
        if (merge) {
            Properties orig = new Properties();
            if (destfile.exists()) {
                try (FileInputStream fileInputStream = new FileInputStream(destfile);){
                    orig.load(fileInputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Iterator<Map.Entry<Object, Object>> i$ = orig.entrySet().iterator();
            block10: while (i$.hasNext()) {
                Map.Entry<Object, Object> o;
                Map.Entry<Object, Object> entry = o = i$.next();
                String key = (String)entry.getKey();
                if (null != removePrefixes) {
                    for (String replacePrefix : removePrefixes) {
                        if (!key.startsWith(replacePrefix)) continue;
                        continue block10;
                    }
                }
                newProps.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != properties) {
            newProps.putAll((Map<?, ?>)properties);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(destfile);){
            newProps.store(fileOutputStream, "Project " + this.getName() + " configuration, generated");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadProperties();
        this.getLogger().debug((Object)("generated project.properties: " + destfile.getAbsolutePath()));
    }

    @Override
    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        this.generateProjectPropertiesFile(true, properties, true, removePrefixes, false);
    }

    @Override
    public void setProjectProperties(Properties properties) {
        this.generateProjectPropertiesFile(true, properties, false, null, false);
    }

    @Override
    public Date getConfigLastModifiedTime() {
        return new Date(this.getPropertyFile().lastModified());
    }

    public static boolean isInstalled(FrameworkProject d) {
        return d.getBaseDir().exists();
    }

    public ArrayList<Exception> getResourceModelSourceExceptions() {
        return this.projectNodes.getResourceModelSourceExceptions();
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void setFramework(Framework framework) {
        this.framework = framework;
    }

    @Override
    public IProjectNodes getProjectNodes() {
        return this.projectNodes;
    }

    public void setProjectNodes(IProjectNodes projectNodes) {
        this.projectNodes = projectNodes;
    }
}

