/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.OrchestratorConfig;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.FlowControl;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeExecutionContext;
import com.dtolabs.rundeck.core.jobs.JobService;
import com.dtolabs.rundeck.core.storage.StorageTree;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionContextImpl
implements ExecutionContext,
StepExecutionContext,
NodeExecutionContext {
    private String frameworkProject;
    private String user;
    private NodesSelector nodeSet;
    private INodeSet nodes;
    private int threadCount;
    private boolean keepgoing;
    private int loglevel;
    private Map<String, Map<String, String>> dataContext;
    private Map<String, Map<String, String>> privateDataContext;
    private Map<String, Map<String, Map<String, String>>> nodeDataContext;
    private ExecutionListener executionListener;
    private Framework framework;
    private AuthContext authContext;
    private File nodesFile;
    private String nodeRankAttribute;
    private boolean nodeRankOrderAscending = true;
    private int stepNumber = 1;
    private List<Integer> stepContext = new ArrayList<Integer>();
    private StorageTree storageTree;
    private JobService jobService;
    private FlowControl flowControl;
    private OrchestratorConfig orchestrator;

    private ExecutionContextImpl() {
        this.nodes = new NodeSetImpl();
        this.nodeDataContext = new HashMap<String, Map<String, Map<String, String>>>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExecutionContext context) {
        return new Builder(context);
    }

    public static Builder builder(StepExecutionContext context) {
        return new Builder(context);
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getNodeDataContext() {
        return this.nodeDataContext;
    }

    @Override
    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
    }

    @Override
    public StorageTree getStorageTree() {
        return this.storageTree;
    }

    @Override
    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    @Override
    public String getFrameworkProject() {
        return this.frameworkProject;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public NodesSelector getNodeSelector() {
        return this.nodeSet;
    }

    @Override
    public INodeSet getNodes() {
        return this.nodes;
    }

    @Override
    public int getLoglevel() {
        return this.loglevel;
    }

    @Override
    public Map<String, Map<String, String>> getDataContext() {
        return this.dataContext;
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public File getNodesFile() {
        return this.nodesFile;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isKeepgoing() {
        return this.keepgoing;
    }

    @Override
    public Map<String, Map<String, String>> getPrivateDataContext() {
        return this.privateDataContext;
    }

    @Override
    public String getNodeRankAttribute() {
        return this.nodeRankAttribute;
    }

    @Override
    public boolean isNodeRankOrderAscending() {
        return this.nodeRankOrderAscending;
    }

    @Override
    public int getStepNumber() {
        return this.stepNumber;
    }

    @Override
    public List<Integer> getStepContext() {
        return this.stepContext;
    }

    @Override
    public JobService getJobService() {
        return this.jobService;
    }

    @Override
    public OrchestratorConfig getOrchestrator() {
        return this.orchestrator;
    }

    public static class Builder {
        private ExecutionContextImpl ctx = new ExecutionContextImpl();

        public Builder() {
        }

        public Builder(ExecutionContext original) {
            this();
            if (null != original) {
                this.ctx.frameworkProject = original.getFrameworkProject();
                this.ctx.user = original.getUser();
                this.ctx.nodeSet = original.getNodeSelector();
                this.ctx.nodes = original.getNodes();
                this.ctx.loglevel = original.getLoglevel();
                this.ctx.dataContext = original.getDataContext();
                this.ctx.privateDataContext = original.getPrivateDataContext();
                this.ctx.executionListener = original.getExecutionListener();
                this.ctx.framework = original.getFramework();
                this.ctx.authContext = original.getAuthContext();
                this.ctx.nodesFile = original.getNodesFile();
                this.ctx.threadCount = original.getThreadCount();
                this.ctx.keepgoing = original.isKeepgoing();
                this.ctx.nodeRankAttribute = original.getNodeRankAttribute();
                this.ctx.nodeRankOrderAscending = original.isNodeRankOrderAscending();
                this.ctx.storageTree = original.getStorageTree();
                this.ctx.jobService = original.getJobService();
                this.ctx.orchestrator = original.getOrchestrator();
                if (original instanceof NodeExecutionContext) {
                    NodeExecutionContext original1 = (NodeExecutionContext)original;
                    this.ctx.nodeDataContext.putAll(original1.getNodeDataContext());
                }
            }
        }

        public Builder storageTree(StorageTree storageTree) {
            this.ctx.storageTree = storageTree;
            return this;
        }

        public Builder jobService(JobService jobService) {
            this.ctx.jobService = jobService;
            return this;
        }

        public Builder(StepExecutionContext original) {
            this((ExecutionContext)original);
            if (null != original) {
                this.ctx.stepNumber = original.getStepNumber();
                this.ctx.stepContext = original.getStepContext();
                this.ctx.flowControl = original.getFlowControl();
            }
        }

        public Builder flowControl(FlowControl flowControl) {
            this.ctx.flowControl = flowControl;
            return this;
        }

        public Builder frameworkProject(String frameworkProject) {
            this.ctx.frameworkProject = frameworkProject;
            return this;
        }

        public Builder user(String user) {
            this.ctx.user = user;
            return this;
        }

        public Builder nodeSelector(NodesSelector nodeSet) {
            this.ctx.nodeSet = nodeSet;
            return this;
        }

        public Builder nodes(INodeSet nodeSet) {
            this.ctx.nodes = nodeSet;
            return this;
        }

        public Builder singleNodeContext(INodeEntry node, boolean setContextData) {
            this.nodeSelector(SelectorUtils.singleNode(node.getNodename()));
            this.nodes(NodeSetImpl.singleNodeSet(node));
            if (setContextData) {
                this.nodeContextData(node);
                if (null != this.ctx.nodeDataContext && null != this.ctx.nodeDataContext.get(node.getNodename())) {
                    this.ctx.dataContext = DataContextUtils.merge(this.ctx.dataContext, (Map)this.ctx.nodeDataContext.get(node.getNodename()));
                }
            }
            return this;
        }

        public Builder nodeContextData(INodeEntry node) {
            this.ctx.dataContext = DataContextUtils.addContext("node", DataContextUtils.nodeData(node), this.ctx.dataContext);
            return this;
        }

        public Builder setContext(String key, Map<String, String> data) {
            return this.dataContext(DataContextUtils.addContext(key, data, this.ctx.dataContext));
        }

        public Builder mergeContext(String key, Map<String, String> data) {
            HashMap<String, Map<String, String>> tomerge = new HashMap<String, Map<String, String>>();
            tomerge.put(key, data);
            return this.dataContext(DataContextUtils.merge(this.ctx.dataContext, tomerge));
        }

        public Builder loglevel(int loglevel) {
            this.ctx.loglevel = loglevel;
            return this;
        }

        public Builder dataContext(Map<String, Map<String, String>> dataContext) {
            this.ctx.dataContext = dataContext;
            return this;
        }

        public Builder privateDataContext(Map<String, Map<String, String>> privateDataContext) {
            this.ctx.privateDataContext = privateDataContext;
            return this;
        }

        public Builder executionListener(ExecutionListener executionListener) {
            this.ctx.executionListener = executionListener;
            return this;
        }

        public Builder framework(Framework framework) {
            this.ctx.framework = framework;
            return this;
        }

        public Builder authContext(AuthContext authContext) {
            this.ctx.authContext = authContext;
            return this;
        }

        public Builder nodesFile(File nodesFile) {
            this.ctx.nodesFile = nodesFile;
            return this;
        }

        public Builder threadCount(int threadCount) {
            this.ctx.threadCount = threadCount;
            return this;
        }

        public Builder keepgoing(boolean keepgoing) {
            this.ctx.keepgoing = keepgoing;
            return this;
        }

        public Builder nodeRankAttribute(String nodeRankAttribute) {
            this.ctx.nodeRankAttribute = nodeRankAttribute;
            return this;
        }

        public Builder nodeRankOrderAscending(boolean nodeRankOrderAscending) {
            this.ctx.nodeRankOrderAscending = nodeRankOrderAscending;
            return this;
        }

        public Builder stepNumber(int number) {
            this.ctx.stepNumber = number;
            return this;
        }

        public Builder stepContext(List<Integer> stepContext) {
            this.ctx.stepContext = stepContext;
            return this;
        }

        public Builder orchestrator(OrchestratorConfig orchestrator) {
            this.ctx.orchestrator = orchestrator;
            return this;
        }

        public Builder pushContextStep(int step) {
            this.ctx.stepContext.add(this.ctx.stepNumber);
            this.ctx.stepNumber = step;
            return this;
        }

        public Builder nodeDataContext(String nodeName, Map<String, Map<String, String>> dataContext) {
            this.ctx.nodeDataContext.put(nodeName, dataContext);
            return this;
        }

        public ExecutionContextImpl build() {
            return this.ctx;
        }
    }
}

