/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StepFirstWorkflowStrategy
extends BaseWorkflowStrategy {
    protected static final String DATA_CONTEXT_PREFIX = "data context: ";
    protected static final String OPTION_KEY = "option";
    protected static final String SECURE_OPTION_KEY = "secureOption";
    protected static final String SECURE_OPTION_VALUE = "****";

    public StepFirstWorkflowStrategy(Framework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowStatusResult workflowResult = WorkflowResultFailed;
        RuntimeException exception = null;
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        try {
            executionContext.getExecutionListener().log(4, "NodeSet: " + executionContext.getNodeSelector());
            executionContext.getExecutionListener().log(4, "Workflow: " + workflow);
            Map<String, Map<String, String>> printableContext = this.createPrintableDataContext(executionContext.getDataContext());
            executionContext.getExecutionListener().log(4, String.format("%s %s", DATA_CONTEXT_PREFIX, printableContext));
            List<StepExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            workflowResult = this.executeWorkflowItemsForNodeSet(executionContext, stepFailures, stepResults, iWorkflowCmdItems, workflow.isKeepgoing());
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
        }
        RuntimeException orig = exception;
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowStrategy.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, orig, workflowResult);
    }

    protected Map<String, Map<String, String>> createPrintableDataContext(Map<String, Map<String, String>> dataContext) {
        HashMap<String, Map<String, String>> printableContext = new HashMap<String, Map<String, String>>();
        if (dataContext != null) {
            printableContext.putAll(dataContext);
            HashSet secureValues = new HashSet();
            if (dataContext.containsKey(SECURE_OPTION_KEY)) {
                HashMap<String, String> secureOptions = new HashMap<String, String>();
                secureOptions.putAll(dataContext.get(SECURE_OPTION_KEY));
                secureValues.addAll(secureOptions.values());
                for (Map.Entry entry : secureOptions.entrySet()) {
                    entry.setValue(SECURE_OPTION_VALUE);
                }
                printableContext.put(SECURE_OPTION_KEY, secureOptions);
            }
            if (dataContext.containsKey(OPTION_KEY)) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.putAll(dataContext.get(OPTION_KEY));
                for (Map.Entry entry : options.entrySet()) {
                    if (!secureValues.contains(entry.getValue())) continue;
                    entry.setValue(SECURE_OPTION_VALUE);
                }
                printableContext.put(OPTION_KEY, options);
            }
        }
        return printableContext;
    }

    static boolean isInnerLoop(WorkflowExecutionItem item) {
        return item.getWorkflow() instanceof stepFirstWrapper;
    }

    static class stepFirstWrapper
    implements IWorkflow {
        private IWorkflow workflow;

        stepFirstWrapper(IWorkflow workflow) {
            this.workflow = workflow;
        }

        @Override
        public List<StepExecutionItem> getCommands() {
            return this.workflow.getCommands();
        }

        @Override
        public int getThreadcount() {
            return this.workflow.getThreadcount();
        }

        @Override
        public boolean isKeepgoing() {
            return this.workflow.isKeepgoing();
        }

        @Override
        public String getStrategy() {
            return "step-first";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof stepFirstWrapper)) {
                return false;
            }
            stepFirstWrapper that = (stepFirstWrapper)o;
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            return this.workflow != null ? this.workflow.hashCode() : 0;
        }
    }
}

