/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ChainedProviderService<T>
implements ProviderService<T> {
    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        T t = null;
        MissingProviderException caught = null;
        for (ProviderService<T> service : this.getServiceList()) {
            try {
                t = service.providerOfType(providerName);
            }
            catch (MissingProviderException e) {
                caught = e;
            }
            if (null == t) continue;
            return t;
        }
        if (null != caught) {
            throw caught;
        }
        throw new MissingProviderException("Provider not found", this.getName(), providerName);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        HashSet<ProviderIdent> providers = new HashSet<ProviderIdent>();
        for (ProviderService<T> service : this.getServiceList()) {
            providers.addAll(service.listProviders());
        }
        return new ArrayList<ProviderIdent>(providers);
    }

    protected abstract List<ProviderService<T>> getServiceList();
}

