/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.BasePluggableProviderService;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import java.lang.reflect.Constructor;

public abstract class FrameworkPluggableProviderService<T>
extends BasePluggableProviderService<T> {
    private Framework framework;

    protected FrameworkPluggableProviderService(String name, Framework framework, Class<? extends T> implementationClass) {
        super(name, implementationClass);
        this.framework = framework;
    }

    @Override
    public ServiceProviderLoader getPluginManager() {
        return this.framework.getPluginManager();
    }

    protected Framework getFramework() {
        return this.framework;
    }

    @Override
    protected boolean hasValidProviderSignature(Class clazz) {
        try {
            Constructor method = clazz.getDeclaredConstructor(Framework.class);
            return null != method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.hasValidProviderSignature(clazz);
        }
    }

    @Override
    protected T createProviderInstanceFromType(Class<? extends T> execClass, String providerName) throws ProviderCreationException {
        try {
            Constructor<T> method = execClass.getDeclaredConstructor(Framework.class);
            return method.newInstance(this.framework);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
        }
        return super.createProviderInstanceFromType(execClass, providerName);
    }
}

