/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ScriptDataContextUtil {
    private static File getVarDirForProject(Framework framework, String projectName) {
        IRundeckProject frameworkProject = framework.getFrameworkProjectMgr().getFrameworkProject(projectName);
        return new File(Constants.getBaseVar(new File(framework.getFilesystemFramework().getFrameworkProjectsBaseDir(), projectName).getAbsolutePath()));
    }

    public static Map<String, Map<String, String>> createScriptDataContext(Framework framework) {
        HashMap<String, String> rundeckDataContext = new HashMap<String, String>();
        HashMap<String, String> pluginDataContext = new HashMap<String, String>();
        rundeckDataContext.put("base", framework.getFilesystemFramework().getBaseDir().getAbsolutePath());
        File vardir = new File(Constants.getBaseVar(framework.getFilesystemFramework().getBaseDir().getAbsolutePath()));
        File tmpdir = new File(vardir, "tmp");
        pluginDataContext.put("vardir", vardir.getAbsolutePath());
        pluginDataContext.put("tmpdir", tmpdir.getAbsolutePath());
        HashMap<String, Map<String, String>> scriptPluginDataContext = new HashMap<String, Map<String, String>>();
        scriptPluginDataContext.put("plugin", pluginDataContext);
        scriptPluginDataContext.put("rundeck", rundeckDataContext);
        return scriptPluginDataContext;
    }

    public static Map<String, Map<String, String>> createScriptDataContextForProject(Framework framework, String projectName) {
        HashMap<String, Map<String, String>> localDataContext = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> scriptDataContext = ScriptDataContextUtil.createScriptDataContext(framework);
        localDataContext.putAll(scriptDataContext);
        HashMap<String, String> plugin1 = new HashMap<String, String>(scriptDataContext.get("plugin"));
        plugin1.put("vardir", ScriptDataContextUtil.getVarDirForProject(framework, projectName).getAbsolutePath());
        localDataContext.put("plugin", plugin1);
        HashMap<String, String> rundeck = new HashMap<String, String>(scriptDataContext.get("rundeck"));
        rundeck.put("project", projectName);
        localDataContext.put("rundeck", rundeck);
        return localDataContext;
    }
}

