/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.utils;

import com.dtolabs.client.utils.BaseHttpClient;
import com.dtolabs.client.utils.HttpClientException;
import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

abstract class HttpClientChannel
implements BaseHttpClient {
    static Logger logger = Logger.getLogger((String)HttpClientChannel.class.getName());
    private HttpClient httpc;
    private HttpMethod httpMethod;
    private InputStream resultStream;
    private String resultType;
    private int resultCode;
    private String reasonCode;
    boolean requestMade = false;
    private String requestUrl;
    private HttpMethod reqMadeMethod;
    private URL requestURL;
    private OutputStream destinationStream;
    private int contentLengthRetrieved;
    private String expectedContentType;
    private String methodType = "GET";
    private HashMap reqHeaders = new HashMap();
    private static final HashSet validMethodTypes = new HashSet();

    public HttpClientChannel(String uriSpec, Map query) throws CoreException {
        this.init(uriSpec, query);
    }

    public HttpClientChannel(String uriSpec, Map query, OutputStream destinationStream) throws CoreException {
        this(uriSpec, query);
        this.destinationStream = destinationStream;
    }

    public HttpClientChannel(String uriSpec, Map query, OutputStream destinationStream, String expectedContentType) throws CoreException {
        this(uriSpec, query, destinationStream);
        this.expectedContentType = expectedContentType;
    }

    protected void init(String uriSpec, Map query) throws CoreException {
        Integer port;
        URI uri;
        this.requestUrl = uriSpec;
        if (query != null && query.size() > 0) {
            this.requestUrl = HttpClientChannel.constructURLQuery(uriSpec, query);
        }
        try {
            uri = new URI(this.requestUrl);
        }
        catch (URISyntaxException e) {
            throw new CoreException(e.getMessage());
        }
        this.requestURL = null;
        try {
            this.requestURL = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new CoreException(e.getMessage());
        }
        logger.debug((Object)("creating connection object to URL: " + this.requestUrl));
        this.httpc = new HttpClient();
        if (null != System.getProperty("http.proxyPort") && null != System.getProperty("http.proxyHost") && null != (port = Integer.getInteger("http.proxyPort"))) {
            this.httpc.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), port.intValue());
        }
    }

    @Override
    public void setMethodType(String type) {
        if (!validMethodTypes.contains(type.toUpperCase())) {
            throw new IllegalArgumentException("Unknown method type: " + type);
        }
        this.methodType = type;
    }

    private HttpMethod initMethod() {
        if ("GET".equalsIgnoreCase(this.getMethodType())) {
            this.httpMethod = new GetMethod(this.requestUrl);
        } else if ("POST".equalsIgnoreCase(this.getMethodType())) {
            this.httpMethod = new PostMethod(this.requestUrl);
        } else if ("PUT".equalsIgnoreCase(this.getMethodType())) {
            this.httpMethod = new PutMethod(this.requestUrl);
        } else if ("DELETE".equalsIgnoreCase(this.getMethodType())) {
            this.httpMethod = new DeleteMethod(this.requestUrl);
        } else {
            throw new IllegalArgumentException("Unknown method type: " + this.getMethodType());
        }
        if (this.reqHeaders.size() > 0) {
            for (String s : this.reqHeaders.keySet()) {
                String v = (String)this.reqHeaders.get(s);
                this.httpMethod.setRequestHeader(s, v);
            }
        }
        return this.httpMethod;
    }

    static String constructURLQuery(String urlbase, Map query) {
        StringBuffer sb = new StringBuffer(urlbase);
        if (null != query) {
            sb.append("?");
            boolean seen = false;
            for (Map.Entry o : query.entrySet()) {
                if (seen) {
                    sb.append("&");
                }
                seen = true;
                Map.Entry entry = o;
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (null == val) {
                    val = "";
                }
                try {
                    sb.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(val.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void setRequestHeader(String name, String value) {
        this.reqHeaders.put(name, value);
    }

    private void setHeaders(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setRequestHeader(key, value);
        }
    }

    protected abstract RequestEntity getRequestEntity(PostMethod var1);

    protected abstract NameValuePair[] getRequestBody(PostMethod var1);

    protected abstract boolean isPostMethod();

    protected abstract void postMakeRequest();

    protected boolean preMakeRequest(HttpMethod method) throws HttpClientException {
        return true;
    }

    protected boolean doAuthentication(HttpMethod method) throws HttpClientException {
        return true;
    }

    protected boolean needsReAuthentication(int resultCode, HttpMethod method) {
        return false;
    }

    HttpClient getHttpClient() {
        return this.httpc;
    }

    @Override
    public HttpMethod getRequestMethod() {
        return this.reqMadeMethod;
    }

    public Header getResponseHeader(String name) {
        return this.reqMadeMethod.getResponseHeader(name);
    }

    @Override
    public byte[] getResponseBody() throws IOException {
        if (this.reqMadeMethod != null) {
            return this.reqMadeMethod.getResponseBody();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeRequest() throws IOException, HttpClientException {
        if (this.requestMade) {
            return;
        }
        this.requestMade = true;
        RequestEntity reqEntity = null;
        NameValuePair[] postBody = null;
        if (this.isPostMethod()) {
            this.setMethodType("POST");
        }
        HttpMethod method = this.initMethod();
        if (this.isPostMethod()) {
            reqEntity = this.getRequestEntity((PostMethod)method);
            if (null != reqEntity) {
                logger.debug((Object)("preparing to post request entity data: " + reqEntity.getContentType()));
                ((PostMethod)method).setRequestEntity(reqEntity);
            } else {
                logger.debug((Object)"preparing to post form data");
                postBody = this.getRequestBody((PostMethod)method);
                ((PostMethod)method).setRequestBody(postBody);
            }
        }
        logger.debug((Object)"calling preMakeRequest");
        if (!this.preMakeRequest(method)) {
            return;
        }
        logger.debug((Object)"calling doAuthentication...");
        if (!this.doAuthentication(method)) {
            return;
        }
        boolean bytesread = false;
        try {
            String type;
            if (!this.isPostMethod()) {
                method.setFollowRedirects(true);
            }
            logger.debug((Object)"make request...");
            this.resultCode = this.httpc.executeMethod(method);
            this.reasonCode = method.getStatusText();
            if (this.isPostMethod()) {
                method = this.checkFollowRedirect(method, this.resultCode);
            }
            logger.debug((Object)"check needs reauth...");
            if (this.needsReAuthentication(this.resultCode, method)) {
                logger.debug((Object)"re-authentication needed, performing...");
                method.releaseConnection();
                method.abort();
                method = this.initMethod();
                if (this.isPostMethod() && null != reqEntity) {
                    ((PostMethod)method).setRequestEntity(reqEntity);
                } else if (this.isPostMethod() && null != postBody) {
                    ((PostMethod)method).setRequestBody(postBody);
                }
                if (!this.doAuthentication(method)) {
                    return;
                }
                logger.debug((Object)"remaking original request...");
                this.resultCode = this.httpc.executeMethod(method);
                this.reasonCode = method.getStatusText();
                if (this.needsReAuthentication(this.resultCode, method)) {
                    throw new HttpClientException("Unauthorized Action: " + (null != method.getResponseHeader("X-Rundeck-Action-Unauthorized") ? method.getResponseHeader("X-Rundeck-Action-Unauthorized").getValue() : this.reasonCode));
                }
            }
            logger.debug((Object)"finish...");
            if (null != method.getResponseHeader("Content-Type")) {
                this.resultType = method.getResponseHeader("Content-Type").getValue();
            }
            if ((type = this.resultType) != null && type.indexOf(";") > 0) {
                type = type.substring(0, type.indexOf(";")).trim();
            }
            if (null == this.expectedContentType || this.expectedContentType.equals(type)) {
                if (null != this.destinationStream && this.resultCode >= 200 && this.resultCode < 300) {
                    this.contentLengthRetrieved = Streams.copyStreamCount(method.getResponseBodyAsStream(), this.destinationStream);
                } else {
                    ByteArrayOutputStream outputBytes = new ByteArrayOutputStream(51200);
                    Streams.copyStream(method.getResponseBodyAsStream(), outputBytes);
                    this.resultStream = new ByteArrayInputStream(outputBytes.toByteArray());
                }
            }
            this.reqMadeMethod = method;
        }
        catch (HttpException e) {
            logger.error((Object)("HTTP error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        logger.debug((Object)"Response received");
        this.postMakeRequest();
    }

    private HttpMethod checkFollowRedirect(HttpMethod method, int res) throws IOException, HttpClientException {
        if (res == 302 || res == 301 || res == 303 || res == 307) {
            Header locHeader = method.getResponseHeader("Location");
            if (locHeader == null) {
                throw new HttpClientException("Redirect with no Location header, request URL: " + method.getURI());
            }
            String location = locHeader.getValue();
            logger.debug((Object)("Follow redirect: " + res + ": " + location));
            method.releaseConnection();
            GetMethod followMethod = new GetMethod(location);
            followMethod.setFollowRedirects(true);
            this.resultCode = this.httpc.executeMethod((HttpMethod)followMethod);
            this.reasonCode = followMethod.getStatusText();
            logger.debug((Object)("Result: " + this.resultCode));
            return followMethod;
        }
        return method;
    }

    @Override
    public String getResultContentType() {
        return this.resultType;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    URL getRequestURL() {
        return this.requestURL;
    }

    @Override
    public int getContentLengthRetrieved() {
        return this.contentLengthRetrieved;
    }

    public String getExpectedContentType() {
        return this.expectedContentType;
    }

    public String getMethodType() {
        return this.methodType;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public InputStream getResultStream() {
        return this.resultStream;
    }

    static {
        validMethodTypes.add("GET");
        validMethodTypes.add("POST");
        validMethodTypes.add("PUT");
        validMethodTypes.add("DELETE");
    }
}

