/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicyCollection;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.parser.ParserException;

public class PoliciesCache
implements Iterable<PolicyCollection> {
    static final long DIR_LIST_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".DirListCheckDelay", 60000L);
    static final long FILE_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".FileCheckDelay", 60000L);
    private static final Logger logger = Logger.getLogger(PoliciesCache.class);
    static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".aclpolicy");
        }
    };
    private Set<File> warned = new HashSet<File>();
    private Map<File, CacheItem> cache = new HashMap<File, CacheItem>();
    private DocumentBuilder builder;
    private File rootDir;
    private File singleFile;
    long lastDirListCheckTime = 0L;
    private File[] lastDirList;
    private Map<File, Long> cooldownset = Collections.synchronizedMap(new HashMap());

    public PoliciesCache() throws ParserConfigurationException {
        this(null);
    }

    public PoliciesCache(File rootDir) throws ParserConfigurationException {
        this.rootDir = rootDir;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        this.builder = domFactory.newDocumentBuilder();
        this.builder.setErrorHandler(null);
    }

    public PoliciesCache(File singleFile, boolean single) throws ParserConfigurationException {
        this.singleFile = singleFile;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        this.builder = domFactory.newDocumentBuilder();
        this.builder.setErrorHandler(null);
    }

    private File[] listDirFiles() {
        if (System.currentTimeMillis() - this.lastDirListCheckTime > DIR_LIST_CHECK_DELAY) {
            this.doListDir();
        }
        return this.lastDirList;
    }

    private void doListDir() {
        File[] fileArray;
        if (null != this.rootDir) {
            fileArray = this.rootDir.listFiles(filenameFilter);
        } else if (this.singleFile != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.singleFile;
        } else {
            fileArray = new File[]{};
        }
        this.lastDirList = fileArray;
        this.lastDirListCheckTime = System.currentTimeMillis();
    }

    public synchronized void add(File file) throws PoliciesParseException {
        this.getDocument(file);
    }

    private PolicyCollection createEntry(File file) throws PoliciesParseException {
        try {
            return new YamlPolicyCollection(file);
        }
        catch (ParserException e1) {
            throw new PoliciesParseException("YAML syntax error: " + e1.toString(), e1);
        }
        catch (Exception e1) {
            throw new PoliciesParseException(e1);
        }
    }

    public synchronized PolicyCollection getDocument(File file) throws PoliciesParseException {
        CacheItem entry = this.cache.get(file);
        long checkTime = System.currentTimeMillis();
        if (null == entry || checkTime - entry.cacheTime > FILE_CHECK_DELAY) {
            long lastmod = file.lastModified();
            if (null == entry || lastmod > entry.modTime) {
                if (!file.exists()) {
                    CacheItem remove = this.cache.remove(file);
                    entry = null;
                } else {
                    PolicyCollection entry1 = this.createEntry(file);
                    if (null != entry1) {
                        entry = new CacheItem(entry1, lastmod);
                        this.cache.put(file, entry);
                    } else {
                        this.cache.remove(file);
                        entry = null;
                    }
                }
            } else {
                entry.touch(checkTime);
            }
        }
        return null != entry ? entry.policyCollection : null;
    }

    @Override
    public Iterator<PolicyCollection> iterator() {
        File[] files = this.listDirFiles();
        return new cacheIterator(null != files ? Arrays.asList(files).iterator() : new ArrayList().iterator());
    }

    private class cacheIterator
    implements Iterator<PolicyCollection> {
        Iterator<File> intIter;
        private File nextFile;
        private PolicyCollection nextDocument;

        public cacheIterator(Iterator<File> intIter) {
            this.intIter = intIter;
            this.nextFile = this.intIter.hasNext() ? this.intIter.next() : null;
            this.loadNextDocument();
        }

        private void loadNextDocument() {
            while (this.hasNextFile() && null == this.nextDocument) {
                File nextFile2 = this.getNextFile();
                Long aLong = (Long)PoliciesCache.this.cooldownset.get(nextFile2);
                if (null != aLong && nextFile2.lastModified() == aLong.longValue()) {
                    logger.debug((Object)("Skip parsing of: " + nextFile2 + ". Reason: parse error cooldown until modified"));
                    continue;
                }
                if (null != aLong) {
                    PoliciesCache.this.cooldownset.remove(nextFile2);
                }
                try {
                    this.nextDocument = PoliciesCache.this.getDocument(nextFile2);
                }
                catch (PoliciesParseException e) {
                    logger.error((Object)("ERROR unable to parse aclpolicy: " + nextFile2 + ". Reason: " + e.getMessage()));
                    logger.debug((Object)("ERROR unable to parse aclpolicy: " + nextFile2 + ". Reason: " + e.getMessage()), (Throwable)e);
                    PoliciesCache.this.cache.remove(nextFile2);
                    PoliciesCache.this.cooldownset.put(nextFile2, nextFile2.lastModified());
                }
            }
        }

        private File getNextFile() {
            File next = this.nextFile;
            this.nextFile = this.intIter.hasNext() ? this.intIter.next() : null;
            return next;
        }

        private PolicyCollection getNextDocument() {
            PolicyCollection doc = this.nextDocument;
            this.nextDocument = null;
            this.loadNextDocument();
            return doc;
        }

        public boolean hasNextFile() {
            return null != this.nextFile;
        }

        @Override
        public boolean hasNext() {
            return null != this.nextDocument;
        }

        @Override
        public PolicyCollection next() {
            return this.getNextDocument();
        }

        @Override
        public void remove() {
        }
    }

    private static class CacheItem {
        PolicyCollection policyCollection;
        Long cacheTime;
        Long modTime;

        private CacheItem(PolicyCollection policyCollection, Long modTime) {
            this.policyCollection = policyCollection;
            this.modTime = modTime;
            this.cacheTime = System.currentTimeMillis();
        }

        public void touch(Long time) {
            this.cacheTime = time;
        }
    }
}

