/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.LdapGroup;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YamlPolicyCollection
implements PolicyCollection {
    static Logger logger = Logger.getLogger((String)YamlPolicyCollection.class.getName());
    private final Set<YamlPolicy> all = new HashSet<YamlPolicy>();
    File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlPolicyCollection(File file) throws IOException {
        Yaml yaml = new Yaml();
        this.file = file;
        int index = 1;
        try (FileInputStream stream = new FileInputStream(this.file);){
            for (Object yamlDoc : yaml.loadAll((InputStream)stream)) {
                Object yamlDoc1 = yamlDoc;
                if (yamlDoc1 instanceof Map) {
                    try {
                        YamlPolicy yamlPolicy = new YamlPolicy((Map)yamlDoc1, file, index);
                        this.all.add(yamlPolicy);
                    }
                    catch (YamlPolicy.AclPolicySyntaxException e) {
                        logger.error((Object)("ERROR parsing a policy in file: " + file + "[" + index + "]. Reason: " + e.getMessage()));
                        logger.debug((Object)("ERROR parsing a policy in file: " + file + "[" + index + "]. Reason: " + e.getMessage()), (Throwable)e);
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public Collection<String> groupNames() {
        ArrayList<String> groups = new ArrayList<String>();
        for (YamlPolicy policy : this.all) {
            for (String policyGroup : policy.getGroups()) {
                groups.add(policyGroup);
            }
        }
        return groups;
    }

    @Override
    public long countPolicies() {
        return this.all.size();
    }

    @Override
    public Collection<AclContext> matchedContexts(Subject subject, Set<Attribute> environment) {
        return YamlPolicyCollection.policyMatcher(subject, this.all, environment, this.file);
    }

    static Collection<AclContext> policyMatcher(Subject subject, Collection<? extends Policy> policyLister, Set<Attribute> environment, File file) {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        int i = 0;
        Set<Username> userPrincipals = subject.getPrincipals(Username.class);
        HashSet<String> usernamePrincipals = new HashSet<String>();
        if (userPrincipals.size() > 0) {
            for (Username username : userPrincipals) {
                usernamePrincipals.add(username.getName());
            }
        }
        Set<Group> groupPrincipals = subject.getPrincipals(Group.class);
        HashSet<Object> groupNames = new HashSet<Object>();
        if (groupPrincipals.size() > 0) {
            for (Group group : groupPrincipals) {
                if (group instanceof LdapGroup) {
                    try {
                        groupNames.add(new LdapName(group.getName()));
                    }
                    catch (InvalidNameException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                groupNames.add(group.getName());
            }
        }
        for (Policy policy : policyLister) {
            long userMatchStart = System.currentTimeMillis();
            if (null != policy.getEnvironment()) {
                EnvironmentalContext environment1 = policy.getEnvironment();
                if (!environment1.isValid()) {
                    logger.warn((Object)(policy.toString() + ": Context section not valid: " + environment1.toString()));
                }
                if (!environment1.matches(environment)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(policy.toString() + ": environment not matched: " + environment1.toString()));
                    continue;
                }
            } else if (null != environment && environment.size() > 0) {
                logger.debug((Object)(policy.toString() + ": empty environment not matched"));
                continue;
            }
            if (usernamePrincipals.size() > 0) {
                Set<String> policyUsers = policy.getUsernames();
                if (!Collections.disjoint(policyUsers, usernamePrincipals) || YamlPolicyCollection.matchesAnyPatterns(usernamePrincipals, policy.getUsernamePatterns())) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyUsers.size() > 0 && logger.isDebugEnabled()) {
                    logger.debug((Object)(policy.toString() + ": username not matched: " + policyUsers));
                }
            }
            if (groupNames.size() > 0) {
                Set<String> policyGroups = policy.getGroups();
                if (!Collections.disjoint(policyGroups, groupNames) || YamlPolicyCollection.matchesAnyPatterns(groupNames, policy.getGroupPatterns())) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyGroups.size() > 0 && logger.isDebugEnabled()) {
                    logger.debug((Object)(policy.toString() + ": group not matched: " + policyGroups));
                }
            }
            ++i;
        }
        logger.debug((Object)(file.getAbsolutePath() + ": matched contexts: " + matchedContexts.size()));
        return matchedContexts;
    }

    static boolean matchesAnyPatterns(Set<?> groupNames, Set<Pattern> groupPatterns) {
        for (Pattern groupPattern : groupPatterns) {
            for (Object groupName : groupNames) {
                if (!groupPattern.matcher(groupName.toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

