/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.utils.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class CLIUtils {
    public static final Predicate stringContainsWhitespacePredicate = new Predicate(){

        public boolean evaluate(Object o) {
            return CLIUtils.containsSpace((String)o);
        }
    };
    public static final Predicate stringContainsQuotePredicate = new Predicate(){

        public boolean evaluate(Object o) {
            return CLIUtils.containsQuote((String)o);
        }
    };
    public static final Converter<String, String> UNIX_ARGUMENT_QUOTE = new Converter<String, String>(){

        @Override
        public String convert(String s) {
            return CLIUtils.quoteUnixShellArg(s);
        }
    };
    public static final Converter<String, String> UNIX_SHELL_ESCAPE = new Converter<String, String>(){

        @Override
        public String convert(String s) {
            return CLIUtils.escapeUnixShellChars(s);
        }
    };
    private static final String UNIX_SHELL_CHARS = "\"';{}()&$\\|*?><";
    private static final String WS_CHARS = "\n\r\t";

    public static String generateArgline(String scriptpath, String[] args) {
        return CLIUtils.generateArgline(scriptpath, args, " ", false);
    }

    public static String generateArgline(String scriptpath, String[] args, Boolean unsafe) {
        return CLIUtils.generateArgline(scriptpath, args, " ", unsafe);
    }

    public static String generateArgline(String scriptpath, String[] args, String separator, Boolean unsafe) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        if (null != scriptpath) {
            list.add(scriptpath);
        }
        if (null != args) {
            list.addAll(Arrays.asList(args));
        }
        for (String arg : list) {
            if (null == arg) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            if (unsafe.booleanValue()) {
                if (arg.indexOf(" ") >= 0 && (0 != arg.indexOf("'") || arg.length() - 1 != arg.lastIndexOf("'"))) {
                    sb.append("'").append(arg).append("'");
                    continue;
                }
                sb.append(arg);
                continue;
            }
            CLIUtils.quoteUnixShellArg(sb, arg);
        }
        return sb.toString();
    }

    public static boolean containsSpace(String arg) {
        return StringUtils.containsAny((String)arg, (String)" ");
    }

    public static boolean containsQuote(String arg) {
        return StringUtils.containsAny((String)arg, (String)"'");
    }

    public static String quoteUnixShellArg(String arg) {
        StringBuilder stringBuilder = new StringBuilder();
        CLIUtils.quoteUnixShellArg(stringBuilder, arg);
        return stringBuilder.toString();
    }

    private static void quoteUnixShellArg(StringBuilder sb, String arg) {
        if (StringUtils.containsNone((String)arg, (String)UNIX_SHELL_CHARS) && StringUtils.containsNone((String)arg, (String)WS_CHARS) && StringUtils.containsNone((String)arg, (String)" ")) {
            if (arg != null) {
                sb.append(arg);
            }
            return;
        }
        sb.append("'");
        sb.append(arg.replace("'", "'\"'\"'"));
        sb.append("'");
    }

    public static Converter<String, String> characterEscapeForOperatingSystem(String type) {
        Converter<String, String> defaultConverter = UNIX_SHELL_ESCAPE;
        if ("unix".equalsIgnoreCase(type)) {
            return UNIX_SHELL_ESCAPE;
        }
        return defaultConverter;
    }

    public static Converter<String, String> argumentQuoteForOperatingSystem(String type) {
        Converter<String, String> defaultConverter = UNIX_ARGUMENT_QUOTE;
        if ("unix".equalsIgnoreCase(type)) {
            return UNIX_ARGUMENT_QUOTE;
        }
        return defaultConverter;
    }

    public static String escapeUnixShellChars(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        CLIUtils.escapeUnixShellChars(stringBuilder, str);
        return stringBuilder.toString();
    }

    public static void escapeUnixShellChars(StringBuilder out, String str) {
        if (StringUtils.containsNone((String)str, (String)UNIX_SHELL_CHARS)) {
            if (str != null) {
                out.append(str);
            }
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (UNIX_SHELL_CHARS.indexOf(c) >= 0) {
                out.append('\\');
            } else if (WS_CHARS.indexOf(c) >= 0) {
                out.append('\\');
                if (c == '\r') {
                    out.append('r');
                    continue;
                }
                if (c == '\n') {
                    out.append('n');
                    continue;
                }
                if (c != '\t') continue;
                out.append('t');
                continue;
            }
            out.append(c);
        }
    }
}

