/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.acl;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.SAREAuthorization;
import com.dtolabs.rundeck.core.cli.BaseTool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.DefaultCLIToolLogger;
import com.dtolabs.rundeck.core.cli.Log4JCLIToolLogger;
import com.dtolabs.rundeck.core.cli.jobs.JobsToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AclTool
extends BaseTool {
    public static final Logger log4j = Logger.getLogger(AclTool.class);
    public static final String FILE_OPTION = "f";
    public static final String FILE_OPTION_LONG = "file";
    public static final String DIR_OPTION = "d";
    public static final String DIR_OPTION_LONG = "dir";
    public static final String ALLOW_LONG_OPT = "allow";
    public static final String ALLOW_OPT = "a";
    public static final String GROUPS_LONG_OPT = "groups";
    public static final String GROUPS_OPT = "g";
    public static final String USER_OPT = "u";
    public static final String USER_LONG_OPT = "user";
    public static final String PROJECT_OPT = "p";
    public static final String PROJECT_LONG_OPT = "project";
    public static final String JOB_OPT = "j";
    public static final String JOB_LONG_OPT = "job";
    public static final String CONTEXT_OPT = "c";
    public static final String CONTEXT_LONG_OPT = "context";
    public static final String ADHOC_OPT = "A";
    public static final String ADHOC_LONG_OPT = "adhoc";
    public static final String NODE_OPT = "n";
    public static final String NODE_LONG_OPT = "node";
    public static final String TAGS_OPT = "t";
    public static final String TAGS_LONG_OPT = "tags";
    public static final String DENY_OPT = "D";
    public static final String DENY_LONG_OPT = "deny";
    public static final String VERBOSE_OPT = "v";
    public static final String VERBOSE_LONG_OPT = "verbose";
    public static final String STORAGE_OPT = "s";
    public static final String STORAGE_LONG_OPT = "storage";
    public static final String GENERIC_OPT = "G";
    public static final String GENERIC_LONG_OPT = "generic";
    public static final String RESOURCE_OPT = "R";
    public static final String RESOURCE_LONG_OPT = "resource";
    public static final String INPUT_OPT = "i";
    public static final String INPUT_OPT_LONG = "input";
    public static final String REGEX_OPT = "r";
    public static final String REGEX_OPT_LONG = "regex";
    public static final String ATTRS_OPT = "b";
    public static final String ATTRS_OPT_LONG = "attributes";
    public static final String LIST_OPT = "l";
    public static final String LIST_OPT_LONG = "list";
    final CLIToolLogger clilogger;
    private Actions action = null;
    private String configDir;
    public static final String ACTION_TEST = "test";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_LIST = "list";
    private boolean argVerbose;
    private boolean argList;
    private File argFile;
    private File argDir;
    private String argDenyAction;
    private List<String> actionsDenyList;
    private String argAllowAction;
    private List<String> actionsAllowList;
    private String argGroups;
    private List<String> groupsList;
    private String argUser;
    private Context argContext;
    private String argProject;
    private String argProjectJob;
    private String argProjectNode;
    private String argTags;
    private List<String> tagsSet;
    private boolean argProjectAdhoc;
    private String argAppStorage;
    private String argGenericType;
    private String argResource;
    private String argInput;
    private boolean argRegex;
    private Map<String, String> attrsMap;
    private boolean attrHelp;
    static final Set<String> projectTypes = new HashSet<String>(Arrays.asList("adhoc", "job", "node"));
    static final Set<String> projectKinds = new HashSet<String>(Arrays.asList("job", "node", "event"));
    static final Set<String> appTypes = new HashSet<String>(Arrays.asList("project", "storage"));
    static final Set<String> appKinds = new HashSet<String>(Arrays.asList("project", "system", "user", "job"));
    static final List<String> appProjectActions = Arrays.asList("admin", "read", "configure", "delete", "import", "export", "delete_execution");
    static final List<String> appStorageActions = Arrays.asList("create", "read", "update", "delete");
    static final List<String> appProjectKindActions = Arrays.asList("create");
    static final List<String> appSystemKindActions = Arrays.asList("read");
    static final List<String> appUserKindActions = Arrays.asList("admin");
    static final List<String> appJobKindActions = Arrays.asList("admin");
    static final Map<String, List<String>> appResActionsByType = new HashMap<String, List<String>>();
    static final Map<String, List<String>> appResAttrsByType;
    static final Map<String, List<String>> appKindActionsByType;
    static final List<String> projectJobActions;
    static final List<String> projectJobKindActions;
    static final List<String> projectAdhocActions;
    static final List<String> projectNodeActions;
    static final Map<String, List<String>> projResActionsByType;
    static final Map<String, List<String>> projResAttrsByType;
    static final List<String> projectNodeKindActions;
    static final List<String> projectEventKindActions;
    static final Map<String, List<String>> projKindActionsByType;

    public AclTool(CLIToolLogger cliToolLogger) throws IOException, PoliciesParseException {
        this(cliToolLogger, Constants.getSystemBaseDir());
    }

    public AclTool(CLIToolLogger cliToolLogger, String rdeckBase) throws IOException, PoliciesParseException {
        this(cliToolLogger, rdeckBase, null != rdeckBase ? FrameworkFactory.createFilesystemFramework(new File(rdeckBase)).getPropertyLookup() : null);
    }

    public AclTool(CLIToolLogger cliToolLogger, String rdeckBase, IPropertyLookup frameworkProps) throws IOException, PoliciesParseException {
        if (null == cliToolLogger) {
            PropertyConfigurator.configure((String)Constants.getLog4jPropertiesFile().getAbsolutePath());
            this.clilogger = new Log4JCLIToolLogger(log4j);
        } else {
            this.clilogger = cliToolLogger;
        }
        if (null != frameworkProps) {
            this.configDir = frameworkProps.hasProperty("framework.etc.dir") ? frameworkProps.getProperty("framework.etc.dir") : Constants.getFrameworkConfigDir(rdeckBase);
        }
        TestOptions testOptions = new TestOptions();
        this.addToolOptions(testOptions);
    }

    private SAREAuthorization createAuthorization(File directory) throws IOException, PoliciesParseException {
        return new SAREAuthorization(directory);
    }

    private SAREAuthorization createAuthorizationSingleFile(File file) throws IOException, PoliciesParseException {
        return new SAREAuthorization(Policies.loadFile(file));
    }

    public static void main(String[] args) throws Exception {
        AclTool tool = new AclTool(new DefaultCLIToolLogger());
        tool.setShouldExit(true);
        int exitCode = 1;
        try {
            tool.run(args);
            exitCode = 0;
        }
        catch (OptionsPrompt e) {
            exitCode = 2;
            tool.error(e.getMessage());
            tool.error(e.getPrompt());
            if (tool.argVerbose) {
                e.printStackTrace();
            }
        }
        catch (CLIToolOptionsException e) {
            exitCode = 2;
            tool.error(e.getMessage());
            if (tool.argVerbose) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            if (e.getMessage() == null || tool.argVerbose) {
                e.printStackTrace();
            }
            tool.error("Error: " + e.getMessage());
        }
        tool.exit(exitCode);
    }

    @Override
    protected boolean isUseHelpOption() {
        return true;
    }

    @Override
    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        CommandLine line = super.parseArgs(args);
        if (args.length > 0 && !args[0].startsWith("-")) {
            try {
                this.action = Actions.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CLIToolOptionsException("Invalid action: " + args[0] + ", must be one of: " + Arrays.toString((Object[])Actions.values()));
            }
        }
        if (line.hasOption("h")) {
            this.help();
            this.exit(1);
        }
        return line;
    }

    @Override
    protected void go() throws JobsToolException, CLIToolOptionsException {
        if (null == this.action) {
            throw new CLIToolOptionsException("Command expected. Choose one of: " + Arrays.asList(Actions.values()));
        }
        try {
            switch (this.action) {
                case list: {
                    this.listAction();
                    break;
                }
                case test: {
                    this.testAction();
                    break;
                }
                case create: {
                    this.createAction();
                    break;
                }
                default: {
                    throw new CLIToolOptionsException("Unrecognized action: " + (Object)((Object)this.action));
                }
            }
        }
        catch (PoliciesParseException | IOException e) {
            throw new JobsToolException(e);
        }
    }

    private void listAction() throws CLIToolOptionsException, IOException, PoliciesParseException {
        Map<String, Object> resourceMap;
        SAREAuthorization authorization = this.createAuthorization();
        Subject subject = this.createSubject();
        String subjdesc = null != this.argGroups ? "group " + this.argGroups : "username " + this.argUser;
        this.log("# Application Context access for " + subjdesc + "\n");
        if (null != this.argProject) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("name", this.argProject);
            resourceMap = AuthorizationUtil.resourceRule(PROJECT_LONG_OPT, res);
            this.logDecisions("project named \"" + this.argProject + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(appProjectActions), Framework.RUNDECK_APP_ENV);
        } else {
            this.log("\n(No project (-p) specified, skipping Application context actions for a specific project.)\n");
        }
        if (null != this.argAppStorage) {
            Map<String, Object> resourceMap2 = this.createStorageResource();
            this.logDecisions("storage path \"" + this.argAppStorage + "\"", authorization, subject, this.resources(resourceMap2), new HashSet<String>(appStorageActions), Framework.RUNDECK_APP_ENV);
        } else {
            this.log("\n(No storage path (-s) specified, skipping Application context actions for a specific storage path.)\n");
        }
        for (String kind : appKindActionsByType.keySet()) {
            this.logDecisions(kind, authorization, subject, this.resources(AuthorizationUtil.resourceTypeRule(kind)), new HashSet<String>((Collection)appKindActionsByType.get(kind)), Framework.RUNDECK_APP_ENV);
        }
        if (null == this.argProject) {
            this.log("\n(No project (-p) specified, skipping Project context listing.)");
            return;
        }
        Set<Attribute> projectEnv = FrameworkProject.authorizationEnvironment(this.argProject);
        this.log("\n# Project \"" + this.argProject + "\" access for " + subjdesc + "\n");
        this.logDecisions("Adhoc executions", authorization, subject, this.resources(this.createProjectAdhocResource()), new HashSet<String>(projectAdhocActions), projectEnv);
        if (null != this.argProjectJob) {
            resourceMap = this.createProjectJobResource();
            this.logDecisions("Job \"" + this.argProjectJob + "\"", authorization, subject, this.resources(resourceMap), new HashSet<String>(projectJobActions), projectEnv);
        } else {
            this.log("\n(No job (-j) specified, skipping Project context actions for a specific job.)\n");
        }
        if (null != this.argProjectNode || null != this.argTags) {
            resourceMap = this.createProjectNodeResource();
            this.logDecisions("Node " + (null != this.argProjectNode ? "\"" + this.argProjectNode + "\"" : "") + (null != this.argTags ? " tags: " + this.argTags : ""), authorization, subject, this.resources(resourceMap), new HashSet<String>(projectNodeActions), projectEnv);
        } else {
            this.log("\n(No node (-n) or tags (-t) specified, skipping Project context actions for a specific node or node tags.)\n");
        }
        for (String kind : projKindActionsByType.keySet()) {
            this.logDecisions(kind, authorization, subject, this.resources(AuthorizationUtil.resourceTypeRule(kind)), new HashSet<String>((Collection)projKindActionsByType.get(kind)), projectEnv);
        }
    }

    private HashSet<Map<String, String>> resources(Map<String, Object> ... resourceMap) {
        HashSet<Map<String, String>> resource = new HashSet<Map<String, String>>();
        for (Map<String, Object> stringObjectMap : resourceMap) {
            resource.add(this.toStringMap(stringObjectMap));
        }
        return resource;
    }

    private void logDecisions(String title, SAREAuthorization authorization, Subject subject, HashSet<Map<String, String>> resource, HashSet<String> actions, Set<Attribute> env) {
        for (Decision decision : authorization.evaluate(resource, subject, actions, env)) {
            this.log((decision.isAuthorized() ? "+" : (decision.explain().getCode() == Explanation.Code.REJECTED_DENIED ? "!" : "-")) + " " + decision.getAction() + ": " + title + (decision.isAuthorized() ? "" : " [" + (Object)((Object)decision.explain().getCode()) + "]"));
            if (decision.isAuthorized() || decision.explain().getCode() != Explanation.Code.REJECTED_DENIED) continue;
            this.verbose("  " + decision.explain().toString());
        }
    }

    private AuthRequest createAuthRequestFromArgs() throws CLIToolOptionsException, IOException, PoliciesParseException {
        ArrayList<String> invalid;
        if (null == this.argContext) {
            throw new OptionsPrompt(this.optionDisplayString(CONTEXT_OPT, false) + " is required.", "Choose one of: \n  -c " + (Object)((Object)Context.application) + "\n" + "    Access to projects, users, storage, system info.\n" + "  -c " + (Object)((Object)Context.project) + "\n" + "    Access to jobs, nodes, events, within a project.");
        }
        if (this.argContext == Context.project && null == this.argProject) {
            throw new OptionsPrompt(this.optionDisplayString(PROJECT_OPT, false) + " is required.", "Choose the name of a project, or .*: \n  -p myproject\n  -p '.*'");
        }
        boolean appContext = this.argContext == Context.application;
        Set<Attribute> environment = appContext ? Framework.RUNDECK_APP_ENV : FrameworkProject.authorizationEnvironment(this.argProject);
        Subject subject = this.createSubject();
        Map<Object, Object> resourceMap = new HashMap();
        if (this.argContext == Context.application && this.argResource != null) {
            if (!appTypes.contains(this.argResource.toLowerCase())) {
                throw new OptionsPrompt(this.optionDisplayString(RESOURCE_OPT, false) + " invalid resource type: " + this.argResource, "  resource types in application context:     " + StringUtils.join(appTypes, (String)"\n    "));
            }
            resourceMap = AuthorizationUtil.resourceRule(this.argResource.toLowerCase(), null);
        } else if (this.argContext == Context.project && this.argResource != null) {
            if (!projectTypes.contains(this.argResource.toLowerCase())) {
                throw new OptionsPrompt(this.optionDisplayString(RESOURCE_OPT, false) + " invalid resource type: " + this.argResource, "  resource types in project context:     " + StringUtils.join(projectTypes, (String)"\n    "));
            }
            resourceMap = AuthorizationUtil.resourceRule(this.argResource.toLowerCase(), null);
        } else if (this.argContext == Context.application && this.argProject != null) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("name", this.argProject);
            resourceMap = AuthorizationUtil.resourceRule(PROJECT_LONG_OPT, res);
        } else if (this.argContext == Context.application && this.argAppStorage != null) {
            resourceMap = this.createStorageResource();
        } else if (this.argContext == Context.project && this.argProjectJob != null) {
            resourceMap = this.createProjectJobResource();
        } else if (this.argContext == Context.project && (this.argProjectNode != null || this.argTags != null)) {
            resourceMap = this.createProjectNodeResource();
        } else if (this.argContext == Context.project && this.argProjectAdhoc) {
            resourceMap = this.createProjectAdhocResource();
        } else if (this.argContext == Context.project && null != this.argGenericType) {
            if (!projectKinds.contains(this.argGenericType.toLowerCase())) {
                throw new OptionsPrompt(this.optionDisplayString(GENERIC_OPT, false) + " invalid generic kind: " + this.argGenericType, "  generic kinds in this context:     " + StringUtils.join(projectKinds, (String)"\n    "));
            }
            resourceMap = AuthorizationUtil.resourceTypeRule(this.argGenericType.toLowerCase());
        } else if (this.argContext == Context.application && null != this.argGenericType) {
            if (!appKinds.contains(this.argGenericType.toLowerCase())) {
                throw new OptionsPrompt(this.optionDisplayString(GENERIC_OPT, false) + " invalid generic kind: " + this.argGenericType, "  generic kind in this context:     " + StringUtils.join(appKinds, (String)"\n    "));
            }
            resourceMap = AuthorizationUtil.resourceTypeRule(this.argGenericType.toLowerCase());
        } else {
            if (this.argContext == Context.project) {
                throw new OptionsPrompt("Project-context resource option is required.", "Possible options:\n  Job: " + this.optionDisplayString(JOB_OPT) + "\n" + "    View, modify, create*, delete*, run, and kill specific jobs.\n" + "    * Create and delete also require additional " + this.optionDisplayString(GENERIC_OPT) + " level access.\n" + "  Adhoc: " + this.optionDisplayString(ADHOC_OPT) + "\n" + "    View, run, and kill adhoc commands.\n" + "  Node: " + this.optionDisplayString(NODE_OPT) + "\n" + "      : " + this.optionDisplayString(TAGS_OPT) + "\n" + "    View and run on specific nodes by name or tag.\n" + "  Resource: " + this.optionDisplayString(RESOURCE_OPT) + "\n" + "    Specify the resource type directly. " + this.optionDisplayString(ATTRS_OPT) + " should also be used.\n" + "    resource types in this context: \n" + "    " + StringUtils.join(projectTypes, (String)"\n    ") + "\n" + "  Generic: " + this.optionDisplayString(GENERIC_OPT) + "\n" + "    Create and delete jobs.\n" + "    View and manage nodes.\n" + "    View events.\n" + "    generic kinds in this context: \n" + "    " + StringUtils.join(projectKinds, (String)"\n    "));
            }
            throw new OptionsPrompt("Application-context resource option is required.", "Possible options:\n  Project: " + this.optionDisplayString(PROJECT_OPT) + "\n" + "    Visibility, import, export, config, and delete executions.\n" + "    *Note: Project create requires additional " + this.optionDisplayString(GENERIC_OPT) + " level access.\n" + "  Storage: " + this.optionDisplayString(STORAGE_OPT) + "\n" + "    CRUD access for the key storage system.\n" + "  Resource: " + this.optionDisplayString(RESOURCE_OPT) + "\n" + "    Specify the resource type directly. " + this.optionDisplayString(ATTRS_OPT) + " should also be used.\n" + "    resource types in this context: \n" + "    " + StringUtils.join(appTypes, (String)"\n    ") + "\n" + "  Generic: " + this.optionDisplayString(GENERIC_OPT) + "\n" + "    Create projects, read system info, manage users.\n" + "    generic kinds" + " in this context: \n" + "    " + StringUtils.join(appKinds, (String)"\n    "));
        }
        if (null != this.attrsMap && this.attrsMap.size() > 0) {
            resourceMap.putAll(this.attrsMap);
        } else if (this.attrHelp && null != this.argResource && !this.argResource.equalsIgnoreCase(ADHOC_LONG_OPT)) {
            List<String> possibleAttrs = (this.argContext == Context.application ? appResAttrsByType : projResAttrsByType).get(this.argResource.toLowerCase());
            throw new OptionsPrompt(this.optionDisplayString(ATTRS_OPT) + " should be specified when " + this.optionDisplayString(RESOURCE_OPT) + " is used", "Possible attributes for resource type " + this.argResource + " in this context:\n" + "  " + StringUtils.join(possibleAttrs, (String)"\n  "));
        }
        ArrayList<String> possibleActions = new ArrayList<String>(Arrays.asList("*"));
        if (this.argContext == Context.application && null != this.argResource) {
            possibleActions.addAll((Collection<String>)appResActionsByType.get(this.argResource));
        } else if (this.argContext == Context.project && null != this.argResource) {
            possibleActions.addAll((Collection<String>)projResActionsByType.get(this.argResource));
        } else if (this.argContext == Context.application && this.argAppStorage != null) {
            possibleActions.addAll(appStorageActions);
        } else if (this.argContext == Context.application && this.argProject != null) {
            possibleActions.addAll(appProjectActions);
        } else if (this.argContext == Context.application && this.argGenericType != null) {
            possibleActions.addAll((Collection<String>)appKindActionsByType.get(this.argGenericType.toLowerCase()));
        } else if (this.argContext == Context.project && this.argGenericType != null) {
            possibleActions.addAll((Collection<String>)projKindActionsByType.get(this.argGenericType.toLowerCase()));
        } else if (this.argContext == Context.project && this.argProjectJob != null) {
            possibleActions.addAll(projectJobActions);
        } else if (this.argContext == Context.project && this.argProjectAdhoc) {
            possibleActions.addAll(projectAdhocActions);
        } else if (this.argContext == Context.project && (this.argProjectNode != null || this.argTags != null)) {
            possibleActions.addAll(projectNodeActions);
        }
        if (null == this.argAllowAction && null == this.argDenyAction) {
            throw new OptionsPrompt(this.optionDisplayString(ALLOW_OPT) + " or " + this.optionDisplayString(DENY_OPT) + " is required.", "Possible actions in this context: \n  " + StringUtils.join(possibleActions, (String)"\n  "));
        }
        if (null != this.argAllowAction) {
            invalid = new ArrayList<String>();
            for (String s : this.actionsAllowList) {
                if (possibleActions.contains(s)) continue;
                invalid.add(s);
            }
            if (invalid.size() > 0) {
                throw new OptionsPrompt(this.optionDisplayString(ALLOW_OPT, false) + " specified invalid actions.", "These actions are not valid for the context:  " + StringUtils.join(invalid, (String)"\n  ") + "Possible actions in this context: \n" + "  " + StringUtils.join(possibleActions, (String)"\n  "));
            }
        }
        if (null != this.argDenyAction) {
            invalid = new ArrayList();
            for (String s : this.actionsDenyList) {
                if (possibleActions.contains(s)) continue;
                invalid.add(s);
            }
            if (invalid.size() > 0) {
                throw new OptionsPrompt(this.optionDisplayString(DENY_OPT, false) + " specified invalid actions.", "These actions are not valid for the context:\n  " + StringUtils.join(invalid, (String)"\n  ") + "\n\n" + "Possible actions in this context:\n" + "  " + StringUtils.join(possibleActions, (String)"\n  "));
            }
        }
        AuthRequest request = new AuthRequest();
        request.resourceMap = resourceMap;
        request.subject = subject;
        if (null != this.actionsAllowList) {
            request.actions = new HashSet<String>(this.actionsAllowList);
        }
        request.environment = environment;
        if (null != this.actionsDenyList) {
            request.denyActions = new HashSet<String>(this.actionsDenyList);
        }
        request.regexMatch = this.argRegex;
        request.containsMatch = this.argContext == Context.project && this.argTags != null;
        return request;
    }

    private Map<String, Object> createProjectNodeResource() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (null != this.argProjectNode) {
            res.put("nodename", this.argProjectNode);
        }
        if (null != this.argTags) {
            res.put(TAGS_LONG_OPT, this.tagsSet);
        }
        Map<String, Object> resourceMap = AuthorizationUtil.resourceRule(NODE_LONG_OPT, res);
        return resourceMap;
    }

    private Map<String, Object> createProjectJobResource() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        int nx = this.argProjectJob.lastIndexOf("/");
        if (nx >= 0) {
            res.put("group", this.argProjectJob.substring(0, nx));
            res.put("name", this.argProjectJob.substring(nx + 1));
        } else {
            res.put("group", "");
            res.put("name", this.argProjectJob);
        }
        Map<String, Object> resourceMap = AuthorizationUtil.resourceRule(JOB_LONG_OPT, res);
        return resourceMap;
    }

    private Map<String, Object> createProjectAdhocResource() {
        return AuthorizationUtil.resourceRule(ADHOC_LONG_OPT, new HashMap<String, Object>());
    }

    private Map<String, Object> createStorageResource() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        int nx = this.argAppStorage.lastIndexOf("/");
        if (nx >= 0) {
            res.put("path", this.argAppStorage.substring(0, nx));
            res.put("name", this.argAppStorage.substring(nx + 1));
        } else {
            res.put("name", this.argAppStorage);
        }
        Map<String, Object> resourceMap = AuthorizationUtil.resourceRule(STORAGE_LONG_OPT, res);
        return resourceMap;
    }

    private Subject createSubject() throws OptionsPrompt {
        Subject t;
        if (this.argGroups == null && this.argUser == null) {
            throw new OptionsPrompt(this.optionDisplayString(GROUPS_OPT) + " or " + this.optionDisplayString(USER_OPT) + " are required", "  -u user1,user2... \n  -g group1,group2... \n    Groups control access for a set of users, and correspond\n    to authorization roles.");
        }
        Subject subject = t = this.makeSubject(this.argUser, this.groupsList);
        return subject;
    }

    private Subject makeSubject(String argUser1user, Collection<String> groupsList1) {
        Subject t = new Subject();
        String user = argUser1user != null ? argUser1user : USER_LONG_OPT;
        t.getPrincipals().add(new Username(user));
        if (null != groupsList1) {
            for (String s : groupsList1) {
                t.getPrincipals().add(new Group(s));
            }
        }
        return t;
    }

    private void createAction() throws CLIToolOptionsException, IOException, PoliciesParseException {
        List<Object> reqs = new ArrayList<AuthRequest>();
        if (null != this.argInput) {
            reqs = this.readRequests(this.argInput);
        } else {
            reqs.add(this.createAuthRequestFromArgs());
        }
        for (AuthRequest authRequest : reqs) {
            this.generateYaml(authRequest, System.out);
        }
    }

    private List<AuthRequest> readRequests(String argInput) throws IOException {
        ArrayList<AuthRequest> reqs = new ArrayList<AuthRequest>();
        InputStreamReader input = argInput.equals("-") ? new InputStreamReader(System.in) : new FileReader(new File(argInput));
        try (BufferedReader reader = new BufferedReader(input);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains("Decision for:")) {
                    int i = line.indexOf("authorized: false");
                    if (i <= 0) {
                        this.verbose("skip line: " + line);
                        continue;
                    }
                    ParsePart res = this.parsePart("res", line, ", ", false);
                    if (null == res) {
                        this.verbose("no res< " + line);
                        continue;
                    }
                    Map<String, Object> resourceMap = res.resourceMap;
                    if (resourceMap.containsKey(TAGS_LONG_OPT) && resourceMap.get(TAGS_LONG_OPT).toString().contains(",")) {
                        List<String> tags = Arrays.asList(resourceMap.get(TAGS_LONG_OPT).toString().split(","));
                        resourceMap.put(TAGS_LONG_OPT, tags);
                    }
                    if (null == (res = this.parsePart("subject", line = line.substring(res.len), " ", true))) {
                        this.verbose("no subject<: " + line);
                        continue;
                    }
                    Map<String, Object> subjMap = res.resourceMap;
                    Subject subject = this.createSubject(subjMap);
                    if (null == subject) {
                        this.verbose("parse subject< failed: " + subjMap + ": " + line);
                        continue;
                    }
                    res = this.parseString("action", line = line.substring(res.len));
                    if (null == res) {
                        this.verbose("no action<: " + line);
                        continue;
                    }
                    String action = res.value;
                    res = this.parseString("env", line = line.substring(res.len));
                    if (null == res) {
                        this.verbose("no env<: " + line);
                        continue;
                    }
                    String env = res.value;
                    line = line.substring(res.len);
                    if (env.lastIndexOf(":") < 0 || env.lastIndexOf(":") >= env.length()) {
                        this.verbose("env parse failed: " + line);
                        continue;
                    }
                    AuthRequest request = new AuthRequest();
                    request.environment = env.equals("http://dtolabs.com/rundeck/env/application:rundeck") ? Framework.RUNDECK_APP_ENV : FrameworkProject.authorizationEnvironment(env.substring(env.lastIndexOf(":") + 1));
                    request.actions = new HashSet<String>(Arrays.asList(action));
                    request.resourceMap = resourceMap;
                    request.subject = subject;
                    reqs.add(request);
                    continue;
                }
                this.verbose("did not see start. skip line: " + line);
            }
        }
        return reqs;
    }

    private Map<String, String> toStringMap(Map<String, Object> resourceMap) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (String s : resourceMap.keySet()) {
            Object value = resourceMap.get(s);
            if (s.equals(TAGS_LONG_OPT) && value instanceof Collection) {
                r.put(s, StringUtils.join((Collection)((Collection)value), (String)","));
                continue;
            }
            r.put(s, value.toString());
        }
        return r;
    }

    private Subject createSubject(Map<String, Object> subjMap) {
        if (null == subjMap.get("Username") || !(subjMap.get("Username") instanceof String)) {
            return null;
        }
        if (null == subjMap.get("Group") || !(subjMap.get("Group") instanceof Collection) && !(subjMap.get("Group") instanceof String)) {
            return null;
        }
        Object group = subjMap.get("Group");
        List<String> groups = group instanceof Collection ? (List<String>)group : Arrays.asList((String)group);
        return this.makeSubject(subjMap.get("Username").toString(), groups);
    }

    private ParsePart parsePart(String name, String line, String delimiter, boolean allowMultiple) {
        Map<Object, Object> resourceMap = new HashMap();
        int len = 0;
        String test = line;
        int v = test.indexOf(name + "<");
        if (v < 0 || v > test.length() - (name.length() + 1)) {
            return null;
        }
        String r1 = test.substring(v + name.length() + 1);
        int v2 = r1.indexOf(">");
        if (v2 < 0) {
            return null;
        }
        String restext = r1.substring(0, v2);
        resourceMap = this.parseMap(restext, delimiter, allowMultiple);
        if (null == resourceMap) {
            return null;
        }
        len = v + name.length() + 1 + v2 + 1;
        ParsePart parsePart = new ParsePart();
        parsePart.len = len;
        parsePart.resourceMap = resourceMap;
        return parsePart;
    }

    private ParsePart parseString(String name, String line) {
        HashMap resourceMap = new HashMap();
        int len = 0;
        String test = line;
        int v = test.indexOf(name + "<");
        if (v < 0 || v > test.length() - (name.length() + 1)) {
            return null;
        }
        String r1 = test.substring(v + name.length() + 1);
        int v2 = r1.indexOf(">");
        if (v2 < 0) {
            return null;
        }
        String restext = r1.substring(0, v2);
        len = v + (name.length() + 1) + v2 + 1;
        ParsePart parsePart = new ParsePart();
        parsePart.value = restext;
        parsePart.len = len;
        return parsePart;
    }

    private Map<String, Object> parseMap(String restext, String delimiter, boolean allowMultiple) {
        String[] split = restext.split(Pattern.quote(delimiter));
        if (split.length < 1) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String aSplit : split) {
            String[] s = aSplit.split(":", 2);
            if (s.length < 2) {
                return null;
            }
            if (result.containsKey(s[0]) && allowMultiple) {
                if (result.get(s[0]) instanceof Collection) {
                    ((Collection)result.get(s[0])).add(s[1]);
                    continue;
                }
                if (!(result.get(s[0]) instanceof String)) continue;
                ArrayList<String> strings = new ArrayList<String>();
                strings.add((String)result.get(s[0]));
                strings.add(s[1]);
                result.put(s[0], strings);
                continue;
            }
            result.put(s[0], s[1]);
        }
        return result;
    }

    private void generateYaml(AuthRequest authRequest, PrintStream out) {
        Map<String, ?> data = AclTool.toDataMap(authRequest);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        out.println("# create or append this to a .aclpolicy file");
        out.println("---");
        yaml.dump(data, (Writer)new OutputStreamWriter(out));
    }

    public static Map<String, ?> toDataMap(AuthRequest authRequest) {
        HashMap<String, Object> s;
        HashMap<String, Object> stringHashMap = new HashMap<String, Object>();
        HashMap ruleMap = new HashMap();
        if (authRequest.environment.equals(Framework.RUNDECK_APP_ENV)) {
            HashMap<String, String> s2 = new HashMap<String, String>();
            s2.put("application", "rundeck");
            stringHashMap.put(CONTEXT_LONG_OPT, s2);
        } else {
            String project = authRequest.environment.iterator().next().value;
            s = new HashMap<String, Object>();
            s.put(PROJECT_LONG_OPT, project);
            stringHashMap.put(CONTEXT_LONG_OPT, s);
        }
        Set<Username> principals = authRequest.subject.getPrincipals(Username.class);
        if (principals.iterator().next().getName().equals(USER_LONG_OPT)) {
            s = new HashMap();
            ArrayList<String> strings = new ArrayList<String>();
            for (Group group : authRequest.subject.getPrincipals(Group.class)) {
                strings.add(group.getName());
            }
            s.put("group", strings.size() > 1 ? strings : (Serializable)strings.iterator().next());
            stringHashMap.put("by", s);
        } else {
            s = new HashMap();
            s.put("username", principals.iterator().next().getName());
            stringHashMap.put("by", s);
        }
        HashMap<String, Object> resource = new HashMap<String, Object>();
        String type = authRequest.resourceMap.get("type").toString();
        resource.putAll(authRequest.resourceMap);
        resource.remove("type");
        HashMap s3 = new HashMap();
        ArrayList maps = new ArrayList();
        s3.put(type, maps);
        HashMap<String, Cloneable> r = new HashMap<String, Cloneable>();
        if (resource.size() > 0) {
            r.put(authRequest.regexMatch ? "match" : (authRequest.containsMatch ? "contains" : "equals"), resource);
        }
        if (authRequest.actions != null && authRequest.actions.size() > 0) {
            r.put(ALLOW_LONG_OPT, (Cloneable)((Object)(authRequest.actions.size() > 1 ? new ArrayList<String>(authRequest.actions) : (Serializable)((Object)authRequest.actions.iterator().next()))));
        }
        if (authRequest.denyActions != null && authRequest.denyActions.size() > 0) {
            r.put(DENY_LONG_OPT, (Cloneable)((Object)(authRequest.denyActions.size() > 1 ? new ArrayList<String>(authRequest.denyActions) : (Serializable)((Object)authRequest.denyActions.iterator().next()))));
        }
        maps.add(r);
        ruleMap.putAll(s3);
        stringHashMap.put("for", ruleMap);
        stringHashMap.put("description", authRequest.description != null ? authRequest.description : "generated");
        return stringHashMap;
    }

    private void testAction() throws CLIToolOptionsException, IOException, PoliciesParseException {
        SAREAuthorization authorization = this.createAuthorization();
        AuthRequest authRequest = this.createAuthRequestFromArgs();
        HashSet<Map<String, String>> resource = this.resources(authRequest.resourceMap);
        boolean expectAuthorized = true;
        boolean expectDenied = false;
        Set<Decision> testResult = null;
        if (null != authRequest.actions && authRequest.actions.size() > 0) {
            testResult = authorization.evaluate(resource, authRequest.subject, authRequest.actions, authRequest.environment);
        } else if (null != authRequest.denyActions && authRequest.denyActions.size() > 0) {
            expectAuthorized = false;
            expectDenied = true;
            testResult = authorization.evaluate(resource, authRequest.subject, authRequest.denyActions, authRequest.environment);
        } else {
            this.error(this.optionDisplayString(ALLOW_OPT) + " or " + this.optionDisplayString(DENY_OPT) + " is required");
            this.exit(2);
        }
        boolean testPassed = true;
        boolean wasAllowed = true;
        boolean wasDenied = false;
        for (Decision decision : testResult) {
            if (!decision.isAuthorized()) {
                wasAllowed = false;
            }
            if (expectAuthorized && !decision.isAuthorized() || expectDenied && decision.isAuthorized()) {
                this.log("Result: " + (Object)((Object)decision.explain().getCode()));
                this.verbose(decision.toString());
                switch (decision.explain().getCode()) {
                    case REJECTED_NO_SUBJECT_OR_ENV_FOUND: {
                        this.log("Meaning: No rules were found among the aclpolicies that match the subject (user,group) and context (" + (authRequest.isAppContext() ? "application" : PROJECT_LONG_OPT) + ")" + " and resource (" + authRequest.resourceMap + ")");
                        break;
                    }
                    case REJECTED_DENIED: {
                        this.log("Meaning: A matching rule declared that the requested action be DENIED.");
                        wasDenied = true;
                    }
                }
                testPassed = false;
                continue;
            }
            switch (decision.explain().getCode()) {
                case REJECTED_DENIED: {
                    wasDenied = true;
                }
            }
            if (!this.argVerbose) continue;
            this.log(decision.toString());
        }
        this.log("The decision was: " + (wasAllowed ? "allowed" : (wasDenied ? "denied" : "not allowed")));
        if (this.argVerbose && !testPassed) {
            this.log("Policies to allow the requested actions:");
            this.generateYaml(authRequest, System.out);
        } else if (this.argVerbose && !testPassed && expectAuthorized && wasDenied) {
            this.log("No new policy can allow the requested action.\nDENY rules will always prevent access, even if ALLOW rules also match. \nTo allow it, you must remove the DENY rule.");
        }
        this.log("The test " + (testPassed ? "passed" : "failed"));
        if (!testPassed) {
            this.exit(2);
        }
    }

    private SAREAuthorization createAuthorization() throws IOException, PoliciesParseException, CLIToolOptionsException {
        return new SAREAuthorization(this.createPolicies());
    }

    private Policies createPolicies() throws IOException, PoliciesParseException, CLIToolOptionsException {
        Policies policies;
        if (null != this.argFile) {
            if (!this.argFile.isFile()) {
                throw new CLIToolOptionsException("File: " + this.argFile + ", does not exist or is not a file");
            }
            policies = Policies.loadFile(this.argFile);
        } else if (null != this.argDir) {
            if (!this.argDir.isDirectory()) {
                throw new CLIToolOptionsException("File: " + this.argDir + ", does not exist or is not a directory");
            }
            policies = Policies.load(this.argDir);
        } else if (null != this.configDir) {
            this.log("Using configured Rundeck etc dir: " + this.configDir);
            File directory = new File(this.configDir);
            if (!directory.isDirectory()) {
                throw new CLIToolOptionsException("File: " + directory + ", does not exist or is not a directory");
            }
            policies = Policies.load(directory);
        } else {
            throw new CLIToolOptionsException("-f or -d are required");
        }
        return policies;
    }

    @Override
    public String getHelpString() {
        return "rd-acl <command> [options...]: test [options]\n\tTest action:\nrd-acl test [options] : Test existing aclpolicy files\nrd-acl test --dir <path> [options] : Test all aclpolicy files in specific dir\nrd-acl test --file <file> [options] : Test specific aclpolicy file\nrd-acl test -v [options] : Verbose output, including policy definitions to resolve failing tests\n\tCreate action:\nrd-acl create [options] : Generate aclpolicy definition based on input options\nrd-acl create -i <audit.log> : Generate aclpolicy definitions to resolve rejected access requests\nrd-acl create -i - : Read audit log entries from stdin\n";
    }

    @Override
    public void log(String output) {
        if (null != this.clilogger) {
            this.clilogger.log(output);
        }
    }

    @Override
    public void error(String output) {
        if (null != this.clilogger) {
            this.clilogger.error(output);
        }
    }

    @Override
    public void warn(String output) {
        if (null != this.clilogger) {
            this.clilogger.warn(output);
        }
    }

    @Override
    public void verbose(String message) {
        if (this.argVerbose && null != this.clilogger) {
            this.clilogger.verbose(message);
        }
    }

    @Override
    public void debug(String message) {
        if (null != this.clilogger) {
            this.clilogger.debug(message);
        }
    }

    static {
        appResActionsByType.put(PROJECT_LONG_OPT, appProjectActions);
        appResActionsByType.put(STORAGE_LONG_OPT, appStorageActions);
        appResAttrsByType = new HashMap<String, List<String>>();
        appResAttrsByType.put(PROJECT_LONG_OPT, Arrays.asList("name"));
        appResAttrsByType.put(STORAGE_LONG_OPT, Arrays.asList("path", "name"));
        appKindActionsByType = new HashMap<String, List<String>>();
        appKindActionsByType.put(PROJECT_LONG_OPT, appProjectKindActions);
        appKindActionsByType.put("system", appSystemKindActions);
        appKindActionsByType.put(USER_LONG_OPT, appUserKindActions);
        appKindActionsByType.put(JOB_LONG_OPT, appJobKindActions);
        projectJobActions = Arrays.asList("read", "update", "delete", "run", "runAs", "kill", "killAs", ACTION_CREATE);
        projectJobKindActions = Arrays.asList(ACTION_CREATE, "delete");
        projectAdhocActions = Arrays.asList("read", "run", "runAs", "kill", "killAs");
        projectNodeActions = Arrays.asList("read", "run");
        projResActionsByType = new HashMap<String, List<String>>();
        projResActionsByType.put(JOB_LONG_OPT, projectJobActions);
        projResActionsByType.put(ADHOC_LONG_OPT, projectAdhocActions);
        projResActionsByType.put(NODE_LONG_OPT, projectNodeActions);
        projResAttrsByType = new HashMap<String, List<String>>();
        projResAttrsByType.put(JOB_LONG_OPT, Arrays.asList("group", "name"));
        projResAttrsByType.put(ADHOC_LONG_OPT, new ArrayList());
        List<String> nodeAttributeNames = Arrays.asList("nodename", "rundeck_server", "username", "hostname", "osFamily", "osVersion", "(etc. any node attribute)");
        projResAttrsByType.put(NODE_LONG_OPT, nodeAttributeNames);
        projectNodeKindActions = Arrays.asList("read", ACTION_CREATE, "update", "refresh");
        projectEventKindActions = Arrays.asList("read", ACTION_CREATE);
        projKindActionsByType = new HashMap<String, List<String>>();
        projKindActionsByType.put(JOB_LONG_OPT, projectJobKindActions);
        projKindActionsByType.put(NODE_LONG_OPT, projectNodeKindActions);
        projKindActionsByType.put("event", projectEventKindActions);
    }

    class OptionsPrompt
    extends CLIToolOptionsException {
        private String prompt;

        public OptionsPrompt(String msg, String prompt) {
            super(msg);
            this.prompt = prompt;
        }

        public String getPrompt() {
            return this.prompt;
        }
    }

    class ACLConstants {
        public static final String ACTION_CREATE = "create";
        public static final String ACTION_READ = "read";
        public static final String ACTION_UPDATE = "update";
        public static final String ACTION_DELETE = "delete";
        public static final String ACTION_RUN = "run";
        public static final String ACTION_KILL = "kill";
        public static final String ACTION_ADMIN = "admin";
        public static final String ACTION_REFRESH = "refresh";
        public static final String ACTION_RUNAS = "runAs";
        public static final String ACTION_KILLAS = "killAs";
        public static final String ACTION_CONFIGURE = "configure";
        public static final String ACTION_IMPORT = "import";
        public static final String ACTION_EXPORT = "export";
        public static final String ACTION_DELETE_EXECUTION = "delete_execution";
        public static final String TYPE_SYSTEM = "system";
        public static final String TYPE_NODE = "node";
        public static final String TYPE_JOB = "job";
        public static final String TYPE_ADHOC = "adhoc";
        public static final String TYPE_PROJECT = "project";
        public static final String TYPE_EVENT = "event";
        public static final String TYPE_USER = "user";
        public static final String TYPE_STORAGE = "storage";
        public final Map<String, String> RESOURCE_TYPE_SYSTEM = this.resType("system");
        public final Map<String, String> RESOURCE_TYPE_NODE = this.resType("node");
        public final Map<String, String> RESOURCE_TYPE_JOB = this.resType("job");
        public final Map<String, String> RESOURCE_TYPE_EVENT = this.resType("event");
        public final Map<String, String> RESOURCE_ADHOC = Collections.unmodifiableMap(AuthorizationUtil.resource("adhoc"));

        ACLConstants() {
        }

        private Map<String, String> resType(String type) {
            return Collections.unmodifiableMap(AuthorizationUtil.resourceType(type));
        }
    }

    private class AuthRequest {
        String description;
        Map<String, Object> resourceMap;
        boolean regexMatch;
        boolean containsMatch;
        Subject subject;
        Set<String> actions;
        Set<Attribute> environment;
        Set<String> denyActions;

        private AuthRequest() {
        }

        boolean isAppContext() {
            return this.environment.equals(Framework.RUNDECK_APP_ENV);
        }
    }

    private class ParsePart {
        int len;
        Map<String, Object> resourceMap;
        String value;

        private ParsePart() {
        }
    }

    private class TestOptions
    implements CLIToolOptions {
        private TestOptions() {
        }

        @Override
        public void addOptions(Options options) {
            options.addOption(AclTool.VERBOSE_OPT, AclTool.VERBOSE_LONG_OPT, false, "Verbose output.");
            OptionBuilder.withArgName((String)AclTool.FILE_OPTION_LONG);
            OptionBuilder.withLongOpt((String)AclTool.FILE_OPTION_LONG);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"File path. Load the specified aclpolicy file.");
            options.addOption(OptionBuilder.create((String)AclTool.FILE_OPTION));
            OptionBuilder.withArgName((String)AclTool.DIR_OPTION_LONG);
            OptionBuilder.withLongOpt((String)AclTool.DIR_OPTION_LONG);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Directory. Load all policy files in the specified directory.");
            options.addOption(OptionBuilder.create((String)AclTool.DIR_OPTION));
            OptionBuilder.withArgName((String)"action,...");
            OptionBuilder.withLongOpt((String)AclTool.ALLOW_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Actions to test are allowed (test command) or to allow (create command).");
            options.addOption(OptionBuilder.create((String)AclTool.ALLOW_OPT));
            OptionBuilder.withArgName((String)"action,...");
            OptionBuilder.withLongOpt((String)AclTool.DENY_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Actions to test are denied (test command) or to deny (create command).");
            options.addOption(OptionBuilder.create((String)AclTool.DENY_OPT));
            OptionBuilder.withArgName((String)"group,...");
            OptionBuilder.withLongOpt((String)AclTool.GROUPS_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Subject Groups names to validate (test command) or for by: clause (create command).");
            options.addOption(OptionBuilder.create((String)AclTool.GROUPS_OPT));
            OptionBuilder.withArgName((String)"user,...");
            OptionBuilder.withLongOpt((String)AclTool.USER_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Subject User names to validate (test command) or for by: clause (create command).");
            options.addOption(OptionBuilder.create((String)AclTool.USER_OPT));
            OptionBuilder.withArgName((String)AclTool.PROJECT_LONG_OPT);
            OptionBuilder.withLongOpt((String)AclTool.PROJECT_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Name of project, used in project context or for application resource.");
            options.addOption(OptionBuilder.create((String)AclTool.PROJECT_OPT));
            OptionBuilder.withArgName((String)"group/name");
            OptionBuilder.withLongOpt((String)AclTool.JOB_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Job group/name. (project context)");
            options.addOption(OptionBuilder.create((String)AclTool.JOB_OPT));
            OptionBuilder.withArgName((String)"application | project");
            OptionBuilder.withLongOpt((String)AclTool.CONTEXT_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Context: either 'project' or 'application'.");
            options.addOption(OptionBuilder.create((String)AclTool.CONTEXT_OPT));
            OptionBuilder.withLongOpt((String)AclTool.ADHOC_LONG_OPT);
            OptionBuilder.withDescription((String)"Adhoc execution (project context)");
            options.addOption(OptionBuilder.create((String)AclTool.ADHOC_OPT));
            OptionBuilder.withArgName((String)"nodename");
            OptionBuilder.withLongOpt((String)AclTool.NODE_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Node name. (project context)");
            options.addOption(OptionBuilder.create((String)AclTool.NODE_OPT));
            OptionBuilder.withArgName((String)"tag,..");
            OptionBuilder.withLongOpt((String)AclTool.TAGS_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Node tags. If specified, the resource match will be defined using 'contains'. (project context)");
            options.addOption(OptionBuilder.create((String)AclTool.TAGS_OPT));
            OptionBuilder.withArgName((String)"path/file");
            OptionBuilder.withLongOpt((String)AclTool.STORAGE_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Storage path/name. (application context)");
            options.addOption(OptionBuilder.create((String)AclTool.STORAGE_OPT));
            OptionBuilder.withArgName((String)"kind");
            OptionBuilder.withLongOpt((String)AclTool.GENERIC_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Generic resource kind.");
            options.addOption(OptionBuilder.create((String)AclTool.GENERIC_OPT));
            OptionBuilder.withArgName((String)"type");
            OptionBuilder.withLongOpt((String)AclTool.RESOURCE_LONG_OPT);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Resource type name.");
            options.addOption(OptionBuilder.create((String)AclTool.RESOURCE_OPT));
            OptionBuilder.withArgName((String)"file | -");
            OptionBuilder.withLongOpt((String)AclTool.INPUT_OPT_LONG);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Read file or stdin for audit log data. (create command)");
            options.addOption(OptionBuilder.create((String)AclTool.INPUT_OPT));
            options.addOption(AclTool.REGEX_OPT, AclTool.REGEX_OPT_LONG, false, "Match the resource using regular expressions. (create command).");
            options.addOption(AclTool.LIST_OPT, "list", false, "List all permissions for the group or user. (test command).");
            OptionBuilder.withArgName((String)"key=value ...");
            OptionBuilder.withDescription((String)"Attributes for the resource. A sequence of key=value pairs, multiple pairs can follow with a space. Use a value of '?' to see suggestions.");
            OptionBuilder.withLongOpt((String)AclTool.ATTRS_OPT_LONG);
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs();
            options.addOption(OptionBuilder.create((String)AclTool.ATTRS_OPT));
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(AclTool.FILE_OPTION)) {
                AclTool.this.argFile = new File(cli.getOptionValue(AclTool.FILE_OPTION));
            } else if (cli.hasOption(AclTool.DIR_OPTION)) {
                AclTool.this.argDir = new File(cli.getOptionValue(AclTool.DIR_OPTION));
            }
            if (cli.hasOption(AclTool.ALLOW_OPT)) {
                AclTool.this.argAllowAction = cli.getOptionValue(AclTool.ALLOW_OPT);
                AclTool.this.actionsAllowList = Arrays.asList(AclTool.this.argAllowAction.split(", *"));
            }
            if (cli.hasOption(AclTool.DENY_OPT)) {
                AclTool.this.argDenyAction = cli.getOptionValue(AclTool.DENY_OPT);
                AclTool.this.actionsDenyList = Arrays.asList(AclTool.this.argDenyAction.split(", *"));
            }
            if (cli.hasOption(AclTool.GROUPS_OPT)) {
                AclTool.this.argGroups = cli.getOptionValue(AclTool.GROUPS_OPT);
                AclTool.this.groupsList = Arrays.asList(AclTool.this.argGroups.split(", *"));
            }
            if (cli.hasOption(AclTool.USER_OPT)) {
                AclTool.this.argUser = cli.getOptionValue(AclTool.USER_OPT);
            }
            if (cli.hasOption(AclTool.PROJECT_OPT)) {
                AclTool.this.argProject = cli.getOptionValue(AclTool.PROJECT_OPT);
            }
            if (cli.hasOption(AclTool.JOB_OPT)) {
                AclTool.this.argProjectJob = cli.getOptionValue(AclTool.JOB_OPT);
            }
            if (cli.hasOption(AclTool.CONTEXT_OPT)) {
                AclTool.this.argContext = Context.valueOf(cli.getOptionValue(AclTool.CONTEXT_OPT).toLowerCase());
            }
            if (cli.hasOption(AclTool.ADHOC_OPT)) {
                AclTool.this.argProjectAdhoc = cli.hasOption(AclTool.ADHOC_OPT);
            }
            if (cli.hasOption(AclTool.VERBOSE_OPT)) {
                AclTool.this.argVerbose = cli.hasOption(AclTool.VERBOSE_OPT);
            }
            if (cli.hasOption(AclTool.NODE_OPT)) {
                AclTool.this.argProjectNode = cli.getOptionValue(AclTool.NODE_OPT);
            }
            if (cli.hasOption(AclTool.STORAGE_OPT)) {
                AclTool.this.argAppStorage = cli.getOptionValue(AclTool.STORAGE_OPT);
            }
            if (cli.hasOption(AclTool.GENERIC_OPT)) {
                AclTool.this.argGenericType = cli.getOptionValue(AclTool.GENERIC_OPT);
            }
            if (cli.hasOption(AclTool.INPUT_OPT)) {
                AclTool.this.argInput = cli.getOptionValue(AclTool.INPUT_OPT);
            }
            if (cli.hasOption(AclTool.REGEX_OPT)) {
                AclTool.this.argRegex = cli.hasOption(AclTool.REGEX_OPT);
            }
            if (cli.hasOption(AclTool.LIST_OPT)) {
                AclTool.this.argList = cli.hasOption(AclTool.LIST_OPT);
            }
            if (cli.hasOption(AclTool.TAGS_OPT)) {
                AclTool.this.argTags = cli.getOptionValue(AclTool.TAGS_OPT);
                AclTool.this.tagsSet = Arrays.asList(AclTool.this.argTags.split(", *"));
            }
            if (cli.hasOption(AclTool.RESOURCE_OPT)) {
                AclTool.this.argResource = cli.getOptionValue(AclTool.RESOURCE_OPT);
            }
            if (cli.hasOption(AclTool.ATTRS_OPT)) {
                AclTool.this.attrsMap = new HashMap();
                cli.getOptionValues(AclTool.ATTRS_OPT);
                String key = null;
                for (String s : cli.getOptionValues(AclTool.ATTRS_OPT)) {
                    if (key == null) {
                        key = s;
                        continue;
                    }
                    if (s.equals("")) {
                        AclTool.this.warn("Extraneous attribute key with no value: " + key);
                        AclTool.this.attrHelp = true;
                        key = null;
                        continue;
                    }
                    if (s.equals("")) continue;
                    AclTool.this.attrsMap.put(key, s);
                    key = null;
                }
                if (key != null) {
                    AclTool.this.attrHelp = true;
                    AclTool.this.warn("Extraneous attribute key with no value: " + key);
                }
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
        }
    }

    static enum Context {
        project,
        application;

    }

    static enum Actions {
        test("test"),
        create("create"),
        list("list");

        private String name;

        private Actions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

