/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.project;

import com.dtolabs.rundeck.core.cli.Action;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.InvalidArgumentsException;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class BaseAction
implements Action {
    protected final CLIToolLogger main;
    private boolean verbose = false;
    protected String project;
    private CentralDispatcher centralDispatcher;
    protected final IPropertyLookup frameworkProperties;

    public BaseAction(CLIToolLogger main, IPropertyLookup frameworkProperties, BaseActionArgs args, CentralDispatcher dispatcher) {
        if (null == main) {
            throw new NullPointerException("main parameter was null");
        }
        if (null == args) {
            throw new NullPointerException("args parameter was null");
        }
        this.main = main;
        this.frameworkProperties = frameworkProperties;
        this.centralDispatcher = dispatcher;
        this.initArgs(args, true);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected static BaseActionArgs parseBaseActionArgs(CommandLine cli) {
        String project = cli.getOptionValue('p');
        if (null != project && !project.matches("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$")) {
            throw new ProjectToolException("Error: CreateAction: project names can only contain these characters: ^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
        }
        return BaseAction.createArgs(project, cli.hasOption('v'));
    }

    public static BaseActionArgs createArgs(final String project, final boolean verbose) {
        return new BaseActionArgs(){

            @Override
            public String getProject() {
                return project;
            }

            @Override
            public boolean isVerbose() {
                return verbose;
            }
        };
    }

    public CentralDispatcher getCentralDispatcher() {
        return this.centralDispatcher;
    }

    public void setCentralDispatcher(CentralDispatcher centralDispatcher) {
        this.centralDispatcher = centralDispatcher;
    }

    protected String getSingleProjectName() throws CentralDispatcherException {
        List<String> strings = this.getCentralDispatcher().listProjectNames();
        if (strings.size() == 1) {
            return strings.get(0);
        }
        return null;
    }

    private void initArgs(BaseActionArgs args, boolean allowDefaultProject) {
        if (null != args.getProject()) {
            this.project = args.getProject();
        }
        this.verbose = args.isVerbose();
    }

    void validate() {
        if (null == this.project) {
            throw new InvalidArgumentsException("-p option not specified");
        }
    }

    @Override
    public void exec() throws Throwable {
        this.validate();
    }

    public static interface BaseActionArgs {
        public String getProject();

        public boolean isVerbose();
    }
}

