/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.impl.common.AntSupport;
import com.dtolabs.rundeck.core.execution.impl.jsch.NodeSSHConnectionInfo;
import com.dtolabs.rundeck.core.execution.impl.jsch.SudoResponder;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.utils.BasicSource;
import com.dtolabs.rundeck.core.execution.utils.LeadPipeOutputStream;
import com.dtolabs.rundeck.core.execution.utils.PasswordSource;
import com.dtolabs.rundeck.core.execution.utils.ResponderTask;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.core.tasks.net.ExtSSHExec;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JschNodeExecutor
implements NodeExecutor,
Describable {
    public static final Logger logger = Logger.getLogger((String)JschNodeExecutor.class.getName());
    public static final String SERVICE_PROVIDER_TYPE = "jsch-ssh";
    public static final String FWK_PROP_AUTH_CANCEL_MSG = "framework.messages.error.ssh.authcancel";
    public static final String FWK_PROP_AUTH_CANCEL_MSG_DEFAULT = "Authentication failure connecting to node: \"{0}\". Make sure your resource definitions and credentials are up to date.";
    public static final String FWK_PROP_AUTH_FAIL_MSG = "framework.messages.error.ssh.authfail";
    public static final String FWK_PROP_AUTH_FAIL_MSG_DEFAULT = "Authentication failure connecting to node: \"{0}\". Password incorrect.";
    public static final String NODE_ATTR_SSH_KEYPATH = "ssh-keypath";
    public static final String NODE_ATTR_SSH_KEY_RESOURCE = "ssh-key-storage-path";
    public static final String NODE_ATTR_SSH_PASSWORD_STORAGE_PATH = "ssh-password-storage-path";
    public static final String NODE_ATTR_LOCAL_SSH_AGENT = "local-ssh-agent";
    public static final String NODE_ATTR_LOCAL_TTL_SSH_AGENT = "local-ttl-ssh-agent";
    public static final String PROJ_PROP_PREFIX = "project.";
    public static final String FWK_PROP_PREFIX = "framework.";
    public static final String FWK_PROP_SSH_KEYPATH = "framework.ssh-keypath";
    public static final String PROJ_PROP_SSH_KEYPATH = "project.ssh-keypath";
    public static final String FWK_PROP_SSH_KEY_RESOURCE = "framework.ssh-key-storage-path";
    public static final String FWK_PROP_SSH_PASSWORD_STORAGE_PATH = "framework.ssh-password-storage-path";
    public static final String PROJ_PROP_SSH_KEY_RESOURCE = "project.ssh-key-storage-path";
    public static final String PROJ_PROP_SSH_PASSWORD_STORAGE_PATH = "project.ssh-password-storage-path";
    public static final String NODE_ATTR_SSH_AUTHENTICATION = "ssh-authentication";
    public static final String NODE_ATTR_SSH_PASSWORD_OPTION = "ssh-password-option";
    public static final String DEFAULT_SSH_PASSWORD_OPTION = "option.sshPassword";
    public static final String SUDO_OPT_PREFIX = "sudo-";
    public static final String SUDO2_OPT_PREFIX = "sudo2-";
    public static final String NODE_ATTR_SUDO_PASSWORD_OPTION = "password-option";
    public static final String DEFAULT_SUDO_PASSWORD_OPTION = "option.sudoPassword";
    public static final String DEFAULT_SUDO2_PASSWORD_OPTION = "option.sudo2Password";
    public static final String NODE_ATTR_SSH_KEY_PASSPHRASE_OPTION = "ssh-key-passphrase-option";
    public static final String NODE_ATTR_SSH_KEY_PASSPHRASE_STORAGE_PATH = "ssh-key-passphrase-storage-path";
    public static final String DEFAULT_SSH_KEY_PASSPHRASE_OPTION = "option.sshKeyPassphrase";
    public static final String FWK_PROP_SSH_AUTHENTICATION = "framework.ssh-authentication";
    public static final String PROJ_PROP_SSH_AUTHENTICATION = "project.ssh-authentication";
    public static final String NODE_ATTR_SUDO_COMMAND_ENABLED = "command-enabled";
    public static final String NODE_ATTR_SUDO_PROMPT_PATTERN = "prompt-pattern";
    public static final String DEFAULT_SUDO_PROMPT_PATTERN = "^\\[sudo\\] password for .+: .*";
    public static final String NODE_ATTR_SUDO_FAILURE_PATTERN = "failure-pattern";
    public static final String DEFAULT_SUDO_FAILURE_PATTERN = "^.*try again.*";
    public static final String NODE_ATTR_SUDO_COMMAND_PATTERN = "command-pattern";
    public static final String DEFAULT_SUDO_COMMAND_PATTERN = "^sudo$";
    public static final String DEFAULT_SUDO2_COMMAND_PATTERN = "^sudo .+? sudo .*$";
    public static final String NODE_ATTR_SUDO_PROMPT_MAX_LINES = "prompt-max-lines";
    public static final int DEFAULT_SUDO_PROMPT_MAX_LINES = 12;
    public static final String NODE_ATTR_SUDO_RESPONSE_MAX_LINES = "response-max-lines";
    public static final int DEFAULT_SUDO_RESPONSE_MAX_LINES = 2;
    public static final String NODE_ATTR_SUDO_PROMPT_MAX_TIMEOUT = "prompt-max-timeout";
    public static final long DEFAULT_SUDO_PROMPT_MAX_TIMEOUT = 5000L;
    public static final String NODE_ATTR_SUDO_RESPONSE_MAX_TIMEOUT = "response-max-timeout";
    public static final long DEFAULT_SUDO_RESPONSE_MAX_TIMEOUT = 5000L;
    public static final String NODE_ATTR_SUDO_FAIL_ON_PROMPT_MAX_LINES = "fail-on-prompt-max-lines";
    public static final boolean DEFAULT_SUDO_FAIL_ON_PROMPT_MAX_LINES = false;
    public static final String NODE_ATTR_SUDO_FAIL_ON_PROMPT_TIMEOUT = "fail-on-prompt-timeout";
    public static final boolean DEFAULT_SUDO_FAIL_ON_PROMPT_TIMEOUT = true;
    public static final String NODE_ATTR_SUDO_FAIL_ON_RESPONSE_TIMEOUT = "fail-on-response-timeout";
    public static final boolean DEFAULT_SUDO_FAIL_ON_RESPONSE_TIMEOUT = false;
    public static final String NODE_ATTR_SUDO_SUCCESS_ON_PROMPT_THRESHOLD = "success-on-prompt-threshold";
    public static final String NODE_ATTR_SUDO_PASSWORD_STORAGE_PATH = "password-storage-path";
    public static final boolean DEFAULT_SUDO_SUCCESS_ON_PROMPT_THRESHOLD = true;
    public static final String PROJECT_SSH_USER = "project.ssh.user";
    public static final String SSH_CONFIG_PREFIX = "ssh-config-";
    public static final String FWK_SSH_CONFIG_PREFIX = "framework.ssh-config-";
    public static final String PROJ_SSH_CONFIG_PREFIX = "project.ssh-config-";
    private Framework framework;
    public static final String CONFIG_KEYPATH = "keypath";
    public static final String CONFIG_KEYSTORE_PATH = "keystoragepath";
    public static final String CONFIG_PASSSTORE_PATH = "passwordstoragepath";
    public static final String CONFIG_SUDO_PASSSTORE_PATH = "sudopasswordstoragepath";
    public static final String CONFIG_AUTHENTICATION = "authentication";
    static final Description DESC;
    static final Property SSH_KEY_FILE_PROP;
    static final Property SSH_KEY_STORAGE_PROP;
    static final Property SSH_PASSWORD_STORAGE_PROP;
    public static final Property SSH_AUTH_TYPE_PROP;

    public JschNodeExecutor(Framework framework) {
        this.framework = framework;
    }

    @Override
    public Description getDescription() {
        return DESC;
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, final INodeEntry node) {
        Future<ResponderTask.ResponderResult> responderFuture;
        SudoResponder sudoResponder;
        ExtSSHExec sshexec;
        if (null == node.getHostname() || null == node.extractHostname()) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, "Hostname must be set to connect to remote node '" + node.getNodename() + "'", node);
        }
        ExecutionListener listener = context.getExecutionListener();
        Project project = new Project();
        AntSupport.addAntBuildListener(listener, project);
        boolean success = false;
        NodeSSHConnectionInfo nodeAuthentication = new NodeSSHConnectionInfo(node, this.framework, context);
        int timeout = nodeAuthentication.getSSHTimeout();
        try {
            sshexec = SSHTaskBuilder.build(node, command, project, context.getDataContext(), nodeAuthentication, context.getLoglevel(), listener);
        }
        catch (SSHTaskBuilder.BuilderException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
        }
        final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(null, r, "SudoResponder " + node.getNodename() + ": " + System.currentTimeMillis());
            }
        });
        try {
            sudoResponder = SudoResponder.create(node, this.framework, context, SUDO_OPT_PREFIX, this.passwordSourceWithPrefix(nodeAuthentication, SUDO_OPT_PREFIX), DEFAULT_SUDO_COMMAND_PATTERN);
        }
        catch (IOException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
        }
        Runnable responderCleanup = null;
        if (sudoResponder.isSudoEnabled() && sudoResponder.matchesCommandPattern(command[0])) {
            Callable<ResponderTask.ResponderResult> responderResultCallable;
            SudoResponder sudoResponder2;
            DisconnectResultHandler resultHandler = new DisconnectResultHandler();
            final PipedInputStream responderInput = new PipedInputStream();
            final PipedOutputStream responderOutput = new PipedOutputStream();
            PipedInputStream jschInput = new PipedInputStream();
            LeadPipeOutputStream jschOutput = new LeadPipeOutputStream();
            try {
                responderInput.connect(jschOutput);
                jschInput.connect(responderOutput);
            }
            catch (IOException e) {
                return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, e.getMessage(), node);
            }
            ResponderTask responder = new ResponderTask(sudoResponder, responderInput, responderOutput, resultHandler);
            try {
                sudoResponder2 = SudoResponder.create(node, this.framework, context, SUDO2_OPT_PREFIX, this.passwordSourceWithPrefix(nodeAuthentication, SUDO2_OPT_PREFIX), DEFAULT_SUDO2_COMMAND_PATTERN);
            }
            catch (IOException e) {
                return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
            }
            if (sudoResponder2.isSudoEnabled() && sudoResponder2.matchesCommandPattern(CLIUtils.generateArgline(null, command, false))) {
                logger.debug((Object)"Enable second sudo responder");
                sudoResponder2.setDescription("Second Sudo execution password response");
                sudoResponder.setDescription("First Sudo execution password response");
                responderResultCallable = responder.createSequence(sudoResponder2);
            } else {
                responderResultCallable = responder;
            }
            sshexec.setAllocatePty(true);
            sshexec.setInputStream(jschInput);
            sshexec.setSecondaryStream(jschOutput);
            sshexec.setDisconnectHolder(resultHandler);
            responderFuture = executor.submit(responderResultCallable);
            responderCleanup = new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)"SudoResponder shutting down...");
                    try {
                        responderInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        responderOutput.flush();
                        responderOutput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    executor.shutdownNow();
                }
            };
            executor.submit(responderCleanup);
        } else {
            responderFuture = null;
        }
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().log(3, "Starting SSH Connection: " + nodeAuthentication.getUsername() + "@" + node.getHostname() + " (" + node.getNodename() + ")");
        }
        String errormsg = null;
        FailureReason failureReason = null;
        try {
            sshexec.execute();
            success = true;
        }
        catch (BuildException e) {
            ExtractFailure extractJschFailure = JschNodeExecutor.extractFailure(e, node, timeout, this.framework);
            errormsg = extractJschFailure.getErrormsg();
            failureReason = extractJschFailure.getReason();
            context.getExecutionListener().log(0, errormsg);
        }
        if (null != responderCleanup) {
            responderCleanup.run();
        }
        this.shutdownAndAwaitTermination(executor);
        if (null != responderFuture) {
            try {
                logger.debug((Object)"Waiting 5 seconds for responder future result");
                ResponderTask.ResponderResult result = (ResponderTask.ResponderResult)responderFuture.get(5L, TimeUnit.SECONDS);
                logger.debug((Object)("Responder result: " + result));
                if (!result.isSuccess() && !result.isInterrupted()) {
                    context.getExecutionListener().log(0, result.getResponder().toString() + " failed: " + result.getFailureReason());
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                // empty catch block
            }
        }
        int resultCode = sshexec.getExitStatus();
        if (success) {
            return NodeExecutorResultImpl.createSuccess(node);
        }
        return NodeExecutorResultImpl.createFailure(failureReason, errormsg, node, resultCode);
    }

    private PasswordSource passwordSourceWithPrefix(NodeSSHConnectionInfo nodeAuthentication, String prefix) throws IOException {
        if (null != nodeAuthentication.getSudoPasswordStoragePath(prefix)) {
            return new BasicSource(nodeAuthentication.getSudoPasswordStorageData(prefix));
        }
        return new BasicSource(nodeAuthentication.getSudoPassword(prefix));
    }

    static ExtractFailure extractFailure(BuildException e, INodeEntry node, int timeout, Framework framework) {
        Enum failureReason;
        String errormsg;
        if (e.getMessage().contains("Timeout period exceeded, connection dropped")) {
            errormsg = "Failed execution for node: " + node.getNodename() + ": Execution Timeout period exceeded (after " + timeout + "ms), connection dropped";
            failureReason = NodeStepFailureReason.ConnectionTimeout;
        } else {
            if (null != e.getCause() && e.getCause() instanceof JSchException) {
                JSchException jSchException = (JSchException)e.getCause();
                return JschNodeExecutor.extractJschFailure(node, timeout, jSchException, framework);
            }
            if (e.getMessage().contains("Remote command failed with exit status")) {
                errormsg = e.getMessage();
                failureReason = NodeStepFailureReason.NonZeroResultCode;
            } else {
                failureReason = StepFailureReason.Unknown;
                errormsg = e.getMessage();
            }
        }
        return new ExtractFailure(errormsg, (FailureReason)((Object)failureReason));
    }

    static ExtractFailure extractJschFailure(INodeEntry node, int timeout, JSchException jSchException, Framework framework) {
        Enum reason;
        String errormsg;
        if (null == jSchException.getCause()) {
            if (jSchException.getMessage().contains("Auth cancel")) {
                String msgformat = FWK_PROP_AUTH_CANCEL_MSG_DEFAULT;
                if (framework.getPropertyLookup().hasProperty(FWK_PROP_AUTH_CANCEL_MSG)) {
                    msgformat = framework.getProperty(FWK_PROP_AUTH_CANCEL_MSG);
                }
                errormsg = MessageFormat.format(msgformat, node.getNodename(), jSchException.getMessage());
                reason = NodeStepFailureReason.AuthenticationFailure;
            } else if (jSchException.getMessage().contains("Auth fail")) {
                String msgformat = FWK_PROP_AUTH_FAIL_MSG_DEFAULT;
                if (framework.getPropertyLookup().hasProperty(FWK_PROP_AUTH_FAIL_MSG)) {
                    msgformat = framework.getProperty(FWK_PROP_AUTH_FAIL_MSG);
                }
                errormsg = MessageFormat.format(msgformat, node.getNodename(), jSchException.getMessage());
                reason = NodeStepFailureReason.AuthenticationFailure;
            } else {
                reason = JschFailureReason.SSHProtocolFailure;
                errormsg = jSchException.getMessage();
            }
        } else {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)jSchException);
            errormsg = cause.getMessage();
            if (cause instanceof NoRouteToHostException) {
                reason = NodeStepFailureReason.ConnectionFailure;
            } else if (cause instanceof UnknownHostException) {
                reason = NodeStepFailureReason.HostNotFound;
            } else if (cause instanceof SocketTimeoutException) {
                errormsg = "Connection Timeout (after " + timeout + "ms): " + cause.getMessage();
                reason = NodeStepFailureReason.ConnectionTimeout;
            } else {
                reason = cause instanceof SocketException ? NodeStepFailureReason.ConnectionFailure : StepFailureReason.Unknown;
            }
        }
        return new ExtractFailure(errormsg, (FailureReason)((Object)reason));
    }

    void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdownNow();
        try {
            logger.debug((Object)"Waiting up to 30 seconds for ExecutorService to shut down");
            if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.debug((Object)"Pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        SSH_KEY_FILE_PROP = PropertyUtil.string(CONFIG_KEYPATH, "SSH Key File path", "File Path to the SSH Key to use", false, null);
        SSH_KEY_STORAGE_PROP = PropertyBuilder.builder().string(CONFIG_KEYSTORE_PATH).required(false).title("SSH Key Storage Path").description("Path to the SSH Key to use within Rundeck Storage. E.g. \"keys/path/key1.pem\"").renderingOption("selectionAccessor", (Object)StringRenderingConstants.SelectionAccessor.STORAGE_PATH).renderingOption("storage-path-root", "keys").renderingOption("storage-file-meta-filter", "Rundeck-key-type=private").build();
        SSH_PASSWORD_STORAGE_PROP = PropertyBuilder.builder().string(CONFIG_PASSSTORE_PATH).required(false).title("SSH Password Storage Path").description("Path to the Password to use within Rundeck Storage. E.g. \"keys/path/my.password\". Can be overridden by a Node attribute named 'ssh-password-storage-path'.").renderingOption("selectionAccessor", (Object)StringRenderingConstants.SelectionAccessor.STORAGE_PATH).renderingOption("storage-path-root", "keys").renderingOption("storage-file-meta-filter", "Rundeck-data-type=password").build();
        SSH_AUTH_TYPE_PROP = PropertyUtil.select(CONFIG_AUTHENTICATION, "SSH Authentication", "Type of SSH Authentication to use", true, SSHTaskBuilder.AuthenticationType.privateKey.toString(), Arrays.asList(SSHTaskBuilder.AuthenticationType.values()), null, null);
        DescriptionBuilder builder = DescriptionBuilder.builder();
        builder.name(SERVICE_PROVIDER_TYPE).title("SSH").description("Executes a command on a remote node via SSH.");
        builder.property(SSH_KEY_FILE_PROP);
        builder.property(SSH_KEY_STORAGE_PROP);
        builder.property(SSH_PASSWORD_STORAGE_PROP);
        builder.property(SSH_AUTH_TYPE_PROP);
        builder.mapping(CONFIG_KEYPATH, PROJ_PROP_SSH_KEYPATH);
        builder.frameworkMapping(CONFIG_KEYPATH, FWK_PROP_SSH_KEYPATH);
        builder.mapping(CONFIG_KEYSTORE_PATH, PROJ_PROP_SSH_KEY_RESOURCE);
        builder.frameworkMapping(CONFIG_KEYSTORE_PATH, FWK_PROP_SSH_KEY_RESOURCE);
        builder.mapping(CONFIG_PASSSTORE_PATH, PROJ_PROP_SSH_PASSWORD_STORAGE_PATH);
        builder.frameworkMapping(CONFIG_PASSSTORE_PATH, FWK_PROP_SSH_PASSWORD_STORAGE_PATH);
        builder.mapping(CONFIG_AUTHENTICATION, PROJ_PROP_SSH_AUTHENTICATION);
        builder.frameworkMapping(CONFIG_AUTHENTICATION, FWK_PROP_SSH_AUTHENTICATION);
        DESC = builder.build();
    }

    static class ExtractFailure {
        private String errormsg;
        private FailureReason reason;

        private ExtractFailure(String errormsg, FailureReason reason) {
            this.errormsg = errormsg;
            this.reason = reason;
        }

        public String getErrormsg() {
            return this.errormsg;
        }

        public FailureReason getReason() {
            return this.reason;
        }
    }

    private static class DisconnectResultHandler
    implements ResponderTask.ResultHandler,
    ExtSSHExec.DisconnectHolder {
        private volatile ExtSSHExec.Disconnectable disconnectable;
        private volatile boolean needsDisconnect = false;

        private DisconnectResultHandler() {
        }

        @Override
        public void setDisconnectable(ExtSSHExec.Disconnectable disconnectable) {
            this.disconnectable = disconnectable;
            this.checkAndDisconnect();
        }

        @Override
        public void handleResult(boolean success, String reason) {
            this.needsDisconnect = !success;
            this.checkAndDisconnect();
        }

        private synchronized void checkAndDisconnect() {
            if (null != this.disconnectable && this.needsDisconnect) {
                this.disconnectable.disconnect();
                this.needsDisconnect = false;
            }
        }
    }

    static enum JschFailureReason implements FailureReason
    {
        SSHProtocolFailure;

    }
}

