/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.HandlerExecutionItem;
import com.dtolabs.rundeck.core.execution.HasFailureHandler;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.ControlBehavior;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.NodeRecorder;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParallelWorkflowStrategy
extends BaseWorkflowStrategy {
    protected static final String DATA_CONTEXT_PREFIX = "data context: ";

    public ParallelWorkflowStrategy(Framework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowStatusResult workflowResult = WorkflowResultFailed;
        RuntimeException exception = null;
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        ArrayList<StepExecutionResult> stepResults = new ArrayList<StepExecutionResult>();
        try {
            executionContext.getExecutionListener().log(4, "NodeSet: " + executionContext.getNodeSelector());
            executionContext.getExecutionListener().log(4, "Workflow: " + workflow);
            Map<String, Map<String, String>> printableContext = this.createPrintableDataContext("option", "secureOption", "****", executionContext.getDataContext());
            executionContext.getExecutionListener().log(4, String.format("%s %s", DATA_CONTEXT_PREFIX, printableContext));
            List<StepExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            workflowResult = this.executeWorkflowItemsInParallel(executionContext, stepFailures, stepResults, iWorkflowCmdItems, workflow.isKeepgoing());
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
        }
        RuntimeException orig = exception;
        Map<String, Collection<StepExecutionResult>> nodeFailures = this.convertFailures(stepFailures);
        return new BaseWorkflowStrategy.BaseWorkflowExecutionResult(stepResults, nodeFailures, stepFailures, orig, workflowResult);
    }

    protected WorkflowStatusResult executeWorkflowItemsInParallel(final StepExecutionContext executionContext, final Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing) {
        final WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        int numCommands = iWorkflowCmdItems.size();
        ExecutorService es = Executors.newFixedThreadPool(numCommands);
        ArrayList stepFailedMaps = new ArrayList(numCommands);
        final HashMap stepExecutionResults = new HashMap();
        ArrayList<1> parallelSteps = new ArrayList<1>();
        for (int i = 0; i < iWorkflowCmdItems.size(); ++i) {
            final HashMap hashMap = new HashMap();
            final StepExecutionItem cmd = iWorkflowCmdItems.get(i);
            final int stepNum = executionContext.getStepNumber() + i;
            stepFailedMaps.add(hashMap);
            Runnable cmdExecution = new Runnable(){

                @Override
                public void run() {
                    try {
                        StepExecutionResult result = ParallelWorkflowStrategy.this.executeWorkflowStep(wlistener, cmd, executionContext, hashMap, stepNum);
                        stepExecutionResults.put(stepNum, result);
                        failedMap.putAll(hashMap);
                    }
                    catch (Exception ex) {
                        String message = String.format("Exception while executing step [%i]: \t[%s]", stepNum, ex.getMessage());
                        executionContext.getExecutionListener().log(0, message);
                        throw new RuntimeException(ex);
                    }
                }
            };
            parallelSteps.add(cmdExecution);
        }
        for (Runnable runnable : parallelSteps) {
            es.execute(runnable);
        }
        es.shutdown();
        try {
            if (!es.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException ioex) {
            executionContext.getExecutionListener().log(1, "Workflow execution interrupted");
        }
        for (int i = 0; i < iWorkflowCmdItems.size(); ++i) {
            int n = i + executionContext.getStepNumber();
            if (null != stepExecutionResults.get(n) && ((StepExecutionResult)stepExecutionResults.get(n)).isSuccess()) continue;
            return WorkflowResultFailed;
        }
        return ParallelWorkflowStrategy.workflowResult(true, null, ControlBehavior.Continue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepExecutionResult executeWorkflowStep(WorkflowExecutionListener wlistener, StepExecutionItem cmd, StepExecutionContext executionContext, Map<Integer, StepExecutionResult> stepFailedMap, int stepNum) {
        boolean stepSuccess = false;
        if (null != wlistener) {
            wlistener.beginWorkflowItem(stepNum, cmd);
        }
        NodeRecorder stepCaptureFailedNodesListener = new NodeRecorder();
        StepExecutionContext stepContext = this.replaceFailedNodesListenerInContext(executionContext, stepCaptureFailedNodesListener);
        StepExecutionResult stepResult = null;
        stepResult = this.executeWFItem(stepContext, stepFailedMap, stepNum, cmd);
        stepSuccess = stepResult.isSuccess();
        HashMap<String, NodeStepResult> nodeFailures = stepCaptureFailedNodesListener.getFailedNodes();
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            executionContext.getExecutionListener().getFailedNodesListener().matchedNodes(stepCaptureFailedNodesListener.getMatchedNodes());
        }
        try {
            HasFailureHandler handles;
            StepExecutionItem handler;
            if (!stepSuccess && cmd instanceof HasFailureHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler())) {
                NodeRecorder handlerCaptureFailedNodesListener = new NodeRecorder();
                StepExecutionContext handlerExecContext = this.replaceFailedNodesListenerInContext(executionContext, handlerCaptureFailedNodesListener);
                if (stepCaptureFailedNodesListener.getMatchedNodes().size() > 1) {
                    HashSet<String> failedNodeList = new HashSet<String>(stepCaptureFailedNodesListener.getFailedNodes().keySet());
                    handlerExecContext = new ExecutionContextImpl.Builder(handlerExecContext).nodeSelector(SelectorUtils.nodeList(failedNodeList)).build();
                }
                handlerExecContext = this.addStepFailureContextData(stepResult, handlerExecContext);
                handlerExecContext = this.addNodeStepFailureContextData(stepResult, handlerExecContext);
                HashMap<Integer, StepExecutionResult> handlerFailedMap = new HashMap<Integer, StepExecutionResult>();
                StepExecutionResult handlerResult = this.executeWFItem(handlerExecContext, handlerFailedMap, stepNum, handler);
                boolean handlerSuccess = handlerResult.isSuccess();
                boolean useHandlerResults = true;
                if (handlerSuccess && handler instanceof HandlerExecutionItem) {
                    useHandlerResults = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
                }
                if (useHandlerResults) {
                    stepSuccess = handlerSuccess;
                    stepResult = handlerResult;
                    stepFailedMap = handlerFailedMap;
                    nodeFailures = handlerCaptureFailedNodesListener.getFailedNodes();
                }
            }
        }
        finally {
            if (null != wlistener) {
                wlistener.finishWorkflowItem(stepNum, cmd, stepResult);
            }
        }
        if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
            if (nodeFailures.size() > 0) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesFailed(nodeFailures);
            } else if (stepSuccess) {
                executionContext.getExecutionListener().getFailedNodesListener().nodesSucceeded();
            }
        }
        return stepResult;
    }
}

