/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.AdapterService;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.utils.Converter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePluggableProviderService<T>
implements PluggableProviderService<T> {
    protected Class<? extends T> implementationClass;
    protected String name;

    public BasePluggableProviderService(String name, Class<? extends T> implementationClass) {
        this.name = name;
        this.implementationClass = implementationClass;
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return this.implementationClass.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends T> T createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (T)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        ServiceProviderLoader pluginManager = this.getPluginManager();
        if (null != pluginManager) {
            return pluginManager.loadProvider(this, providerName);
        }
        throw new MissingProviderException("Provider not found", this.getName(), providerName);
    }

    public abstract ServiceProviderLoader getPluginManager();

    @Override
    public List<ProviderIdent> listProviders() {
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        ServiceProviderLoader pluginManager = this.getPluginManager();
        if (null != pluginManager) {
            List<ProviderIdent> providerIdents1 = pluginManager.listProviders();
            for (ProviderIdent providerIdent : providerIdents1) {
                if (!this.getName().equals(providerIdent.getService())) continue;
                providerIdents.add(providerIdent);
            }
        }
        return providerIdents;
    }

    @Override
    public boolean isScriptPluggable() {
        return false;
    }

    @Override
    public T createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        throw new UnsupportedOperationException("This service does not support script plugins");
    }

    protected T createProviderInstanceFromType(Class<? extends T> execClass, String providerName) throws ProviderCreationException {
        try {
            Constructor<T> method = execClass.getDeclaredConstructor(new Class[0]);
            return method.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProviderCreationException("No constructor found with signature (Framework) or (): " + e.getMessage(), e, this.getName(), providerName);
        }
        catch (Exception e) {
            throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
        }
    }

    protected boolean hasValidProviderSignature(Class clazz) {
        try {
            Constructor method = clazz.getDeclaredConstructor(new Class[0]);
            return null != method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    public <X> ProviderService<X> adapter(Converter<T, X> converter) {
        return AdapterService.adaptFor(this, converter);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

