/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.utils.ScriptExecHelper;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseScriptPlugin
extends AbstractDescribableScriptPlugin {
    private ScriptExecHelper scriptExecHelper = ScriptExecUtil.helper();

    protected BaseScriptPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    protected int runPluginScript(PluginStepContext executionContext, PrintStream outputStream, PrintStream errorStream, Framework framework, Map<String, Object> configuration) throws IOException, InterruptedException {
        Map<String, Map<String, String>> localDataContext = this.createStepItemDataContext(framework, executionContext.getFrameworkProject(), executionContext.getDataContext(), configuration);
        String[] finalargs = this.createScriptArgs(localDataContext);
        executionContext.getLogger().log(3, "[" + this.getProvider().getName() + "] executing: " + Arrays.asList(finalargs));
        return this.getScriptExecHelper().runLocalCommand(finalargs, DataContextUtils.generateEnvVarsFromContext(localDataContext), null, outputStream, errorStream);
    }

    protected Map<String, Map<String, String>> createStepItemDataContext(Framework framework, String project, Map<String, Map<String, String>> context, Map<String, Object> configuration) {
        Map<String, Map<String, String>> localDataContext = this.createScriptDataContext(framework, project, context);
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            configMap.put(entry.getKey(), entry.getValue().toString());
        }
        localDataContext.put("config", configMap);
        return localDataContext;
    }

    protected Map<String, Map<String, String>> createScriptDataContext(Framework framework, String project, Map<String, Map<String, String>> context) {
        Map<String, Map<String, String>> localDataContext = ScriptDataContextUtil.createScriptDataContextForProject(framework, project);
        localDataContext.get("plugin").putAll(this.createPluginDataContext());
        localDataContext.putAll(context);
        return localDataContext;
    }

    protected String[] createScriptArgs(Map<String, Map<String, String>> localDataContext) {
        ScriptPluginProvider plugin = this.getProvider();
        File scriptfile = plugin.getScriptFile();
        String scriptargs = plugin.getScriptArgs();
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        return this.getScriptExecHelper().createScriptArgs(localDataContext, scriptargs, null, scriptinterpreter, interpreterargsquoted, scriptfile.getAbsolutePath());
    }

    protected ExecArgList createScriptArgsList(Map<String, Map<String, String>> dataContext) {
        ScriptPluginProvider plugin = this.getProvider();
        File scriptfile = plugin.getScriptFile();
        String scriptargs = null != plugin.getScriptArgs() ? DataContextUtils.replaceDataReferences(plugin.getScriptArgs(), dataContext) : null;
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        return this.getScriptExecHelper().createScriptArgList(scriptfile.getAbsolutePath(), scriptargs, null, scriptinterpreter, interpreterargsquoted);
    }

    public ScriptExecHelper getScriptExecHelper() {
        return this.scriptExecHelper;
    }

    public void setScriptExecHelper(ScriptExecHelper scriptExecHelper) {
        this.scriptExecHelper = scriptExecHelper;
    }
}

