/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Validation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.SourceProvider;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlProvider {
    static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".aclpolicy");
        }
    };

    public static Validation validate(CacheableYamlSource source) {
        return YamlProvider.validate(source, null);
    }

    public static Validation validate(CacheableYamlSource source, Set<Attribute> forcedContext) {
        return YamlProvider.validate(Collections.singletonList(source), forcedContext);
    }

    public static Validation validate(Iterable<CacheableYamlSource> sources, Set<Attribute> forcedContext) {
        return YamlProvider.validate(new ValidationSet(), sources, forcedContext);
    }

    public static Validation validate(Iterable<CacheableYamlSource> sources) {
        return YamlProvider.validate(sources, null);
    }

    private static Validation validate(ValidationSet validation, Iterable<CacheableYamlSource> sources, Set<Attribute> forcedContext) {
        for (CacheableYamlSource source : sources) {
            try {
                YamlPolicyCollection yamlPolicyCollection = YamlProvider.policiesFromSource(source, forcedContext, validation);
            }
            catch (Exception e1) {
                validation.addError(source.getIdentity(), e1.getMessage());
            }
        }
        validation.complete();
        return validation;
    }

    public static YamlPolicyCollection policiesFromSource(YamlSource source) throws IOException {
        return new YamlPolicyCollection(source);
    }

    public static YamlPolicyCollection policiesFromSource(YamlSource source, Set<Attribute> forcedContext) throws IOException {
        return new YamlPolicyCollection(source, forcedContext, null);
    }

    public static YamlPolicyCollection policiesFromSource(YamlSource source, Set<Attribute> forcedContext, ValidationSet validation) throws IOException {
        return new YamlPolicyCollection(source, forcedContext, validation);
    }

    public static YamlPolicyCollection policiesFromFile(File source) throws IOException {
        return new YamlPolicyCollection(YamlProvider.sourceFromFile(source));
    }

    public static CacheableYamlSource sourceFromFile(File file) {
        return new CacheableYamlFileSource(file);
    }

    public static Iterable<CacheableYamlSource> asSources(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir should be a directory");
        }
        return YamlProvider.asSources(dir.listFiles(filenameFilter));
    }

    public static Iterable<CacheableYamlSource> asSources(File[] files) {
        ArrayList<CacheableYamlSource> list = new ArrayList<CacheableYamlSource>();
        if (null != files) {
            for (File file : files) {
                list.add(YamlProvider.sourceFromFile(file));
            }
        }
        return list;
    }

    public static CacheableYamlSource sourceFromString(final String identity, final String content, final Date modified) {
        return new CacheableYamlSource(){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public Date getLastModified() {
                return modified;
            }

            @Override
            public String getIdentity() {
                return identity;
            }

            @Override
            public Iterable<Object> loadAll(Yaml yaml) throws IOException {
                return yaml.loadAll(content);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static CacheableYamlSource sourceFromStream(String identity, InputStream stream, Date modified) {
        return new CacheableYamlStreamSource(stream, identity, modified);
    }

    public static SourceProvider getDirProvider(File rootDir) {
        return new DirProvider(rootDir);
    }

    public static SourceProvider getFileProvider(File singleFile) {
        return new FileProvider(singleFile);
    }

    static class FileProvider
    implements SourceProvider {
        private File file;

        public FileProvider(File file) {
            this.file = file;
        }

        @Override
        public Iterator<CacheableYamlSource> getSourceIterator() {
            return YamlProvider.asSources(new File[]{this.file}).iterator();
        }
    }

    static class DirProvider
    implements SourceProvider {
        private File rootDir;
        long lastDirListCheckTime = 0L;
        private File[] lastDirList;

        public DirProvider(File rootDir) {
            this.rootDir = rootDir;
        }

        private File[] listDirFiles() {
            if (System.currentTimeMillis() - this.lastDirListCheckTime > PoliciesCache.DIR_LIST_CHECK_DELAY) {
                this.doListDir();
            }
            return this.lastDirList;
        }

        private void doListDir() {
            this.lastDirList = this.rootDir.listFiles(filenameFilter);
            this.lastDirListCheckTime = System.currentTimeMillis();
        }

        @Override
        public Iterator<CacheableYamlSource> getSourceIterator() {
            return YamlProvider.asSources(this.listDirFiles()).iterator();
        }
    }

    private static class CacheableYamlStreamSource
    implements CacheableYamlSource {
        private final InputStream stream;
        private final String identity;
        private final Date modified;

        public CacheableYamlStreamSource(InputStream stream, String identity, Date modified) {
            this.stream = stream;
            this.identity = identity;
            this.modified = modified;
        }

        @Override
        public Iterable<Object> loadAll(Yaml yaml) throws IOException {
            return yaml.loadAll(this.stream);
        }

        @Override
        public String getIdentity() {
            return this.identity;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public boolean isValid() {
            try {
                return null != this.stream && this.stream.available() > -1;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Date getLastModified() {
            return this.modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheableYamlStreamSource that = (CacheableYamlStreamSource)o;
            return this.identity.equals(that.identity);
        }

        public int hashCode() {
            return this.identity.hashCode();
        }
    }

    private static class CacheableYamlFileSource
    implements CacheableYamlSource {
        private final File file;
        FileInputStream fileInputStream;

        public CacheableYamlFileSource(File file) {
            this.file = file;
        }

        @Override
        public Iterable<Object> loadAll(Yaml yaml) throws IOException {
            if (null == this.fileInputStream) {
                this.fileInputStream = new FileInputStream(this.file);
            }
            return yaml.loadAll((InputStream)this.fileInputStream);
        }

        @Override
        public String getIdentity() {
            return this.file.getAbsolutePath();
        }

        @Override
        public void close() throws IOException {
            if (null != this.fileInputStream) {
                this.fileInputStream.close();
            }
        }

        @Override
        public boolean isValid() {
            return this.file.exists();
        }

        @Override
        public Date getLastModified() {
            return new Date(this.file.lastModified());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheableYamlFileSource that = (CacheableYamlFileSource)o;
            return this.file.equals(that.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

