/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.project;

import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.BaseAction;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Category;

public class CreateAction
extends BaseAction {
    static Category logger = Category.getInstance((String)CreateAction.class.getName());
    private boolean cygwin;
    private Properties properties;

    public CreateAction(CLIToolLogger main, IPropertyLookup framework, CommandLine cli, Properties properties, CentralDispatcher dispatcher) {
        this(main, framework, CreateAction.parseBaseActionArgs(cli), CreateAction.parseCreateActionArgs(cli), properties, dispatcher);
    }

    public CreateAction(CLIToolLogger main, IPropertyLookup framework, BaseAction.BaseActionArgs baseArgs, CreateActionArgs createArgs, Properties projectProperties, CentralDispatcher dispatcher) {
        super(main, framework, baseArgs, dispatcher);
        this.properties = projectProperties;
        this.setCentralDispatcher(dispatcher);
        this.initArgs(createArgs);
    }

    public boolean isCygwin() {
        return this.cygwin;
    }

    public void setCygwin(boolean cygwin) {
        this.cygwin = cygwin;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static CreateActionArgs parseCreateActionArgs(CommandLine cli) {
        final boolean cygwin = cli.hasOption('G');
        return new CreateActionArgs(){

            @Override
            public boolean isCygwin() {
                return cygwin;
            }
        };
    }

    public static CreateActionArgs createArgs(final boolean cygwin) {
        return new CreateActionArgs(){

            @Override
            public boolean isCygwin() {
                return cygwin;
            }
        };
    }

    private void initArgs(CreateActionArgs args) {
        this.setCygwin(args.isCygwin());
    }

    @Override
    public void exec() throws Throwable {
        super.exec();
        if (this.project == null) {
            throw new IllegalStateException("project was null");
        }
        String projectsDir = this.frameworkProperties.getProperty("framework.projects.dir");
        this.getCentralDispatcher().createProject(this.project, this.generateDefaultedProperties(true, new File(projectsDir, this.project)));
        this.main.log("Project was created: " + this.project);
    }

    private Properties generateDefaultedProperties(boolean addDefaultProps, File projectBaseDir) {
        Properties newProps = new Properties();
        if (addDefaultProps) {
            if (null == this.properties || !this.properties.containsKey("resources.source.1.type")) {
                newProps.setProperty("resources.source.1.type", "file");
                newProps.setProperty("resources.source.1.config.file", new File(projectBaseDir, "etc/resources.xml").getAbsolutePath());
                newProps.setProperty("resources.source.1.config.includeServerNode", "true");
                newProps.setProperty("resources.source.1.config.generateFileAutomatically", "true");
            }
            if (null == this.properties || !this.properties.containsKey("service.NodeExecutor.default.provider")) {
                newProps.setProperty("service.NodeExecutor.default.provider", "jsch-ssh");
            }
            if (null == this.properties || !this.properties.containsKey("service.FileCopier.default.provider")) {
                newProps.setProperty("service.FileCopier.default.provider", "jsch-scp");
            }
            if (null == this.properties || !this.properties.containsKey("project.ssh-keypath")) {
                newProps.setProperty("project.ssh-keypath", new File(System.getProperty("user.home"), ".ssh/id_rsa").getAbsolutePath());
            }
            if (null == this.properties || !this.properties.containsKey("project.ssh-authentication")) {
                newProps.setProperty("project.ssh-authentication", "privateKey");
            }
        }
        newProps.putAll((Map<?, ?>)this.properties);
        return newProps;
    }

    public static interface CreateActionArgs {
        public boolean isCygwin();
    }
}

