/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.queue;

import com.dtolabs.client.services.DispatcherConfig;
import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.BaseTool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.DefaultCLIToolLogger;
import com.dtolabs.rundeck.core.cli.Log4JCLIToolLogger;
import com.dtolabs.rundeck.core.cli.LoglevelOptions;
import com.dtolabs.rundeck.core.cli.queue.ConsoleExecutionFollowReceiver;
import com.dtolabs.rundeck.core.cli.queue.QueueToolException;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.DispatcherResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionDetail;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowRequest;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionState;
import com.dtolabs.rundeck.core.dispatcher.PagedResult;
import com.dtolabs.rundeck.core.dispatcher.Paging;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.execution.BaseLogger;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class QueueTool
extends BaseTool
implements CLIToolLogger,
Paging {
    static final long WAIT_BASE_DELAY = Long.getLong(QueueTool.class.getName() + ".WAIT_BASE_DELAY", 1000L);
    static final long WAIT_MAX_DELAY = Long.getLong(QueueTool.class.getName() + ".WAIT_MAX_DELAY", 5000L);
    public static final Logger log4j = Logger.getLogger(QueueTool.class);
    public static final String ACTION_LIST = "list";
    public static final String ACTION_KILL = "kill";
    public static final String ACTION_FOLLOW = "follow";
    private Actions action = Actions.list;
    private String execid;
    private boolean argVerbose;
    private boolean argQuiet;
    private boolean argProgress;
    private boolean argRestart;
    int argOffset = 0;
    int argMax = 20;
    private CLIToolLogger clilogger;
    String argProject;
    private LoglevelOptions loglevelOptions;
    private Options toolOptions;

    public Actions getAction() {
        return this.action;
    }

    public void setAction(Actions action) {
        this.action = action;
    }

    public String getExecid() {
        return this.execid;
    }

    public void setExecid(String execid) {
        this.execid = execid;
    }

    public boolean isArgVerbose() {
        return this.argVerbose;
    }

    public void setArgVerbose(boolean argVerbose) {
        this.argVerbose = argVerbose;
    }

    @Override
    public int getOffset() {
        return this.argOffset;
    }

    @Override
    public int getMax() {
        return this.argMax;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)Constants.getLog4jPropertiesFile().getAbsolutePath());
        QueueTool tool = new QueueTool(QueueTool.createDefaultDispatcherConfig(), (CLIToolLogger)new DefaultCLIToolLogger());
        tool.setShouldExit(true);
        int exitCode = 1;
        try {
            tool.run(args);
            exitCode = 0;
        }
        catch (CLIToolOptionsException e) {
            exitCode = 2;
            tool.error(e.getMessage());
            tool.help();
        }
        catch (Throwable e) {
            if (e.getMessage() == null || tool.argVerbose) {
                e.printStackTrace();
            }
            tool.error("Error: " + e.getMessage());
        }
        tool.exit(exitCode);
    }

    public QueueTool() {
        this(FrameworkFactory.createFilesystemFramework(new File(Constants.getSystemBaseDir())).getPropertyLookup(), (CLIToolLogger)new Log4JCLIToolLogger(log4j));
    }

    @Override
    protected boolean isUseHelpOption() {
        return true;
    }

    @Override
    public String getHelpString() {
        return "rd-queue <action> : list the executions running in the queue or kill a running execution\nrd-queue [list] : list the executions running in the queue [default]\nrd-queue follow --eid <id> [--restart] : follow the output of an execution\nrd-queue kill --eid <id> : kill an execution running in the queue\n";
    }

    public QueueTool(CLIToolLogger logger) {
        this(FrameworkFactory.createFilesystemFramework(new File(Constants.getSystemBaseDir())).getPropertyLookup(), logger);
    }

    public QueueTool(IPropertyLookup frameworkProperties) {
        this(frameworkProperties, null);
    }

    public QueueTool(IPropertyLookup frameworkProperties, CLIToolLogger logger) {
        this(FrameworkFactory.createDispatcherConfig(frameworkProperties), logger);
    }

    public QueueTool(DispatcherConfig dispatcherConfig, CLIToolLogger logger) {
        this.setCentralDispatcher(FrameworkFactory.createDispatcher(dispatcherConfig));
        this.clilogger = logger;
        if (null == this.clilogger) {
            this.clilogger = new Log4JCLIToolLogger(log4j);
        }
        this.toolOptions = new Options();
        this.addToolOptions(this.toolOptions);
    }

    private String getSingleProjectName() throws CentralDispatcherException {
        List<String> strings = this.getCentralDispatcher().listProjectNames();
        if (strings.size() == 1) {
            return strings.get(0);
        }
        return null;
    }

    @Override
    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        CommandLine line = super.parseArgs(args);
        if (args.length > 0 && !args[0].startsWith("-")) {
            try {
                this.action = Actions.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CLIToolOptionsException("Invalid action: " + args[0]);
            }
        }
        return line;
    }

    @Override
    protected void go() throws QueueToolException, CLIToolOptionsException {
        switch (this.action) {
            case list: {
                this.listAction();
                break;
            }
            case kill: {
                this.killAction(this.execid);
                break;
            }
            case follow: {
                this.followAction(this.execid);
                break;
            }
            default: {
                throw new CLIToolOptionsException("Unrecognized action: " + (Object)((Object)this.action));
            }
        }
    }

    private void killAction(String execid) throws QueueToolException {
        DispatcherResult result;
        try {
            result = this.getDispatcher().killDispatcherExecution(execid);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to kill the execution: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
        if (result.isSuccessful()) {
            this.log("rd-queue kill: success. [" + execid + "] " + result.getMessage());
        } else {
            this.error("rd-queue kill: failed. [" + execid + "] " + result.getMessage());
        }
    }

    private CentralDispatcher getDispatcher() {
        return this.getCentralDispatcher();
    }

    private void listAction() throws QueueToolException {
        PagedResult<QueuedItem> result;
        try {
            result = this.getDispatcher().listDispatcherQueue(this.argProject, this);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
        if (null != result) {
            this.log("Queue: " + result.getResults().size() + (result.getTotal() > -1L ? " of " + result.getTotal() : "") + " items");
            for (QueuedItem item : result.getResults()) {
                String url = item.getUrl();
                this.log("[" + item.getId() + "] " + item.getName() + " <" + url + ">");
            }
        } else {
            throw new QueueToolException("List request returned null");
        }
    }

    private void followAction(String execid) throws QueueToolException {
        ConsoleExecutionFollowReceiver.Mode mode = ConsoleExecutionFollowReceiver.Mode.output;
        if (this.argQuiet) {
            mode = ConsoleExecutionFollowReceiver.Mode.quiet;
        } else if (this.argProgress) {
            mode = ConsoleExecutionFollowReceiver.Mode.progress;
        }
        try {
            QueueTool.followAction(execid, this.argRestart, mode, System.out, this, this.getCentralDispatcher());
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to follow the execution: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
    }

    public static boolean followAction(String execid, final boolean restart, ConsoleExecutionFollowReceiver.Mode mode, PrintStream out, BaseLogger logger, CentralDispatcher dispatcher) throws CentralDispatcherException {
        ExecutionState state;
        ExecutionDetail execution = dispatcher.getExecution(execid);
        long averageDuration = null != execution.getExecutionJob() ? execution.getExecutionJob().getAverageDuration() : -1L;
        ExecutionFollowRequest request = new ExecutionFollowRequest(){

            @Override
            public boolean isResume() {
                return !restart;
            }
        };
        ConsoleExecutionFollowReceiver receiver = new ConsoleExecutionFollowReceiver(averageDuration, mode, out, logger);
        ExecutionFollowResult result = dispatcher.followDispatcherExecution(execid, request, receiver);
        if (mode != ConsoleExecutionFollowReceiver.Mode.output) {
            out.println();
        }
        if (null != (state = result.getState())) {
            if (state == ExecutionState.running) {
                state = QueueTool.awaitExecutionCompletion(execid, dispatcher);
            }
            if (mode != ConsoleExecutionFollowReceiver.Mode.quiet) {
                logger.warn("[" + execid + "] execution status: " + (Object)((Object)state));
            }
            switch (state) {
                case failed: 
                case aborted: {
                    return false;
                }
            }
        }
        return true;
    }

    private static ExecutionState awaitExecutionCompletion(String execid, CentralDispatcher dispatcher) throws CentralDispatcherException {
        ExecutionState state = QueueTool.executionStatus(execid, dispatcher);
        long delay = WAIT_BASE_DELAY;
        while (state == ExecutionState.running) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                return state;
            }
            if (delay < WAIT_MAX_DELAY) {
                delay += WAIT_BASE_DELAY;
            }
            state = QueueTool.executionStatus(execid, dispatcher);
        }
        return state;
    }

    private static ExecutionState executionStatus(String execid, CentralDispatcher dispatcher) throws CentralDispatcherException {
        ExecutionDetail execution = dispatcher.getExecution(execid);
        return execution.getStatus();
    }

    @Override
    public void log(String output) {
        if (null != this.clilogger) {
            this.clilogger.log(output);
        }
    }

    @Override
    public void error(String output) {
        if (null != this.clilogger) {
            this.clilogger.error(output);
        }
    }

    @Override
    public void warn(String output) {
        if (null != this.clilogger) {
            this.clilogger.warn(output);
        }
    }

    @Override
    public void verbose(String message) {
        if (null != this.clilogger && this.argVerbose) {
            this.clilogger.verbose(message);
        }
    }

    @Override
    public void debug(String message) {
        if (null != this.clilogger) {
            this.clilogger.debug(message);
        }
    }

    private class Options
    implements CLIToolOptions {
        public static final String RESTART_OPTION = "t";
        public static final String RESTART_OPTION_LONG = "restart";
        public static final String QUIET_OPTION = "q";
        public static final String QUIET_OPTION_LONG = "quiet";
        public static final String PROGRESS_OPTION = "r";
        public static final String PROGRESS_OPTION_LONG = "progress";
        public static final String EXECID_OPTION = "e";
        public static final String EXECID_OPTION_LONG = "eid";
        public static final String MAX_OPTION = "m";
        public static final String MAX_OPTION_LONG = "max";
        public static final String OFFSET_OPTION = "o";
        public static final String OFFSET_OPTION_LONG = "offset";
        public static final String VERBOSE_OPTION = "v";
        public static final String VERBOSE_OPTION_LONG = "verbose";
        public static final String PROJECT_OPTION = "p";

        private Options() {
        }

        @Override
        public void addOptions(org.apache.commons.cli.Options options) {
            options.addOption(EXECID_OPTION, EXECID_OPTION_LONG, true, "Execution ID");
            options.addOption(VERBOSE_OPTION, VERBOSE_OPTION_LONG, false, "Enable verbose output");
            options.addOption(QUIET_OPTION, QUIET_OPTION_LONG, false, "Just wait until execution ends (follow only)");
            options.addOption(PROGRESS_OPTION, PROGRESS_OPTION_LONG, false, "Progress mark output (follow only)");
            options.addOption(PROJECT_OPTION, null, true, "Project name (list action only)");
            options.addOption(RESTART_OPTION, RESTART_OPTION_LONG, false, "Restart log output from beginning (follow action only)");
            options.addOption(MAX_OPTION, MAX_OPTION_LONG, true, "Maximum result count. Default 20. (list action only)");
            options.addOption(OFFSET_OPTION, OFFSET_OPTION_LONG, true, "First result offset. Default 0. (list action only)");
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(EXECID_OPTION)) {
                QueueTool.this.execid = cli.getOptionValue(EXECID_OPTION);
            }
            if (cli.hasOption(VERBOSE_OPTION)) {
                QueueTool.this.argVerbose = true;
            }
            if (cli.hasOption(PROJECT_OPTION)) {
                QueueTool.this.argProject = cli.getOptionValue(PROJECT_OPTION);
            }
            if (cli.hasOption(RESTART_OPTION)) {
                QueueTool.this.argRestart = true;
            }
            if (cli.hasOption(QUIET_OPTION)) {
                QueueTool.this.argQuiet = true;
            }
            if (cli.hasOption(PROGRESS_OPTION)) {
                QueueTool.this.argProgress = true;
            }
            if (cli.hasOption(MAX_OPTION)) {
                QueueTool.this.argMax = Integer.parseInt(cli.getOptionValue(MAX_OPTION));
            }
            if (cli.hasOption(OFFSET_OPTION)) {
                QueueTool.this.argOffset = Integer.parseInt(cli.getOptionValue(OFFSET_OPTION));
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (Actions.list == QueueTool.this.action) {
                this.validateListAction();
            } else if (Actions.kill == QueueTool.this.action) {
                this.validateKillAction();
            } else if (Actions.follow == QueueTool.this.action) {
                this.validateFollowAction();
            }
        }

        private void validateListAction() throws CLIToolOptionsException {
            if (null != QueueTool.this.execid) {
                QueueTool.this.warn("-e/--eid argument only valid with kill/follow actions");
            }
            if (null == QueueTool.this.argProject) {
                try {
                    QueueTool.this.argProject = QueueTool.this.getSingleProjectName();
                }
                catch (CentralDispatcherException e) {
                    throw new CLIToolOptionsException("Could not determine project: " + e.getMessage(), e);
                }
                if (null != QueueTool.this.argProject) {
                    QueueTool.this.debug("# No project specified, defaulting to: " + QueueTool.this.argProject);
                } else {
                    throw new CLIToolOptionsException("-p argument is required with list action");
                }
            }
        }

        private void validateKillAction() throws CLIToolOptionsException {
            if (null == QueueTool.this.execid) {
                throw new CLIToolOptionsException("-e/--eid argument required");
            }
            if (null != QueueTool.this.argProject) {
                QueueTool.this.warn("-p argument only valid with list action");
            }
        }

        private void validateFollowAction() throws CLIToolOptionsException {
            if (null == QueueTool.this.execid) {
                throw new CLIToolOptionsException("-e/--eid argument required");
            }
            if (null != QueueTool.this.argProject) {
                QueueTool.this.warn("-p argument only valid with list action");
            }
        }

        public String getJobid() {
            return QueueTool.this.execid;
        }
    }

    public static enum Actions {
        list("list"),
        kill("kill"),
        follow("follow");

        private String name;

        private Actions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

