/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetMerge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AdditiveListNodeSet
implements INodeSet,
NodeSetMerge {
    final Set<String> nodeNames = new TreeSet<String>();
    final Map<String, INodeSet> nodeIndex = new HashMap<String, INodeSet>();

    @Override
    public synchronized void addNodeSet(INodeSet nodeSet) {
        if (null == nodeSet) {
            return;
        }
        this.nodeNames.addAll(nodeSet.getNodeNames());
        for (String name : nodeSet.getNodeNames()) {
            this.nodeIndex.put(name, nodeSet);
        }
    }

    @Override
    public synchronized Collection<INodeEntry> getNodes() {
        ArrayList<INodeEntry> nodes = new ArrayList<INodeEntry>();
        for (String nodeName : this.nodeNames) {
            nodes.add(this.nodeIndex.get(nodeName).getNode(nodeName));
        }
        return nodes;
    }

    @Override
    public synchronized INodeEntry getNode(String name) {
        INodeEntry result = null;
        INodeSet iNodeEntries = this.nodeIndex.get(name);
        if (null != iNodeEntries) {
            result = iNodeEntries.getNode(name);
        }
        return result;
    }

    @Override
    public synchronized Collection<String> getNodeNames() {
        return new TreeSet<String>(this.nodeNames);
    }

    @Override
    public Iterator<INodeEntry> iterator() {
        return this.getNodes().iterator();
    }
}

