/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.common.IFrameworkNodes;
import com.dtolabs.rundeck.core.common.INodeDesc;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeSupport
implements IFrameworkNodes {
    private IPropertyLookup lookup;
    private INodeDesc nodedesc;

    @Override
    public String getFrameworkNodeHostname() {
        String hostname = this.getLookup().getProperty("framework.server.hostname");
        if (null != hostname) {
            return hostname.trim();
        }
        return hostname;
    }

    @Override
    public String getFrameworkNodeName() {
        String name = this.getLookup().getProperty("framework.server.name");
        if (null != name) {
            return name.trim();
        }
        return name;
    }

    @Override
    public NodeEntryImpl createFrameworkNode() {
        NodeEntryImpl node = new NodeEntryImpl(this.getFrameworkNodeHostname(), this.getFrameworkNodeName());
        node.setUsername(this.getLookup().getProperty("framework.ssh.user"));
        node.setDescription("Rundeck server node");
        node.setOsArch(System.getProperty("os.arch"));
        node.setOsName(System.getProperty("os.name"));
        node.setOsVersion(System.getProperty("os.version"));
        String s = System.getProperty("file.separator");
        node.setOsFamily("/".equals(s) ? "unix" : ("\\".equals(s) ? "windows" : ""));
        return node;
    }

    @Override
    public INodeSet filterAuthorizedNodes(String project, Set<String> actions, INodeSet unfiltered, AuthContext authContext) {
        if (null == actions || actions.size() <= 0) {
            return unfiltered;
        }
        HashSet<Map<String, String>> resources = new HashSet<Map<String, String>>();
        for (INodeEntry iNodeEntry : unfiltered.getNodes()) {
            HashMap<String, String> resdef = new HashMap<String, String>(iNodeEntry.getAttributes());
            resdef.put("type", "node");
            resdef.put("rundeck_server", Boolean.toString(this.isLocalNode(iNodeEntry)));
            resources.add(resdef);
        }
        Set<Decision> decisions = authContext.evaluate(resources, actions, Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), project)));
        NodeSetImpl authorized = new NodeSetImpl();
        HashMap authorizations = new HashMap();
        for (Decision decision : decisions) {
            if (!decision.isAuthorized() || !actions.contains(decision.getAction())) continue;
            String nodename = decision.getResource().get("nodename");
            if (null == authorizations.get(nodename)) {
                authorizations.put(nodename, new HashSet());
            }
            ((Set)authorizations.get(nodename)).add(decision.getAction());
        }
        for (Map.Entry entry : authorizations.entrySet()) {
            if (((Set)entry.getValue()).size() != actions.size()) continue;
            authorized.putNode(unfiltered.getNode((String)entry.getKey()));
        }
        return authorized;
    }

    @Override
    public INodeDesc getNodeDesc() {
        if (null == this.nodedesc) {
            this.nodedesc = NodeEntryImpl.create(this.getFrameworkNodeHostname(), this.getFrameworkNodeName());
        }
        return this.nodedesc;
    }

    @Override
    public boolean isLocalNode(INodeDesc node) {
        String fwkNodeName = this.getFrameworkNodeName();
        return fwkNodeName.equals(node.getNodename());
    }

    public IPropertyLookup getLookup() {
        return this.lookup;
    }

    public void setLookup(IPropertyLookup lookup) {
        this.lookup = lookup;
    }
}

