/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.MergedAttributesNodeSet;
import com.dtolabs.rundeck.core.common.NodeSetMerge;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.CachingResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.LoggingResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.URLResourceModelSource;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ProjectNodeSupport
implements IProjectNodes {
    private static final Logger logger = Logger.getLogger(ProjectNodeSupport.class);
    public static final String NODES_XML = "resources.xml";
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String PROJECT_RESOURCES_FILEFORMAT_PROPERTY = "project.resources.file.format";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    public static final String PROJECT_RESOURCES_ALLOWED_URL_PREFIX = "project.resources.allowedURL.";
    public static final String FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX = "framework.resources.allowedURL.";
    private IRundeckProject project;
    private ArrayList<Exception> nodesSourceExceptions;
    private long nodesSourcesLastReload = -1L;
    private List<ResourceModelSource> nodesSourceList;
    private ResourceFormatGeneratorService resourceFormatGeneratorService;
    private ResourceModelSourceService resourceModelSourceService;
    static Set<String> uncachedResourceTypes = new HashSet<String>();

    public ProjectNodeSupport(IRundeckProject project, ResourceFormatGeneratorService resourceFormatGeneratorService, ResourceModelSourceService resourceModelSourceService) {
        this.project = project;
        this.resourceFormatGeneratorService = resourceFormatGeneratorService;
        this.resourceModelSourceService = resourceModelSourceService;
    }

    private boolean shouldCacheForType(String type) {
        return !uncachedResourceTypes.contains(type);
    }

    private NodeSetMerge getNodeSetMerge() {
        if (this.project.hasProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES) && "false".equals(this.project.getProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES))) {
            return new AdditiveListNodeSet();
        }
        return new MergedAttributesNodeSet();
    }

    @Override
    public INodeSet getNodeSet() {
        NodeSetMerge list = this.getNodeSetMerge();
        this.nodesSourceExceptions = new ArrayList();
        for (ResourceModelSource nodesSource : this.getResourceModelSources()) {
            try {
                INodeSet nodes = nodesSource.getNodes();
                if (null == nodes) {
                    logger.warn((Object)("Empty nodes result from [" + nodesSource.toString() + "]"));
                    continue;
                }
                list.addNodeSet(nodes);
            }
            catch (ResourceModelSourceException e) {
                logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage(), e));
            }
            catch (RuntimeException e) {
                logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage(), e));
            }
            catch (Throwable e) {
                logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()));
            }
        }
        return list;
    }

    @Override
    public ArrayList<Exception> getResourceModelSourceExceptions() {
        return this.nodesSourceExceptions;
    }

    private synchronized Collection<ResourceModelSource> getResourceModelSources() {
        long lastMod;
        long l = lastMod = this.project.getConfigLastModifiedTime() != null ? this.project.getConfigLastModifiedTime().getTime() : 0L;
        if (lastMod > this.nodesSourcesLastReload) {
            this.nodesSourceList = new ArrayList<ResourceModelSource>();
            this.loadResourceModelSources();
        }
        return this.nodesSourceList;
    }

    private void loadResourceModelSources() {
        Properties config;
        this.nodesSourceExceptions = new ArrayList();
        if (this.project.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            try {
                config = this.createFileSourceConfiguration();
                logger.info((Object)("Source (project.resources.file): loading with properties: " + config));
                this.nodesSourceList.add(this.loadResourceModelSource("file", config, this.shouldCacheForType("file"), "file.file"));
            }
            catch (ExecutionServiceException e) {
                logger.error((Object)("Failed to load file resource model source: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
        }
        if (this.project.hasProperty(PROJECT_RESOURCES_URL_PROPERTY)) {
            try {
                config = this.createURLSourceConfiguration();
                logger.info((Object)("Source (project.resources.url): loading with properties: " + config));
                this.nodesSourceList.add(this.loadResourceModelSource("url", config, this.shouldCacheForType("url"), "file.url"));
            }
            catch (ExecutionServiceException e) {
                logger.error((Object)("Failed to load file resource model source: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
        }
        List<Map<String, Object>> list = this.listResourceModelConfigurations();
        int i = 1;
        for (Map<String, Object> map : list) {
            String providerType = (String)map.get("type");
            Properties props = (Properties)map.get("props");
            logger.info((Object)("Source #" + i + " (" + providerType + "): loading with properties: " + props));
            try {
                this.nodesSourceList.add(this.loadResourceModelSource(providerType, props, this.shouldCacheForType(providerType), i + "." + providerType));
            }
            catch (ExecutionServiceException e) {
                logger.error((Object)("Failed loading resource model source #" + i + ", skipping: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
            ++i;
        }
        Date configLastModifiedTime = this.project.getConfigLastModifiedTime();
        this.nodesSourcesLastReload = configLastModifiedTime != null ? configLastModifiedTime.getTime() : -1L;
    }

    private Properties createURLSourceConfiguration() {
        URLResourceModelSource.Configuration build = URLResourceModelSource.Configuration.build();
        build.url(this.project.getProperty(PROJECT_RESOURCES_URL_PROPERTY));
        build.project(this.project.getName());
        return build.getProperties();
    }

    private File getResourceModelSourceFileCacheForType(String ident) {
        String varDir = this.project.getProperty("framework.var.dir");
        File file = new File(varDir, "resourceModelSourceCache/" + this.project.getName() + "/" + ident + ".xml");
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.warn((Object)"Failed to create cache dirs for source file cache");
        }
        return file;
    }

    private ResourceModelSource createCachingSource(ResourceModelSource sourceForConfiguration, String ident, String descr) {
        File file = this.getResourceModelSourceFileCacheForType(ident);
        ResourceModelSourceService nodesSourceService = this.getResourceModelSourceService();
        ResourceFormatGeneratorService resourceFormatGeneratorService = this.getResourceFormatGeneratorService();
        Properties fileSourceConfig = this.generateFileSourceConfigurationProperties(file.getAbsolutePath(), "resourcexml", true, false);
        try {
            ResourceModelSource fileSource = nodesSourceService.getSourceForConfiguration("file", fileSourceConfig);
            ResourceFormatGenerator generatorForFormat = resourceFormatGeneratorService.getGeneratorForFormat("resourcexml");
            String ident1 = "[ResourceModelSource: " + descr + ", project: " + this.project.getName() + "]";
            return new CachingResourceModelSource(sourceForConfiguration, ident1, new LoggingResourceModelSourceCache(new FileResourceModelSourceCache(file, generatorForFormat, fileSource), ident1));
        }
        catch (UnsupportedFormatException e) {
            e.printStackTrace();
        }
        catch (ExecutionServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return this.resourceFormatGeneratorService;
    }

    private ResourceModelSourceService getResourceModelSourceService() {
        return this.resourceModelSourceService;
    }

    private ResourceModelSource loadResourceModelSource(String type, Properties configuration, boolean useCache, String ident) throws ExecutionServiceException {
        ResourceModelSourceService nodesSourceService = this.getResourceModelSourceService();
        configuration.put("project", this.project.getName());
        ResourceModelSource sourceForConfiguration = nodesSourceService.getSourceForConfiguration(type, configuration);
        if (useCache) {
            ResourceModelSourceFactory provider = (ResourceModelSourceFactory)nodesSourceService.providerOfType(type);
            String name = ident;
            if (provider instanceof Describable) {
                Describable desc = (Describable)((Object)provider);
                Description description = desc.getDescription();
                name = ident + " (" + description.getTitle() + ")";
            }
            return this.createCachingSource(sourceForConfiguration, ident, name);
        }
        return sourceForConfiguration;
    }

    private Properties generateFileSourceConfigurationProperties(String filepath, String format, boolean generate, boolean includeServerNode) {
        FileResourceModelSource.Configuration build = FileResourceModelSource.Configuration.build();
        build.file(filepath);
        if (null != format) {
            build.format(format);
        }
        build.project(this.project.getName());
        build.generateFileAutomatically(generate);
        build.includeServerNode(includeServerNode);
        return build.getProperties();
    }

    private Properties createFileSourceConfiguration() {
        String format = null;
        if (this.project.hasProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY)) {
            format = this.project.getProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY);
        }
        return this.generateFileSourceConfigurationProperties(this.project.getProperty(PROJECT_RESOURCES_FILE_PROPERTY), format, true, true);
    }

    @Override
    public synchronized List<Map<String, Object>> listResourceModelConfigurations() {
        Map<String, String> propertiesMap = this.project.getProperties();
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        return ProjectNodeSupport.listResourceModelConfigurations(properties);
    }

    public static List<Map<String, Object>> listResourceModelConfigurations(Properties props) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 1;
        boolean done = false;
        while (!done) {
            String prefix = "resources.source." + i;
            if (props.containsKey(prefix + ".type")) {
                String providerType = props.getProperty(prefix + ".type");
                Properties configProps = new Properties();
                int len = (prefix + ".config.").length();
                for (Object o : props.keySet()) {
                    String key = (String)o;
                    if (!key.startsWith(prefix + ".config.")) continue;
                    configProps.setProperty(key.substring(len), props.getProperty(key));
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", providerType);
                map.put("props", configProps);
                list.add(map);
            } else {
                done = true;
            }
            ++i;
        }
        return list;
    }

    public static String getNodesResourceFilePath(IRundeckProject project, Framework framework) {
        if (project.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            return new File(project.getProperty(PROJECT_RESOURCES_FILE_PROPERTY)).getAbsolutePath();
        }
        if (null != framework) {
            File etcDir = new File(framework.getFrameworkProjectsBaseDir(), project.getName() + "/etc/");
            if (framework.hasProperty("framework.nodes.file.name")) {
                return new File(etcDir, framework.getProperty("framework.nodes.file.name")).getAbsolutePath();
            }
            return new File(etcDir, NODES_XML).getAbsolutePath();
        }
        return null;
    }

    private boolean shouldUpdateNodesResourceFile() {
        return this.project.hasProperty(PROJECT_RESOURCES_URL_PROPERTY);
    }

    @Override
    public boolean updateNodesResourceFile(String nodesResourcesFilePath) throws UpdateUtils.UpdateException {
        if (this.shouldUpdateNodesResourceFile()) {
            this.updateNodesResourceFileFromUrl(this.project.getProperty(PROJECT_RESOURCES_URL_PROPERTY), null, null, nodesResourcesFilePath);
            return true;
        }
        return false;
    }

    @Override
    public void updateNodesResourceFileFromUrl(String providerURL, String username, String password, String nodesResourceFilePath) throws UpdateUtils.UpdateException {
        if (!this.validateResourceProviderURL(providerURL)) {
            throw new UpdateUtils.UpdateException("providerURL is not allowed: " + providerURL);
        }
        UpdateUtils.updateFileFromUrl(providerURL, nodesResourceFilePath, username, password, URLFileUpdater.factory());
        logger.debug((Object)("Updated nodes resources file: " + nodesResourceFilePath));
    }

    boolean validateResourceProviderURL(String providerURL) throws UpdateUtils.UpdateException {
        URL url;
        try {
            url = new URL(providerURL);
        }
        catch (MalformedURLException e) {
            throw new UpdateUtils.UpdateException("Invalid URL: " + providerURL, e);
        }
        if (!("file".equals(url.getProtocol()) || "http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
            throw new UpdateUtils.UpdateException("URL protocol not allowed: " + url.getProtocol());
        }
        return this.isAllowedProviderURL(providerURL);
    }

    boolean isAllowedProviderURL(String providerURL) {
        if (this.project.hasProperty(PROJECT_RESOURCES_URL_PROPERTY) && this.project.getProperty(PROJECT_RESOURCES_URL_PROPERTY).equals(providerURL)) {
            return true;
        }
        int i = 0;
        boolean projpass = false;
        boolean setproj = false;
        while (this.project.hasProperty(PROJECT_RESOURCES_ALLOWED_URL_PREFIX + i)) {
            setproj = true;
            String regex = this.project.getProperty(PROJECT_RESOURCES_ALLOWED_URL_PREFIX + i);
            Pattern pat = Pattern.compile(regex, 2);
            Matcher matcher = pat.matcher(providerURL);
            if (matcher.matches()) {
                logger.debug((Object)("ProviderURL allowed by project property \"project.resources.allowedURL." + i + "\": " + regex));
                projpass = true;
                break;
            }
            ++i;
        }
        if (!projpass && setproj) {
            return false;
        }
        i = 0;
        boolean setframework = this.project.hasProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i);
        if (!setframework && projpass) {
            return true;
        }
        if (!setframework && !setproj) {
            return false;
        }
        while (this.project.hasProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i)) {
            String regex = this.project.getProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i);
            Pattern pat = Pattern.compile(regex, 2);
            Matcher matcher = pat.matcher(providerURL);
            if (matcher.matches()) {
                logger.debug((Object)("ProviderURL allowed by framework property \"framework.resources.allowedURL." + i + "\": " + regex));
                return true;
            }
            ++i;
        }
        if (projpass) {
            logger.warn((Object)("providerURL was allowed by project.properties, but is not allowed by framework.properties: " + providerURL));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodesResourceFile(INodeSet nodeset, String nodesResourceFilePath) throws UpdateUtils.UpdateException {
        ResourceFormatGenerator generator;
        File destfile = new File(nodesResourceFilePath);
        try {
            generator = this.resourceFormatGeneratorService.getGeneratorForFileExtension(destfile);
        }
        catch (UnsupportedFormatException e) {
            throw new UpdateUtils.UpdateException("Unable to determine file format for file: " + nodesResourceFilePath, e);
        }
        File resfile = null;
        try {
            resfile = File.createTempFile("resource-temp", destfile.getName());
            resfile.deleteOnExit();
        }
        catch (IOException e) {
            throw new UpdateUtils.UpdateException("Unable to create temp file: " + e.getMessage(), e);
        }
        try (FileOutputStream stream = new FileOutputStream(resfile);){
            generator.generateDocument(nodeset, stream);
        }
        catch (IOException e) {
            throw new UpdateUtils.UpdateException("Unable to generate resources file: " + e.getMessage(), e);
        }
        catch (ResourceFormatGeneratorException e) {
            throw new UpdateUtils.UpdateException("Unable to generate resources file: " + e.getMessage(), e);
        }
        this.updateNodesResourceFile(resfile, nodesResourceFilePath);
        if (!resfile.delete()) {
            logger.warn((Object)("failed to remove temp file: " + resfile));
        }
        logger.debug((Object)("generated resources file: " + resfile.getAbsolutePath()));
    }

    public void updateNodesResourceFile(File source, String nodesResourceFilePath) throws UpdateUtils.UpdateException {
        UpdateUtils.updateFileFromFile(source, nodesResourceFilePath);
        logger.debug((Object)("Updated nodes resources file: " + nodesResourceFilePath));
    }

    static {
        uncachedResourceTypes.add("file");
        uncachedResourceTypes.add("directory");
    }
}

