/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.steps.BuiltinStepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepPluginAdapter;
import com.dtolabs.rundeck.core.plugins.ChainedProviderService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.List;

public class StepExecutionService
extends ChainedProviderService<StepExecutor>
implements DescribableService {
    public static final String SERVICE_NAME = "WorkflowStep";
    private List<ProviderService<StepExecutor>> serviceList = new ArrayList<ProviderService<StepExecutor>>();
    private BuiltinStepExecutionService builtinStepExecutionService;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    StepExecutionService(Framework framework) {
        this.builtinStepExecutionService = new BuiltinStepExecutionService(SERVICE_NAME, framework);
        ProviderService<StepExecutor> pluginStepExecutionService = new PluginStepExecutionService(SERVICE_NAME, framework).adapter(StepPluginAdapter.CONVERTER);
        this.serviceList.add(this.builtinStepExecutionService);
        this.serviceList.add(pluginStepExecutionService);
    }

    @Override
    protected List<ProviderService<StepExecutor>> getServiceList() {
        return this.serviceList;
    }

    public static StepExecutionService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            StepExecutionService service = new StepExecutionService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (StepExecutionService)framework.getService(SERVICE_NAME);
    }

    public StepExecutor getExecutorForItem(StepExecutionItem item) throws ExecutionServiceException {
        return (StepExecutor)this.providerOfType(item.getType());
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    public void registerClass(String name, Class<? extends StepExecutor> clazz) {
        this.builtinStepExecutionService.registerClass(name, clazz);
    }

    public void registerInstance(String name, StepExecutor object) {
        this.builtinStepExecutionService.registerInstance(name, object);
    }
}

