/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.plugins.descriptions.Password;
import com.dtolabs.rundeck.plugins.descriptions.PluginDescription;
import com.dtolabs.rundeck.plugins.descriptions.PluginProperty;
import com.dtolabs.rundeck.plugins.descriptions.SelectValues;
import com.dtolabs.rundeck.plugins.descriptions.TextArea;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PluginAdapterUtility {
    private static final List<PropertyScope> instanceScopes = Arrays.asList(PropertyScope.Instance, PropertyScope.InstanceOnly);

    public static boolean canBuildDescription(Object object) {
        Plugin annotation1 = object.getClass().getAnnotation(Plugin.class);
        return null != annotation1;
    }

    public static Description buildDescription(Object object, DescriptionBuilder builder) {
        return PluginAdapterUtility.buildDescription(object, builder, true);
    }

    public static Description buildDescription(Object object, DescriptionBuilder builder, boolean includeAnnotatedFieldProperties) {
        PluginDescription descAnnotation;
        Plugin annotation1 = object.getClass().getAnnotation(Plugin.class);
        if (null != annotation1) {
            String pluginName = annotation1.name();
            builder.name(pluginName).title(pluginName).description("");
        }
        if (null != (descAnnotation = object.getClass().getAnnotation(PluginDescription.class))) {
            if (!"".equals(descAnnotation.title())) {
                builder.title(descAnnotation.title());
            }
            if (!"".equals(descAnnotation.description())) {
                builder.description(descAnnotation.description());
            }
        }
        if (includeAnnotatedFieldProperties) {
            for (Field field : PluginAdapterUtility.collectFields(object)) {
                Property pbuild;
                PluginProperty annotation = field.getAnnotation(PluginProperty.class);
                if (null == annotation || null == (pbuild = PluginAdapterUtility.propertyFromField(field, annotation))) continue;
                builder.property(pbuild);
            }
        }
        builder.collaborate(object);
        return builder.build();
    }

    private static Field fieldForPropertyName(String name, Object object) {
        for (Field field : PluginAdapterUtility.collectFields(object)) {
            PluginProperty annotation = field.getAnnotation(PluginProperty.class);
            if (null == annotation) continue;
            if (!"".equals(annotation.name()) && name.equals(annotation.name())) {
                return field;
            }
            if (!"".equals(annotation.name()) || !name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    private static Collection<Field> collectFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = object.getClass();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields;
    }

    private static Property.Type propertyTypeFromFieldType(Class clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Property.Type.Integer;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Property.Type.Long;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Property.Type.Boolean;
        }
        if (clazz == String.class) {
            return Property.Type.String;
        }
        return null;
    }

    private static Property propertyFromField(Field field, PluginProperty annotation) {
        String name;
        PropertyBuilder pbuild = PropertyBuilder.builder();
        Property.Type type = PluginAdapterUtility.propertyTypeFromFieldType(field.getType());
        if (null == type) {
            return null;
        }
        pbuild.type(type);
        if (type == Property.Type.String) {
            StringRenderingConstants.DisplayType renderBehaviour = StringRenderingConstants.DisplayType.SINGLE_LINE;
            SelectValues selectAnnotation = field.getAnnotation(SelectValues.class);
            if (null != selectAnnotation) {
                pbuild.type(selectAnnotation.freeSelect() ? Property.Type.FreeSelect : Property.Type.Select);
                pbuild.values(selectAnnotation.values());
            }
            if (field.getAnnotation(TextArea.class) != null) {
                renderBehaviour = StringRenderingConstants.DisplayType.MULTI_LINE;
            }
            if (field.getAnnotation(Password.class) != null) {
                renderBehaviour = StringRenderingConstants.DisplayType.PASSWORD;
            }
            pbuild.renderingOption("displayType", (Object)renderBehaviour);
        }
        if (null == (name = annotation.name()) || "".equals(name)) {
            name = field.getName();
        }
        pbuild.name(name);
        if (null != annotation.title() && !"".equals(annotation.title())) {
            pbuild.title(annotation.title());
        } else {
            pbuild.title(name);
        }
        pbuild.description(annotation.description());
        if (null != annotation.defaultValue() && !"".equals(annotation.defaultValue())) {
            pbuild.defaultValue(annotation.defaultValue());
        }
        pbuild.required(annotation.required());
        pbuild.scope(annotation.scope());
        return pbuild.build();
    }

    public static Map<String, Object> configureProperties(PropertyResolver resolver, Object object) {
        return PluginAdapterUtility.configureProperties(resolver, PluginAdapterUtility.buildDescription(object, DescriptionBuilder.builder()), object, PropertyScope.InstanceOnly);
    }

    public static Map<String, Object> configureProperties(PropertyResolver resolver, Description description, Object object, PropertyScope defaultScope) {
        Map<String, Object> inputConfig = PluginAdapterUtility.mapDescribedProperties(resolver, description, defaultScope);
        if (object instanceof Configurable) {
            Configurable configObject = (Configurable)object;
            Properties configuration = new Properties();
            configuration.putAll(inputConfig);
            try {
                configObject.configure(configuration);
            }
            catch (ConfigurationException e) {}
        } else {
            for (Property property : description.getProperties()) {
                if (null == inputConfig.get(property.getName()) || !PluginAdapterUtility.setValueForProperty(property, inputConfig.get(property.getName()), object)) continue;
                inputConfig.remove(property.getName());
            }
        }
        return inputConfig;
    }

    public static Map<String, Object> mapDescribedProperties(PropertyResolver resolver, Description description) {
        return PluginAdapterUtility.mapDescribedProperties(resolver, description, null);
    }

    public static Map<String, Object> mapDescribedProperties(PropertyResolver resolver, Description description, PropertyScope defaultPropertyScope) {
        List<Property> properties = description.getProperties();
        return PluginAdapterUtility.mapProperties(resolver, properties, defaultPropertyScope);
    }

    public static Map<String, Object> mapProperties(PropertyResolver resolver, List<Property> properties, PropertyScope defaultPropertyScope) {
        PropertyResolver defaulted = PropertyResolverFactory.withDefaultValues(PropertyResolverFactory.withDefaultScope(null != defaultPropertyScope ? defaultPropertyScope : PropertyScope.InstanceOnly, resolver), new PropertyDefaultValues(properties));
        return PropertyResolverFactory.mapPropertyValues(properties, defaulted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean setValueForProperty(Property property, Object value, Object object) {
        Object resolvedValue;
        Field field = PluginAdapterUtility.fieldForPropertyName(property.getName(), object);
        if (null == field) {
            return false;
        }
        Property.Type type = property.getType();
        Property.Type ftype = PluginAdapterUtility.propertyTypeFromFieldType(field.getType());
        if (ftype != property.getType() && (ftype != Property.Type.String || property.getType() != Property.Type.Select && property.getType() != Property.Type.FreeSelect)) {
            throw new IllegalStateException("cannot map property {" + property.getName() + " type: " + (Object)((Object)property.getType()) + "} to field {" + field.getName() + " type: " + (Object)((Object)ftype) + "}");
        }
        if (type == Property.Type.Integer) {
            Integer intvalue;
            if (value instanceof String) {
                intvalue = Integer.parseInt((String)value);
            } else {
                if (!(value instanceof Integer)) return false;
                intvalue = (Integer)value;
            }
            resolvedValue = intvalue;
        } else if (type == Property.Type.Long) {
            Long longvalue;
            if (value instanceof String) {
                longvalue = Long.parseLong((String)value);
            } else if (value instanceof Long) {
                longvalue = (Long)value;
            } else {
                if (!(value instanceof Integer)) return false;
                int val = (Integer)value;
                longvalue = val;
            }
            resolvedValue = longvalue;
        } else if (type == Property.Type.Boolean) {
            Boolean boolvalue;
            if (value instanceof String) {
                boolvalue = Boolean.parseBoolean((String)value);
            } else {
                if (!(value instanceof Boolean)) return false;
                boolvalue = (Boolean)value;
            }
            resolvedValue = boolvalue;
        } else if (type == Property.Type.String || type == Property.Type.FreeSelect) {
            if (!(value instanceof String)) return false;
            resolvedValue = value;
        } else {
            if (type != Property.Type.Select) return false;
            if (!(value instanceof String)) return false;
            resolvedValue = value;
            if (!property.getSelectValues().contains((String)resolvedValue)) {
                throw new RuntimeException("value not allowed for property " + property.getName() + ": " + resolvedValue);
            }
        }
        try {
            PluginAdapterUtility.setFieldValue(field, resolvedValue, object);
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to configure plugin: " + e.getMessage(), e);
        }
    }

    private static void setFieldValue(Field field, Object value, Object object) throws IllegalAccessException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(object, value);
    }

    private static class PropertyDefaultValues
    implements PropertyRetriever {
        private Map<String, String> properties = new HashMap<String, String>();

        private PropertyDefaultValues(List<Property> properties1) {
            for (Property property : properties1) {
                if (null == property.getDefaultValue()) continue;
                this.properties.put(property.getName(), property.getDefaultValue());
            }
        }

        @Override
        public String getProperty(String name) {
            return this.properties.get(name);
        }
    }
}

