/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Validator {
    public static Report errorReport(String key, String message) {
        return Validator.buildReport().error(key, message).build();
    }

    public static ReportBuilder buildReport() {
        return new ReportBuilder();
    }

    public static Report validate(Properties props, Description desc) {
        Report report = new Report();
        List<Property> properties = desc.getProperties();
        Validator.validate(props, report, properties, null);
        return report;
    }

    private static void validate(Properties props, Report report, List<Property> properties, PropertyScope ignoredScope) {
        if (null != properties) {
            for (Property property : properties) {
                if (null != ignoredScope && property.getScope() != null && property.getScope().compareTo(ignoredScope) <= 0) continue;
                String key = property.getName();
                String value = props.getProperty(key);
                if (null == value || "".equals(value)) {
                    if (!property.isRequired()) continue;
                    report.errors.put(key, "required");
                    continue;
                }
                PropertyValidator validator = property.getValidator();
                if (null == validator) continue;
                try {
                    if (validator.isValid(value)) continue;
                    report.errors.put(key, "Invalid value");
                }
                catch (ValidationException e) {
                    report.errors.put(key, "Invalid value: " + e.getMessage());
                }
            }
        }
    }

    public static Report validate(PropertyResolver resolver, Description description, PropertyScope defaultScope) {
        return Validator.validate(resolver, description, defaultScope, null);
    }

    public static Report validate(PropertyResolver resolver, Description description, PropertyScope defaultScope, PropertyScope ignoredScope) {
        Report report = new Report();
        List<Property> properties = description.getProperties();
        Map<String, Object> inputConfig = PluginAdapterUtility.mapDescribedProperties(resolver, description, defaultScope);
        Validator.validate(Validator.asProperties(inputConfig), report, properties, ignoredScope);
        return report;
    }

    public static Report validateProperties(PropertyResolver resolver, List<Property> properties, PropertyScope defaultScope, PropertyScope ignoredScope) {
        Report report = new Report();
        Map<String, Object> inputConfig = PluginAdapterUtility.mapProperties(resolver, properties, defaultScope);
        Validator.validate(Validator.asProperties(inputConfig), report, properties, ignoredScope);
        return report;
    }

    private static Properties asProperties(Map<String, Object> inputConfig) {
        Properties configuration = new Properties();
        configuration.putAll(inputConfig);
        return configuration;
    }

    public static Map<String, String> mapProperties(Map<String, String> input, Description desc) {
        Map<String, String> mapping = desc.getPropertiesMapping();
        if (null == mapping) {
            return input;
        }
        return Validator.performMapping(input, mapping, false);
    }

    private static Map<String, String> performMapping(Map<String, String> input, Map<String, String> mapping, boolean skip) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            if (null != mapping.get(entry.getKey())) {
                props.put(mapping.get(entry.getKey()), entry.getValue());
                continue;
            }
            if (skip) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Map<String, String> demapProperties(Map<String, String> input, Description desc) {
        Map<String, String> mapping = desc.getPropertiesMapping();
        if (null == mapping) {
            return input;
        }
        HashMap<String, String> rev = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        return Validator.performMapping(input, rev, true);
    }

    public static class Report {
        private HashMap<String, String> errors = new HashMap();

        public HashMap<String, String> getErrors() {
            return this.errors;
        }

        public boolean isValid() {
            return 0 == this.errors.size();
        }

        public String toString() {
            if (this.isValid()) {
                return "Property validation OK.";
            }
            return "Property validation FAILED. errors=" + this.errors;
        }
    }

    public static class ReportBuilder {
        Report report = new Report();

        public ReportBuilder error(String key, String message) {
            this.report.errors.put(key, message);
            return this;
        }

        public Report build() {
            return this.report;
        }
    }
}

