/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.ThreadBoundPrintStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ThreadBoundOutputStream
extends FilterOutputStream {
    private InheritableThreadLocal<OutputStream> inheritOutputStream = new InheritableThreadLocal();
    private final OutputStream sink;
    private static PrintStream origSystemOut;
    private static ThreadBoundPrintStream boundOutPrint;
    private static PrintStream origSystemErr;
    private static ThreadBoundPrintStream boundErrPrint;

    public ThreadBoundOutputStream(OutputStream stream) {
        super(stream);
        this.sink = stream;
    }

    public void installThreadStream(OutputStream stream) {
        if (stream == this) {
            return;
        }
        this.inheritOutputStream.set(stream);
    }

    public OutputStream removeThreadStream() {
        OutputStream orig = (OutputStream)this.inheritOutputStream.get();
        this.inheritOutputStream.set(null);
        return orig;
    }

    public OutputStream getThreadStream() {
        OutputStream localOutputStream = this.getThreadLocalOutputStream();
        if (null != localOutputStream) {
            return localOutputStream;
        }
        return this.sink;
    }

    private OutputStream getThreadLocalOutputStream() {
        return (OutputStream)this.inheritOutputStream.get();
    }

    @Override
    public void write(int i) throws IOException {
        OutputStream out = this.getThreadLocalOutputStream();
        if (out == null || out == this) {
            super.write(i);
        } else {
            out.write(i);
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream out = this.getThreadLocalOutputStream();
        if (out == null || out == this) {
            super.flush();
        } else {
            out.flush();
        }
    }

    public static synchronized ThreadBoundOutputStream bindSystemOut() {
        if (null == boundOutPrint) {
            origSystemOut = System.out;
            ThreadBoundOutputStream boundOut = new ThreadBoundOutputStream(origSystemOut);
            boundOutPrint = new ThreadBoundPrintStream(boundOut);
            System.setOut(boundOutPrint);
            return boundOut;
        }
        return boundOutPrint.getThreadBoundOutputStream();
    }

    public static synchronized void unbindSystemOut() {
        if (null != origSystemOut) {
            System.setOut(origSystemOut);
        }
    }

    public static synchronized ThreadBoundOutputStream bindSystemErr() {
        if (null == boundErrPrint) {
            origSystemErr = System.err;
            ThreadBoundOutputStream newErr = new ThreadBoundOutputStream(origSystemErr);
            boundErrPrint = new ThreadBoundPrintStream(newErr);
            System.setErr(boundErrPrint);
            return newErr;
        }
        return boundErrPrint.getThreadBoundOutputStream();
    }

    public static synchronized void unbindSystemErr() {
        if (null != origSystemErr) {
            System.setErr(origSystemErr);
        }
    }

    public OutputStream getSink() {
        return this.sink;
    }
}

