/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleImpl;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import java.util.Map;
import java.util.Set;

public class AclRuleBuilder {
    private String sourceIdentity;
    private String description;
    private Map<String, Object> resource;
    private String resourceType;
    private boolean regexMatch;
    private boolean containsMatch;
    private boolean equalsMatch;
    private String username;
    private String group;
    private Set<String> allowActions;
    private Set<String> denyActions;
    private EnvironmentalContext environment;

    private AclRuleBuilder() {
    }

    private AclRuleBuilder(AclRuleBuilder fromBuilder) {
        this(fromBuilder.build());
    }

    private AclRuleBuilder(AclRule fromRule) {
        this.sourceIdentity(fromRule.getSourceIdentity());
        this.description(fromRule.getDescription());
        this.resource(fromRule.getResource());
        this.resourceType(fromRule.getResourceType());
        this.regexMatch(fromRule.isRegexMatch());
        this.containsMatch(fromRule.isContainsMatch());
        this.equalsMatch(fromRule.isEqualsMatch());
        this.username(fromRule.getUsername());
        this.group(fromRule.getGroup());
        this.allowActions(fromRule.getAllowActions());
        this.denyActions(fromRule.getDenyActions());
        this.environment(fromRule.getEnvironment());
    }

    public static AclRuleBuilder builder(AclRule fromRule) {
        return new AclRuleBuilder(fromRule);
    }

    public static AclRuleBuilder builder(AclRuleBuilder fromBuilder) {
        return new AclRuleBuilder(fromBuilder);
    }

    public static AclRuleBuilder builder() {
        return new AclRuleBuilder();
    }

    public AclRuleBuilder sourceIdentityAppend(String sourceIdentity) {
        this.sourceIdentity = null != this.sourceIdentity ? this.sourceIdentity + sourceIdentity : sourceIdentity;
        return this;
    }

    public AclRuleBuilder sourceIdentity(String sourceIdentity) {
        this.sourceIdentity = sourceIdentity;
        return this;
    }

    public AclRuleBuilder description(String description) {
        this.description = description;
        return this;
    }

    public AclRuleBuilder resource(Map<String, Object> resource) {
        this.resource = resource;
        return this;
    }

    public AclRuleBuilder resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public AclRuleBuilder regexMatch(boolean regexMatch) {
        this.regexMatch = regexMatch;
        return this;
    }

    public AclRuleBuilder containsMatch(boolean containsMatch) {
        this.containsMatch = containsMatch;
        return this;
    }

    public AclRuleBuilder equalsMatch(boolean equalsMatch) {
        this.equalsMatch = equalsMatch;
        return this;
    }

    public AclRuleBuilder username(String username) {
        this.username = username;
        return this;
    }

    public AclRuleBuilder group(String group) {
        this.group = group;
        return this;
    }

    public AclRuleBuilder allowActions(Set<String> allowActions) {
        this.allowActions = allowActions;
        return this;
    }

    public AclRuleBuilder environment(EnvironmentalContext environment) {
        this.environment = environment;
        return this;
    }

    public AclRuleBuilder denyActions(Set<String> denyActions) {
        this.denyActions = denyActions;
        return this;
    }

    public AclRule build() {
        return new AclRuleImpl(this.sourceIdentity, this.description, this.resource, this.resourceType, this.regexMatch, this.containsMatch, this.equalsMatch, this.username, this.group, this.allowActions, this.denyActions, this.environment);
    }
}

