/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.AclSubject;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.ContextDecision;
import com.dtolabs.rundeck.core.authorization.providers.ContextEvaluation;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.core.utils.PairImpl;
import java.io.PrintStream;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.log4j.Logger;

public class RuleEvaluator
implements Authorization,
AclRuleSetSource {
    private static final Logger logger = Logger.getLogger(RuleEvaluator.class);
    private final AclRuleSet rules;
    private final AclRuleSetSource source;
    private static ConcurrentHashMap<String, Pattern> patternCache = new ConcurrentHashMap();

    private RuleEvaluator(AclRuleSetSource ruleSetSource) {
        this.source = ruleSetSource;
        this.rules = null;
    }

    private RuleEvaluator(AclRuleSet rules) {
        this.source = null;
        this.rules = rules;
    }

    public static RuleEvaluator createRuleEvaluator(AclRuleSetSource ruleSetSource) {
        return new RuleEvaluator(ruleSetSource);
    }

    public static RuleEvaluator createRuleEvaluator(AclRuleSet rules) {
        return new RuleEvaluator(rules);
    }

    @Override
    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        return this.evaluate(resource, subject, action, environment, this.narrowContext(this.getRuleSet(), this.subjectFrom(subject), environment));
    }

    public List<AclRule> narrowContext(AclRuleSet ruleSet, AclSubject subject, Set<Attribute> environment) {
        ArrayList<AclRule> matchedContexts = new ArrayList<AclRule>();
        for (AclRule f : ruleSet.getRules()) {
            if (!this.matchesContexts(f, subject, environment)) continue;
            matchedContexts.add(f);
        }
        return matchedContexts;
    }

    private boolean matchesContexts(AclRule f, AclSubject subject, Set<Attribute> environment) {
        long userMatchStart = System.currentTimeMillis();
        if (f.getEnvironment() != null) {
            EnvironmentalContext environment1 = f.getEnvironment();
            if (!environment1.isValid()) {
                logger.warn((Object)(f.toString() + ": Context section not valid: " + environment1.toString()));
            }
            if (!environment1.matches(environment)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(f.toString() + ": environment not matched: " + environment1.toString()));
                }
                return false;
            }
        } else if (null != environment && environment.size() > 0) {
            logger.debug((Object)(f.toString() + ": empty environment not matched"));
            return false;
        }
        if (subject.getUsername() != null && f.getUsername() != null) {
            if (subject.getUsername().equals(f.getUsername()) || this.matchesPattern(subject.getUsername(), f.getUsername())) {
                return true;
            }
            if (f.getUsername() != null && logger.isDebugEnabled()) {
                logger.debug((Object)(f.toString() + ": username not matched: " + f.getUsername()));
            }
        }
        if (subject.getGroups().size() > 0) {
            if (subject.getGroups().contains(f.getGroup()) || this.matchesAnyPatterns(subject.getGroups(), f.getGroup())) {
                return true;
            }
            if (subject.getGroups().size() > 0 && logger.isDebugEnabled()) {
                logger.debug((Object)(f.toString() + ": group not matched: " + f.getGroup()));
            }
        }
        return false;
    }

    private boolean matchesAnyPatterns(Set<String> groups, String patternStr) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(patternStr);
        }
        catch (Exception e) {
            return false;
        }
        for (String groupName : groups) {
            if (!pattern.matcher(groupName.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(String username, String pattern) {
        try {
            return Pattern.compile(pattern).matcher(username).matches();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private AclSubject subjectFrom(Subject subject) {
        String username;
        if (null == subject) {
            throw new NullPointerException("subject is null");
        }
        Set<Username> userPrincipals = subject.getPrincipals(Username.class);
        if (userPrincipals.size() > 0) {
            Username usernamep = userPrincipals.iterator().next();
            username = usernamep.getName();
        } else {
            username = null;
        }
        Set<Group> groupPrincipals = subject.getPrincipals(Group.class);
        final HashSet<String> groupNames = new HashSet<String>();
        if (groupPrincipals.size() > 0) {
            for (Group groupPrincipal : groupPrincipals) {
                groupNames.add(groupPrincipal.getName());
            }
        }
        return new AclSubject(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public Set<String> getGroups() {
                return groupNames;
            }
        };
    }

    @Override
    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
        HashSet<Decision> decisions = new HashSet<Decision>();
        long duration = 0L;
        List<AclRule> matchedRules = this.narrowContext(this.getRuleSet(), this.subjectFrom(subject), environment);
        for (Map<String, String> resource : resources) {
            for (String action : actions) {
                Decision decision = this.evaluate(resource, subject, action, environment, matchedRules);
                duration += decision.evaluationDuration();
                decisions.add(decision);
            }
        }
        return decisions;
    }

    private Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment, List<AclRule> matchedRules) {
        Decision decision = this.internalEvaluate(resource, subject, action, environment, matchedRules);
        logger.info((Object)MessageFormat.format("Evaluating {0} ({1}ms)", decision, decision.evaluationDuration()));
        return decision;
    }

    private static Decision authorize(boolean authorized, final String reason, final Explanation.Code reasonId, Map<String, String> resource, Subject subject, String action, Set<Attribute> environment, long evaluationTime) {
        return RuleEvaluator.createAuthorize(authorized, new Explanation(){

            @Override
            public Explanation.Code getCode() {
                return reasonId;
            }

            @Override
            public void describe(PrintStream out) {
                out.println(this.toString());
            }

            public String toString() {
                return "\t" + reason + " => " + (Object)((Object)reasonId);
            }
        }, resource, subject, action, environment, evaluationTime);
    }

    static Decision createAuthorize(final boolean authorized, final Explanation explanation, final Map<String, String> resource, final Subject subject, final String action, final Set<Attribute> environment, final long evaluationTime) {
        return new Decision(){
            private String representation;

            @Override
            public boolean isAuthorized() {
                return authorized;
            }

            @Override
            public Map<String, String> getResource() {
                return resource;
            }

            @Override
            public String getAction() {
                return action;
            }

            @Override
            public Set<Attribute> getEnvironment() {
                return environment;
            }

            @Override
            public Subject getSubject() {
                return subject;
            }

            public String toString() {
                if (this.representation == null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Decision for: ");
                    builder.append("res<");
                    Iterator riter = resource.entrySet().iterator();
                    while (riter.hasNext()) {
                        Map.Entry s = riter.next();
                        builder.append((String)s.getKey()).append(':').append((String)s.getValue());
                        if (!riter.hasNext()) continue;
                        builder.append(", ");
                    }
                    builder.append("> subject<");
                    Iterator<Principal> iter = subject.getPrincipals().iterator();
                    while (iter.hasNext()) {
                        Principal principal = iter.next();
                        builder.append(principal.getClass().getSimpleName());
                        builder.append(':');
                        builder.append(principal.getName());
                        if (!iter.hasNext()) continue;
                        builder.append(' ');
                    }
                    builder.append("> action<");
                    builder.append(action);
                    builder.append("> env<");
                    Iterator eiter = environment.iterator();
                    while (eiter.hasNext()) {
                        Attribute a = (Attribute)eiter.next();
                        builder.append(a);
                        if (!eiter.hasNext()) continue;
                        builder.append(", ");
                    }
                    builder.append(">");
                    builder.append(": authorized: ");
                    builder.append(this.isAuthorized());
                    builder.append(": ");
                    builder.append(explanation.toString());
                    this.representation = builder.toString();
                }
                return this.representation;
            }

            @Override
            public Explanation explain() {
                return explanation;
            }

            @Override
            public long evaluationDuration() {
                return evaluationTime;
            }
        };
    }

    private Decision internalEvaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment, List<AclRule> matchingRules) {
        long start = System.currentTimeMillis();
        if (matchingRules.size() < 1) {
            return RuleEvaluator.authorize(false, "No context matches subject or environment", Explanation.Code.REJECTED_NO_SUBJECT_OR_ENV_FOUND, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        if (resource == null) {
            throw new IllegalArgumentException("Resource does not identify any resource because it's an empty resource property or null.");
        }
        for (Map.Entry<String, String> entry : resource.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Resource definition cannot contain null property name.");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("Resource definition cannot contain null value.  Corresponding key: " + entry.getKey());
        }
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject, subject is null.");
        }
        if (action == null || action.length() <= 0) {
            return RuleEvaluator.authorize(false, "No action provided.", Explanation.Code.REJECTED_NO_ACTION_PROVIDED, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        if (environment == null) {
            environment = Collections.emptySet();
        }
        ContextDecision contextDecision = null;
        ContextDecision lastDecision = null;
        boolean granted = false;
        boolean denied = false;
        for (AclRule rule : matchingRules) {
            ContextDecision includes = this.ruleIncludesResourceAction(rule, resource, action);
            if (Explanation.Code.REJECTED_DENIED == includes.getCode()) {
                contextDecision = includes;
                denied = true;
                return RuleEvaluator.createAuthorize(false, contextDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
            }
            if (includes.granted()) {
                contextDecision = includes;
                granted = true;
            }
            lastDecision = includes;
        }
        if (granted) {
            return RuleEvaluator.createAuthorize(true, contextDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        if (lastDecision == null) {
            return RuleEvaluator.authorize(false, "No resource or action matched.", Explanation.Code.REJECTED_NO_RESOURCE_OR_ACTION_MATCH, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        return RuleEvaluator.createAuthorize(false, lastDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
    }

    @Override
    public AclRuleSet getRuleSet() {
        return null != this.source ? this.source.getRuleSet() : this.rules;
    }

    private ContextDecision ruleIncludesResourceAction(AclRule ctx, Map<String, String> resource, String action) {
        ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
        Explanation.Code decision = this.includes(ctx, resource, action);
        evaluations.add(new ContextEvaluation(decision, MessageFormat.format("{0} {1} for action {2}", new Object[]{ctx, decision, action})));
        return new ContextDecision(decision, Explanation.Code.GRANTED == decision, evaluations);
    }

    public Explanation.Code includes(AclRule rule, Map<String, String> resource, String action) {
        String resType;
        if (!(rule.getResourceType() == null || null != (resType = resource.get("type")) && rule.getResourceType().equals(resType))) {
            return Explanation.Code.REJECTED;
        }
        if (rule.isRegexMatch()) {
            return this.ruleMatchesMatchSection(resource, rule) ? this.allowOrDenyAction(rule, action) : Explanation.Code.REJECTED;
        }
        if (rule.isEqualsMatch()) {
            return this.ruleMatchesEqualsSection(resource, rule) ? this.allowOrDenyAction(rule, action) : Explanation.Code.REJECTED;
        }
        if (rule.isContainsMatch()) {
            return this.ruleMatchesContainsSection(resource, rule) ? this.allowOrDenyAction(rule, action) : Explanation.Code.REJECTED;
        }
        return this.allowOrDenyAction(rule, action);
    }

    private Explanation.Code allowOrDenyAction(AclRule rule, String action) {
        if (rule.getDenyActions().contains(action) || rule.getDenyActions().contains("*")) {
            return Explanation.Code.REJECTED_DENIED;
        }
        if (rule.getAllowActions().contains(action) || rule.getAllowActions().contains("*")) {
            return Explanation.Code.GRANTED;
        }
        return Explanation.Code.REJECTED;
    }

    boolean ruleMatchesContainsSection(Map<String, String> resource, AclRule rule) {
        return this.validRuleSection(rule.getResource()) && this.predicateMatchRules(rule, resource, true, new Converter<String, Predicate>(){

            @Override
            public Predicate convert(String o) {
                return new SetContainsPredicate(o);
            }
        });
    }

    boolean ruleMatchesEqualsSection(Map<String, String> resource, AclRule rule) {
        return this.validRuleSection(rule.getResource()) && this.predicateMatchRules(rule, resource, false, new Converter<String, Predicate>(){

            @Override
            public Predicate convert(String o) {
                return PredicateUtils.equalPredicate((Object)o);
            }
        });
    }

    private boolean validRuleSection(Map section) {
        return null != section && section.size() > 0;
    }

    boolean ruleMatchesMatchSection(Map<String, String> resource, AclRule ruleSection) {
        return this.validRuleSection(ruleSection.getResource()) && this.predicateMatchRules(ruleSection, resource, true, new Converter<String, Predicate>(){

            @Override
            public Predicate convert(String o) {
                return new RegexPredicate(RuleEvaluator.this.patternForRegex(o));
            }
        });
    }

    private Pattern patternForRegex(String regex) {
        if (!patternCache.containsKey(regex)) {
            Pattern compile = null;
            try {
                compile = Pattern.compile(regex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == compile) {
                compile = Pattern.compile("^" + Pattern.quote(regex) + "$");
            }
            patternCache.putIfAbsent(regex, compile);
        }
        return patternCache.get(regex);
    }

    boolean predicateMatchRules(AclRule match, Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer) {
        for (Map.Entry<String, Object> o : match.getResource().entrySet()) {
            Object test;
            Map.Entry<String, Object> entry = o;
            String key = entry.getKey();
            boolean matched = this.applyTest(match, resource, allowListMatch, predicateTransformer, key, test = entry.getValue());
            if (matched) continue;
            return false;
        }
        return true;
    }

    boolean applyTest(AclRule rule, Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer, String key, Object test) {
        ArrayList<Predicate> tests = new ArrayList<Predicate>();
        if (allowListMatch && test instanceof List) {
            for (Object item : (List)test) {
                String s = (String)item;
                tests.add(predicateTransformer.convert(s));
            }
        } else if (test instanceof String) {
            tests.add(predicateTransformer.convert((String)test));
        } else {
            logger.error((Object)(rule.getSourceIdentity() + ": cannot evaluate unexpected type: " + test.getClass().getName()));
            return false;
        }
        return PredicateUtils.allPredicate(tests).evaluate((Object)resource.get(key));
    }

    static class RegexPredicate
    implements Predicate {
        Pattern regex;

        RegexPredicate(Pattern regex) {
            this.regex = regex;
        }

        public boolean evaluate(Object o) {
            return o instanceof String && this.regex.matcher((String)o).matches();
        }
    }

    static class SetContainsPredicate
    implements Predicate {
        HashSet<String> items = new HashSet();

        SetContainsPredicate(Object item) {
            if (item instanceof String) {
                this.items.add((String)item);
            } else if (item instanceof List) {
                this.items.addAll((List)item);
            } else {
                this.items = null;
            }
        }

        public boolean evaluate(Object o) {
            HashSet<String> input;
            if (null == this.items || null == o) {
                return false;
            }
            if (o instanceof String) {
                String[] split;
                HashSet<String> hs = new HashSet<String>();
                String str = (String)o;
                for (String s : split = str.split(",")) {
                    hs.add(s.trim());
                }
                input = hs;
            } else if (o instanceof Collection) {
                input = (HashSet<String>)o;
            } else {
                return false;
            }
            return CollectionUtils.isSubCollection(this.items, (Collection)input);
        }
    }

    static class MatchedContext
    extends PairImpl<Boolean, ContextDecision> {
        MatchedContext(Boolean matched, ContextDecision decision) {
            super(matched, decision);
        }

        public Boolean isMatched() {
            return (Boolean)this.getFirst();
        }

        public ContextDecision getDecision() {
            return (ContextDecision)this.getSecond();
        }
    }
}

