/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleBuilder;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.BasicEnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.ContextDecision;
import com.dtolabs.rundeck.core.authorization.providers.ContextEvaluation;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.core.utils.PairImpl;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.log4j.Logger;

final class YamlPolicy
implements Policy,
AclRuleSetSource {
    static final Logger logger = Logger.getLogger((String)YamlPolicy.class.getName());
    public static final String TYPE_PROPERTY = "type";
    public static final String FOR_SECTION = "for";
    public static final String JOB_TYPE = "job";
    public static final String ACTIONS_SECTION = "actions";
    public static final String CONTEXT_SECTION = "context";
    public static final String BY_SECTION = "by";
    public static final String ID_SECTION = "id";
    public static final String USERNAME_KEY = "username";
    public static final String GROUP_KEY = "group";
    private static final String DESCRIPTION_KEY = "description";
    public static final String PROJECT_CONTEXT = "project";
    public static final String APPLICATION_CONTEXT = "application";
    public Map policyInput;
    private Set<String> usernames = new HashSet<String>();
    private Set<String> groups = new HashSet<String>();
    private Set<Pattern> usernamePatterns = new HashSet<Pattern>();
    private Set<Pattern> groupPatterns = new HashSet<Pattern>();
    YamlAclContext aclContext;
    private YamlEnvironmentalContext environment;
    private Set<AclRule> rules = new HashSet<AclRule>();
    private String sourceIdent;
    private int sourceIndex;
    private ValidationSet validation;
    private List<String> allowed = Arrays.asList("by", "id", "for", "context", "description");
    private List<String> allowedContexts = Arrays.asList("project", "application");
    private boolean envchecked;

    private YamlPolicy(Set<Attribute> context, Map policyInput, String sourceIdent, int sourceIndex, ValidationSet validation) {
        this.policyInput = policyInput;
        this.sourceIdent = sourceIdent;
        this.sourceIndex = sourceIndex;
        this.validation = validation;
        this.parseByClause();
        this.createAclContext();
        this.parseEnvironment(context);
        this.validate();
        this.enumerateRules();
    }

    private void validate() {
        HashSet disallowed = new HashSet(this.policyInput.keySet());
        disallowed.removeAll(this.allowed);
        if (disallowed.size() != 0) {
            throw new AclPolicySyntaxException("Policy contains invalid keys: " + disallowed + ", allowed keys: " + this.allowed);
        }
    }

    static YamlPolicy createYamlPolicy(Map policyInput, String sourceIdent, int sourceIndex, ValidationSet validation) {
        return new YamlPolicy(null, policyInput, sourceIdent, sourceIndex, validation);
    }

    static YamlPolicy createYamlPolicy(Set<Attribute> context, Map policyInput, String sourceIdent, int sourceIndex, ValidationSet validation) {
        return new YamlPolicy(context, policyInput, sourceIdent, sourceIndex, validation);
    }

    private void enumerateRules() {
        AclRuleBuilder ruleBuilder;
        if (null == this.environment) {
            return;
        }
        String description = this.policyInput.containsKey(DESCRIPTION_KEY) ? this.policyInput.get(DESCRIPTION_KEY).toString() : null;
        AclRuleBuilder envProto = AclRuleBuilder.builder().environment(this.environment.toBasic()).description(description).sourceIdentity(this.sourceIdent);
        for (String username : this.usernames) {
            ruleBuilder = AclRuleBuilder.builder(envProto).username(username);
            this.rules.addAll(this.aclContext.createRules(ruleBuilder));
        }
        for (String group : this.groups) {
            ruleBuilder = AclRuleBuilder.builder(envProto).group(group);
            this.rules.addAll(this.aclContext.createRules(ruleBuilder));
        }
    }

    YamlPolicy(Map policyInput, File sourceFile, int sourceIndex, ValidationSet validation) {
        this(null, policyInput, sourceFile.getAbsolutePath(), sourceIndex, validation);
    }

    String identify() {
        return null != this.policyInput.get(ID_SECTION) ? this.policyInput.get(ID_SECTION).toString() : (null != this.sourceIdent ? this.sourceIdent : "(unknown source)");
    }

    @Override
    public AclRuleSet getRuleSet() {
        return new AclRuleSetImpl(this.rules);
    }

    @Override
    public Set<String> getUsernames() {
        return this.usernames;
    }

    @Override
    public EnvironmentalContext getEnvironment() {
        return this.environment;
    }

    private void parseEnvironment(Set<Attribute> forcedContext) {
        Object ctxClause = this.policyInput.get(CONTEXT_SECTION);
        if (null != forcedContext) {
            if (null != ctxClause) {
                throw new AclPolicySyntaxException("Context section should not be specified, it is already set to: " + AuthorizationUtil.contextAsString(forcedContext));
            }
            this.environment = new YamlEnvironmentalContext("http://dtolabs.com/rundeck/env/", forcedContext);
        } else {
            if (null == ctxClause || !(ctxClause instanceof Map)) {
                throw new AclPolicySyntaxException(null == ctxClause ? "Required 'context:' section was not present." : "Context section is not valid: expected a Map, but it was: " + ctxClause.getClass().getName());
            }
            Map ctxClause1 = (Map)ctxClause;
            this.environment = new YamlEnvironmentalContext("http://dtolabs.com/rundeck/env/", ctxClause1);
            if (!this.environment.isValid()) {
                throw new AclPolicySyntaxException("Context section is not valid: " + ctxClause + this.environment.getValidation());
            }
            if (ctxClause1.size() != 1) {
                throw new AclPolicySyntaxException("Context section is not valid: " + ctxClause + ", it should have only one entry: 'application:' or 'project:'");
            }
            if (!this.allowedContexts.containsAll(ctxClause1.keySet())) {
                throw new AclPolicySyntaxException("Context section is not valid: " + ctxClause + ", it should contain only 'application:' or 'project:'");
            }
        }
    }

    @Override
    public Set<Pattern> getUsernamePatterns() {
        return this.usernamePatterns;
    }

    @Override
    public Set<Pattern> getGroupPatterns() {
        return this.groupPatterns;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public AclContext getContext() {
        return this.aclContext;
    }

    private void createAclContext() {
        this.aclContext = new YamlAclContext(this.policyInput, this.validation, new TypeContextFactory(){

            @Override
            public AclContext createAclContext(String type, List typeSection) {
                return new TypeContext(YamlPolicy.this.createTypeRules(type, typeSection));
            }
        });
    }

    List<ContextMatcher> createTypeRules(String type, List typeSection) {
        ArrayList<ContextMatcher> rules = new ArrayList<ContextMatcher>();
        int i = 1;
        for (Object o : typeSection) {
            if (!(o instanceof Map)) {
                throw new AclPolicySyntaxException("Type rule 'for: { " + type + ": [...] }'' entry at index [" + i + "] expected a Map but saw: " + o.getClass().getName());
            }
            Map section = (Map)o;
            rules.add(this.createTypeRuleContext(type, section, i));
            ++i;
        }
        return rules;
    }

    ContextMatcher createTypeRuleContext(String type, Map section, int i) {
        return new TypeRuleContextMatcher(type, section, this.validation, i, this);
    }

    private void parseByClause() {
        Object byClause = this.policyInput.get(BY_SECTION);
        if (byClause == null) {
            throw new AclPolicySyntaxException("Required 'by:' section was not present.");
        }
        if (!(byClause instanceof Map)) {
            throw new AclPolicySyntaxException("Section 'by:' should be a Map, but it was: " + byClause.getClass().getName());
        }
        Map by = (Map)byClause;
        Object u = by.get(USERNAME_KEY);
        Object g = by.get(GROUP_KEY);
        if (null != u) {
            if (u instanceof String) {
                this.addUsername((String)u);
            } else if (u instanceof Collection) {
                for (Object o : (Collection)u) {
                    if (o instanceof String) {
                        this.addUsername((String)o);
                        continue;
                    }
                    throw new AclPolicySyntaxException("Section 'username:' should contain only Strings, but saw a: " + o.getClass().getName());
                }
            } else {
                throw new AclPolicySyntaxException("Section 'username:' should be a list or a String, but it was: " + u.getClass().getName());
            }
        }
        if (null != g) {
            if (g instanceof String) {
                this.addGroup((String)g);
            } else if (g instanceof Collection) {
                for (Object o : (Collection)g) {
                    if (o instanceof String) {
                        this.addGroup((String)o);
                        continue;
                    }
                    throw new AclPolicySyntaxException("Section 'group:' should contain only Strings, but saw a: " + o.getClass().getName());
                }
            } else {
                throw new AclPolicySyntaxException("Section 'group:' should be a list or a String, but it was: " + g.getClass().getName());
            }
        }
        if (this.groups.size() < 1 && this.usernames.size() < 1 && null != this.validation) {
            this.validation.addError(this.sourceIdent, "Section 'by:' is not valid: " + by + " it must contain '" + GROUP_KEY + ":' and/or '" + USERNAME_KEY + ":'");
        }
    }

    private void addGroup(String g) {
        try {
            Pattern p = Pattern.compile(g);
            this.getGroupPatterns().add(p);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        this.groups.add(g);
    }

    private void addUsername(String u) {
        try {
            Pattern p = Pattern.compile(u);
            this.getUsernamePatterns().add(p);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        this.usernames.add(u);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("YamlPolicy[id:");
        sb.append(this.identify()).append(", groups:");
        for (String group : this.getGroups()) {
            sb.append(group).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    static class YamlAclContext
    implements AclContext {
        private String description = "Not Evaluated: ";
        Map policyDef;
        private final ConcurrentHashMap<String, AclContext> typeContexts = new ConcurrentHashMap();
        TypeContextFactory typeContextFactory;
        private Map forsection;
        private ValidationSet validation;
        static final ContextDecision NO_RESOURCE_TYPE_DECISION = new ContextDecision(Explanation.Code.REJECTED_NO_RESOURCE_TYPE, false, Collections.singletonList(new ContextEvaluation(Explanation.Code.REJECTED_NO_RESOURCE_TYPE, "Resource has no 'type'.")));

        YamlAclContext(Map policyDef, ValidationSet validation, TypeContextFactory typeContextFactory) {
            this.policyDef = policyDef;
            this.typeContextFactory = typeContextFactory;
            this.validation = validation;
            this.initialize();
        }

        private void initialize() {
            ArrayList evaluations = new ArrayList();
            Object descriptionValue = this.policyDef.get(YamlPolicy.DESCRIPTION_KEY);
            if (descriptionValue == null || !(descriptionValue instanceof String)) {
                throw new AclPolicySyntaxException("Policy is missing a description.");
            }
            this.description = (String)descriptionValue;
            Object forMap = this.policyDef.get(YamlPolicy.FOR_SECTION);
            if (null == forMap) {
                throw new AclPolicySyntaxException("Required 'for:' section was not present.");
            }
            if (!(forMap instanceof Map)) {
                throw new AclPolicySyntaxException("Expected 'for:' section to contain a map, but was [" + forMap.getClass().getName() + "].");
            }
            this.forsection = (Map)forMap;
            for (Object key : this.forsection.keySet()) {
                if (key instanceof String) {
                    String type = (String)key;
                    Object typeSection = this.forsection.get(key);
                    if (!(typeSection instanceof List)) {
                        throw new AclPolicySyntaxException("Expected 'for: { " + key + ": <...> }' section to " + "contain a List, but was [" + forMap.getClass().getName() + "].");
                    }
                    List typeSectionList = (List)typeSection;
                    if (typeSectionList.size() < 1) {
                        throw new AclPolicySyntaxException("Section 'for: { " + key + ": [...] }' list should not be empty.");
                    }
                    this.typeContexts.putIfAbsent(type, this.createTypeContext(type, typeSectionList));
                    continue;
                }
                throw new AclPolicySyntaxException("Section 'for:' key '" + key + ":' was not a string.");
            }
            if (this.forsection.size() < 1) {
                throw new AclPolicySyntaxException("Section 'for:' should not be empty.");
            }
        }

        public String toString() {
            return "Context: " + this.description;
        }

        private AclContext createTypeContext(String type, List typeSection) {
            return this.typeContextFactory.createAclContext(type, typeSection);
        }

        @Override
        public Set<AclRule> createRules(AclRuleBuilder prototype) {
            HashSet<AclRule> aclRules = new HashSet<AclRule>();
            for (Map.Entry<String, AclContext> stringAclContextEntry : this.typeContexts.entrySet()) {
                AclRuleBuilder builder = AclRuleBuilder.builder(prototype);
                String key = stringAclContextEntry.getKey();
                builder.sourceIdentityAppend("[type:" + key + "]");
                builder.resourceType(key);
                AclContext value = stringAclContextEntry.getValue();
                aclRules.addAll(value.createRules(builder));
            }
            return aclRules;
        }

        private static ContextDecision createNoRulesDecision(String type) {
            return new ContextDecision(Explanation.Code.REJECTED_NO_RULES_DECLARED, false, Collections.singletonList(new ContextEvaluation(Explanation.Code.REJECTED_NO_RULES_DECLARED, "Section for type '" + type + "' was not declared in " + YamlPolicy.FOR_SECTION + " section")));
        }

        @Override
        public ContextDecision includes(Map<String, String> resourceMap, String action) {
            String type = resourceMap.get(YamlPolicy.TYPE_PROPERTY);
            if (null == type) {
                return NO_RESOURCE_TYPE_DECISION;
            }
            AclContext typeContext = this.typeContexts.get(type);
            if (null == typeContext) {
                return YamlAclContext.createNoRulesDecision(type);
            }
            return typeContext.includes(resourceMap, action);
        }
    }

    static class AclPolicySyntaxException
    extends RuntimeException {
        AclPolicySyntaxException() {
        }

        AclPolicySyntaxException(String s) {
            super(s);
        }

        AclPolicySyntaxException(String s, Throwable throwable) {
            super(s, throwable);
        }

        AclPolicySyntaxException(Throwable throwable) {
            super(throwable);
        }
    }

    static class SetContainsPredicate
    implements Predicate {
        HashSet<String> items = new HashSet();

        SetContainsPredicate(Object item) {
            if (item instanceof String) {
                this.items.add((String)item);
            } else if (item instanceof List) {
                this.items.addAll((List)item);
            } else {
                this.items = null;
            }
        }

        public boolean evaluate(Object o) {
            HashSet<String> input;
            if (null == this.items || null == o) {
                return false;
            }
            if (o instanceof String) {
                String[] split;
                HashSet<String> hs = new HashSet<String>();
                String str = (String)o;
                for (String s : split = str.split(",")) {
                    hs.add(s.trim());
                }
                input = hs;
            } else if (o instanceof Collection) {
                input = (HashSet<String>)o;
            } else {
                return false;
            }
            return CollectionUtils.isSubCollection(this.items, (Collection)input);
        }
    }

    static class RegexPredicate
    implements Predicate {
        Pattern regex;

        RegexPredicate(Pattern regex) {
            this.regex = regex;
        }

        public boolean evaluate(Object o) {
            return o instanceof String && this.regex.matcher((String)o).matches();
        }
    }

    static class TypeRuleContextMatcher
    implements ContextMatcher {
        public static final String MATCH_SECTION = "match";
        public static final String EQUALS_SECTION = "equals";
        public static final String CONTAINS_SECTION = "contains";
        public static final String ALLOW_ACTIONS = "allow";
        public static final String DENY_ACTIONS = "deny";
        Map ruleSection;
        int index;
        YamlPolicy policy;
        ValidationSet validation;
        String type;
        private static ConcurrentHashMap<String, Pattern> patternCache = new ConcurrentHashMap();

        TypeRuleContextMatcher(String type, Map ruleSection, ValidationSet validation, int index, YamlPolicy policy) {
            this.type = type;
            this.ruleSection = ruleSection;
            this.index = index;
            this.policy = policy;
            this.validation = validation;
            this.validate(validation);
        }

        private void validate(ValidationSet validation) {
            HashSet<String> actions;
            if (null == validation) {
                return;
            }
            if (this.ruleSection.containsKey(DENY_ACTIONS)) {
                actions = this.getDenyActions();
                if (null == actions) {
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + DENY_ACTIONS + ":' expected a String or a sequence of Strings, but was a " + this.ruleSection.get(DENY_ACTIONS).getClass().getName());
                } else if (0 == actions.size()) {
                    logger.warn((Object)(this.policy.identify() + ": No actions defined in Deny section"));
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + DENY_ACTIONS + ":' should not be empty.");
                }
            }
            if (this.ruleSection.containsKey(ALLOW_ACTIONS)) {
                actions = this.getAllowActions();
                if (null == actions) {
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + ALLOW_ACTIONS + ":' expected a String or a sequence of Strings, but was a " + this.ruleSection.get(ALLOW_ACTIONS).getClass().getName());
                } else if (0 == actions.size()) {
                    logger.warn((Object)(this.policy.identify() + ": No actions defined in Deny section"));
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + ALLOW_ACTIONS + ":' should not be empty.");
                }
            }
            if (!this.ruleSection.containsKey(ALLOW_ACTIONS) && !this.ruleSection.containsKey(DENY_ACTIONS)) {
                validation.addError(this.policy.identify(), this.identify() + " One of '" + ALLOW_ACTIONS + ":' or '" + DENY_ACTIONS + ":' must be present.");
            }
            Map matchBody = null;
            String sectionName = null;
            if (this.isRuleSectionContains()) {
                sectionName = CONTAINS_SECTION;
                matchBody = (Map)this.ruleSection.get(CONTAINS_SECTION);
            } else if (this.isRuleSectionMatch()) {
                sectionName = MATCH_SECTION;
                matchBody = (Map)this.ruleSection.get(MATCH_SECTION);
            } else if (this.isRuleSectionEquals()) {
                sectionName = EQUALS_SECTION;
                matchBody = (Map)this.ruleSection.get(EQUALS_SECTION);
            }
            if (matchBody != null) {
                if (matchBody.size() < 1) {
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + sectionName + ":' should not be empty.");
                } else if (sectionName.equals(CONTAINS_SECTION) && (matchBody.size() != 1 || !matchBody.containsKey("tags"))) {
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + CONTAINS_SECTION + ":' can only be applied to 'tags'.");
                }
                if (matchBody.containsKey(ALLOW_ACTIONS) || matchBody.containsKey(DENY_ACTIONS)) {
                    validation.addError(this.policy.identify(), this.identify() + " Section '" + sectionName + ":' should not contain '" + ALLOW_ACTIONS + ":' or '" + DENY_ACTIONS + ":'.");
                }
            }
        }

        public String toString() {
            return (null != this.policy ? this.policy.identify() + " " : "") + this.identify();
        }

        private String identify() {
            return "Type rule 'for: { " + this.type + ": [...] }' entry at index [" + this.index + "]";
        }

        private Pattern patternForRegex(String regex) {
            if (!patternCache.containsKey(regex)) {
                Pattern compile = null;
                try {
                    compile = Pattern.compile(regex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == compile) {
                    compile = Pattern.compile("^" + Pattern.quote(regex) + "$");
                }
                patternCache.putIfAbsent(regex, compile);
            }
            return patternCache.get(regex);
        }

        @Override
        public MatchedContext includes(Map<String, String> resource, String action) {
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            if (!this.matchesRuleSections(resource, evaluations)) {
                return new MatchedContext(false, new ContextDecision(Explanation.Code.REJECTED, false, evaluations));
            }
            return new MatchedContext(true, this.evaluateActions(action, evaluations));
        }

        @Override
        public AclRule createRule(AclRuleBuilder prototype) {
            Map resourceMap;
            AclRuleBuilder ruleBuilder = AclRuleBuilder.builder(prototype);
            HashSet<String> allowActions = this.ruleSection.containsKey(ALLOW_ACTIONS) ? this.getAllowActions() : new HashSet<String>();
            HashSet<String> denyActions = this.ruleSection.containsKey(DENY_ACTIONS) ? this.getDenyActions() : new HashSet<String>();
            ruleBuilder.sourceIdentityAppend("[rule: " + this.index + "]").allowActions(allowActions).denyActions(denyActions);
            if (this.isRuleSectionMatch()) {
                ruleBuilder.regexMatch(true);
                resourceMap = (Map)this.ruleSection.get(MATCH_SECTION);
            } else if (this.isRuleSectionContains()) {
                ruleBuilder.containsMatch(true);
                resourceMap = (Map)this.ruleSection.get(CONTAINS_SECTION);
            } else if (this.isRuleSectionEquals()) {
                ruleBuilder.equalsMatch(true);
                resourceMap = (Map)this.ruleSection.get(EQUALS_SECTION);
            } else {
                resourceMap = null;
            }
            ruleBuilder.resource(resourceMap);
            return ruleBuilder.build();
        }

        ContextDecision evaluateActions(String action, List<ContextEvaluation> evaluations) {
            boolean denied = false;
            if (this.ruleSection.containsKey(DENY_ACTIONS)) {
                HashSet<String> actions = this.getDenyActions();
                if (null == actions) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid action type."));
                } else if (0 == actions.size()) {
                    logger.warn((Object)(this.identify() + ": No actions defined in Deny section"));
                } else if (actions.contains("*") || actions.contains(action)) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_DENIED, this + " for actions: " + actions));
                    denied = true;
                }
            }
            if (denied) {
                return new ContextDecision(Explanation.Code.REJECTED_DENIED, false, evaluations);
            }
            boolean allowed = false;
            if (this.ruleSection.containsKey(ALLOW_ACTIONS)) {
                HashSet<String> actions = this.getAllowActions();
                if (null == actions) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid action type."));
                } else if (0 == actions.size()) {
                    logger.warn((Object)(this.identify() + ": No actions defined in Allow section"));
                } else if (actions.contains("*") || actions.contains(action)) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, this + " for actions: " + actions));
                    allowed = true;
                }
            }
            if (allowed) {
                return new ContextDecision(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, true, evaluations);
            }
            return new ContextDecision(Explanation.Code.REJECTED, false, evaluations);
        }

        private HashSet<String> getAllowActions() {
            HashSet<String> actions = new HashSet<String>();
            Object actionsObj = this.ruleSection.get(ALLOW_ACTIONS);
            if (actionsObj instanceof String) {
                String actionStr = (String)actionsObj;
                actions.add(actionStr);
            } else if (actionsObj instanceof List) {
                actions.addAll((List)actionsObj);
            } else {
                return null;
            }
            return actions;
        }

        private HashSet<String> getDenyActions() {
            HashSet<String> actions = new HashSet<String>();
            Object actionsObj = this.ruleSection.get(DENY_ACTIONS);
            if (actionsObj instanceof String) {
                String actionStr = (String)actionsObj;
                actions.add(actionStr);
            } else if (actionsObj instanceof List) {
                actions.addAll((List)actionsObj);
            } else {
                return null;
            }
            return actions;
        }

        boolean matchesRuleSections(Map<String, String> resource, List<ContextEvaluation> evaluations) {
            int matchesRequired = 0;
            int matchesMet = 0;
            if (this.isRuleSectionMatch()) {
                ++matchesRequired;
                if (this.ruleMatchesMatchSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "match section did not match"));
                }
            }
            if (this.isRuleSectionEquals()) {
                ++matchesRequired;
                if (this.ruleMatchesEqualsSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "equals section did not match"));
                }
            }
            if (this.isRuleSectionContains()) {
                ++matchesRequired;
                if (this.ruleMatchesContainsSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "contains section did not match"));
                }
            }
            return matchesMet == matchesRequired;
        }

        private boolean isRuleSectionContains() {
            return this.ruleSection.containsKey(CONTAINS_SECTION);
        }

        private boolean isRuleSectionEquals() {
            return this.ruleSection.containsKey(EQUALS_SECTION);
        }

        private boolean isRuleSectionMatch() {
            return this.ruleSection.containsKey(MATCH_SECTION);
        }

        private boolean validRuleSection(Map section) {
            return null != section && section.size() > 0;
        }

        boolean ruleMatchesContainsSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(CONTAINS_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, true, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return new SetContainsPredicate(o);
                }
            });
        }

        boolean ruleMatchesEqualsSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(EQUALS_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, false, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return PredicateUtils.equalPredicate((Object)o);
                }
            });
        }

        boolean ruleMatchesMatchSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(MATCH_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, true, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return new RegexPredicate(TypeRuleContextMatcher.this.patternForRegex(o));
                }
            });
        }

        boolean predicateMatchRules(Map match, Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer) {
            for (Map.Entry o : match.entrySet()) {
                Object test;
                Map.Entry entry = o;
                String key = (String)entry.getKey();
                boolean matched = this.applyTest(resource, allowListMatch, predicateTransformer, key, test = entry.getValue());
                if (matched) continue;
                return false;
            }
            return true;
        }

        boolean applyTest(Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer, String key, Object test) {
            ArrayList<Predicate> tests = new ArrayList<Predicate>();
            if (allowListMatch && test instanceof List) {
                for (Object item : (List)test) {
                    String s = (String)item;
                    tests.add(predicateTransformer.convert(s));
                }
            } else if (test instanceof String) {
                tests.add(predicateTransformer.convert((String)test));
            } else {
                logger.error((Object)(this.identify() + ": cannot evaluate unexpected type: " + test.getClass().getName()));
                return false;
            }
            return PredicateUtils.allPredicate(tests).evaluate((Object)resource.get(key));
        }
    }

    static interface ContextMatcher {
        public MatchedContext includes(Map<String, String> var1, String var2);

        public AclRule createRule(AclRuleBuilder var1);
    }

    static class MatchedContext
    extends PairImpl<Boolean, ContextDecision> {
        MatchedContext(Boolean matched, ContextDecision decision) {
            super(matched, decision);
        }

        public Boolean isMatched() {
            return (Boolean)this.getFirst();
        }

        public ContextDecision getDecision() {
            return (ContextDecision)this.getSecond();
        }
    }

    static class TypeContext
    implements AclContext {
        private final List<ContextMatcher> typeRules;

        public TypeContext(List<ContextMatcher> typeRules) {
            this.typeRules = typeRules;
        }

        @Override
        public ContextDecision includes(Map<String, String> resource, String action) {
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            boolean allowed = false;
            boolean denied = false;
            block0: for (ContextMatcher matcher : this.getTypeRules()) {
                MatchedContext matched = matcher.includes(resource, action);
                if (!matched.isMatched().booleanValue()) continue;
                ContextDecision decision = matched.getDecision();
                if (decision.granted()) {
                    allowed = true;
                }
                if (Explanation.Code.REJECTED_DENIED == decision.getCode()) {
                    denied = true;
                }
                evaluations.addAll(decision.getEvaluations());
                if (denied) continue;
                for (ContextEvaluation contextEvaluation : decision.getEvaluations()) {
                    if (Explanation.Code.REJECTED_DENIED != contextEvaluation.id) continue;
                    ContextEvaluation deniedEvaluation = contextEvaluation;
                    denied = true;
                    continue block0;
                }
            }
            return new ContextDecision(denied ? Explanation.Code.REJECTED_DENIED : (allowed ? Explanation.Code.GRANTED : Explanation.Code.REJECTED), allowed && !denied, evaluations);
        }

        public List<ContextMatcher> getTypeRules() {
            return this.typeRules;
        }

        @Override
        public Set<AclRule> createRules(AclRuleBuilder prototype) {
            HashSet<AclRule> aclRules = new HashSet<AclRule>();
            for (ContextMatcher typeRule : this.typeRules) {
                AclRuleBuilder builder = AclRuleBuilder.builder(prototype);
                aclRules.add(typeRule.createRule(builder));
            }
            return aclRules;
        }
    }

    static interface TypeContextFactory {
        public AclContext createAclContext(String var1, List var2);
    }

    static class YamlEnvironmentalContext
    implements EnvironmentalContext {
        Map<URI, String> matcher = new HashMap<URI, String>();
        Map<URI, Pattern> matcherRegex = new HashMap<URI, Pattern>();
        private boolean valid = false;
        private String validation;
        private String description;
        private static Comparator<Attribute> comparator = new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                int u = attribute.property.compareTo(attribute2.property);
                if (u == 0) {
                    return attribute.value.compareTo(attribute2.value);
                }
                return u;
            }
        };
        private HashMap<String, Boolean> memoize = new HashMap();

        EnvironmentalContext toBasic() {
            if (this.matcherRegex.size() != 1 && this.matcher.size() != 1) {
                throw new IllegalStateException("Expected environmental context to contain only one entry");
            }
            if (this.matcherRegex.size() == 1) {
                Map.Entry<URI, Pattern> next = this.matcherRegex.entrySet().iterator().next();
                URI key = next.getKey();
                Pattern value = next.getValue();
                return BasicEnvironmentalContext.patternContextFor(key.toString().substring("http://dtolabs.com/rundeck/env/".length()), value.toString());
            }
            Map.Entry<URI, String> next = this.matcher.entrySet().iterator().next();
            URI key = next.getKey();
            String value = next.getValue();
            return BasicEnvironmentalContext.staticContextFor(key.toString().substring("http://dtolabs.com/rundeck/env/".length()), value);
        }

        YamlEnvironmentalContext(String uriPrefix, Set<Attribute> ctx) {
            for (Attribute attribute : ctx) {
                if (!attribute.getProperty().toString().startsWith(uriPrefix)) continue;
                URI key = attribute.getProperty();
                String value = attribute.getValue();
                this.matcher.put(key, value);
                try {
                    Pattern compile = Pattern.compile(value);
                    this.matcherRegex.put(key, compile);
                }
                catch (PatternSyntaxException e) {}
            }
            this.valid = this.matcher.size() >= 1;
            this.description = "YamlEnvironmentalContext{" + (this.valid ? ", valid=" + this.valid + ", context='" + this.matcher + '\'' + '}' : ", valid=" + this.valid + ", validation='" + this.getValidation() + '\'' + '}');
        }

        YamlEnvironmentalContext(String uriPrefix, Map ctx) {
            boolean invalidentry = false;
            ArrayList<String> errors = new ArrayList<String>();
            for (Map.Entry o : ctx.entrySet()) {
                Map.Entry entry = o;
                if (entry.getKey() instanceof String) {
                    URI uri;
                    String path = (String)entry.getKey();
                    try {
                        uri = new URI(uriPrefix + path);
                    }
                    catch (URISyntaxException e) {
                        errors.add("Context section: " + entry.getKey() + ": invalid URI: " + e.getMessage());
                        invalidentry = true;
                        continue;
                    }
                    if (entry.getValue() instanceof String) {
                        String value = (String)entry.getValue();
                        this.matcher.put(uri, value);
                        try {
                            Pattern compile = Pattern.compile(value);
                            this.matcherRegex.put(uri, compile);
                        }
                        catch (PatternSyntaxException e) {}
                        continue;
                    }
                    errors.add("Context section: " + entry.getKey() + ": expected 'String', saw: " + entry.getValue().getClass().getName());
                    invalidentry = true;
                    continue;
                }
                errors.add("Context section key expected 'String', saw: " + entry.getKey().getClass().getName());
                invalidentry = true;
            }
            if (errors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String error : errors) {
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(error);
                }
                this.validation = sb.toString();
            }
            this.valid = !invalidentry && this.matcher.size() >= 1;
            this.description = "YamlEnvironmentalContext{" + (this.valid ? ", valid=" + this.valid + ", context='" + this.matcher + '\'' + '}' : ", valid=" + this.valid + ", validation='" + this.getValidation() + '\'' + '}');
        }

        @Override
        public boolean matches(Set<Attribute> environment) {
            return this.memo(environment);
        }

        private boolean memo(Set<Attribute> environment) {
            String ident = this.ident(environment);
            Boolean found = this.memoize.get(ident);
            if (null == found) {
                found = this.evaluateMatches(environment);
                this.memoize.put(ident, found);
            }
            return found;
        }

        private String ident(Set<Attribute> environment) {
            StringBuilder sb = new StringBuilder();
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(comparator);
            attributes.addAll(environment);
            for (Attribute attribute : attributes) {
                sb.append(attribute.hashCode());
                sb.append("/");
            }
            return sb.toString();
        }

        private boolean evaluateMatches(Set<Attribute> environment) {
            HashSet<URI> matchedSet = new HashSet<URI>();
            for (Attribute attribute : environment) {
                Pattern pattern = this.matcherRegex.get(attribute.property);
                String matchValue = this.matcher.get(attribute.property);
                if (null != matchValue && matchValue.equals(attribute.value)) {
                    matchedSet.add(attribute.property);
                    continue;
                }
                if (null == pattern || !pattern.matcher(attribute.value).matches()) continue;
                matchedSet.add(attribute.property);
            }
            return this.valid && matchedSet.size() == this.matcher.keySet().size();
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        public String toString() {
            return this.description;
        }

        public String getValidation() {
            return this.validation;
        }
    }
}

