/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FrameworkProjectMgr
extends FrameworkResourceParent
implements IFrameworkProjectMgr {
    static final String PROJECTMGR_NAME = "frameworkProjectMgr";
    public static final Logger log = Logger.getLogger(FrameworkProjectMgr.class);
    private final FilesystemFramework filesystemFramework;
    private IProjectNodesFactory nodesFactory;
    final HashMap<String, FrameworkProject> projectCache = new HashMap();

    FrameworkProjectMgr(String name, File baseDir, FilesystemFramework filesystemFramework, IProjectNodesFactory nodesFactory) {
        super(name, baseDir, null);
        this.filesystemFramework = filesystemFramework;
        this.nodesFactory = nodesFactory;
    }

    static FrameworkProjectMgr create(String name, File baseDir, Framework framework, IProjectNodesFactory nodesFactory) {
        return FrameworkFactory.createProjectManager(baseDir, framework.getFilesystemFramework(), nodesFactory);
    }

    @Override
    public IRundeckProject createFrameworkProject(String projectName) {
        return this.createFrameworkProjectInt(projectName);
    }

    @Override
    public FrameworkProject createFSFrameworkProject(String projectName) {
        return this.createFrameworkProjectInt(projectName);
    }

    public FilesystemFramework getFilesystemFramework() {
        return this.filesystemFramework;
    }

    @Override
    public IRundeckProject createFrameworkProject(String projectName, Properties properties) {
        return this.createFrameworkProjectInt(projectName, properties, false);
    }

    @Override
    public IRundeckProject createFrameworkProjectStrict(String projectName, Properties properties) {
        return this.createFrameworkProjectInt(projectName, properties, true);
    }

    private FrameworkProject createFrameworkProjectInt(String projectName) {
        return this.createFrameworkProjectInt(projectName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkProject createFrameworkProjectInt(String projectName, Properties properties, boolean strict) {
        FrameworkProject project;
        if (strict && this.existsFrameworkProject(projectName)) {
            throw new IllegalArgumentException("project exists: " + projectName);
        }
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            if (null != this.projectCache.get(projectName)) {
                return this.projectCache.get(projectName);
            }
            project = FrameworkFactory.createFrameworkProject(projectName, new File(this.getBaseDir(), projectName), this.filesystemFramework, this, this.nodesFactory, properties);
            this.projectCache.put(projectName, project);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkProject(String projectName) {
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            super.remove(projectName);
            this.projectCache.remove(projectName);
        }
    }

    @Override
    public Collection<IRundeckProject> listFrameworkProjects() {
        return this.listChildren();
    }

    @Override
    public FrameworkProject getFrameworkProject(String name) {
        try {
            return (FrameworkProject)this.getChild(name);
        }
        catch (FrameworkResourceParent.NoSuchResourceException e) {
            throw new FrameworkResourceParent.NoSuchResourceException("Project does not exist: " + name, this);
        }
    }

    @Override
    public IRundeckProjectConfig loadProjectConfig(String projectName) {
        return FrameworkFactory.loadFrameworkProjectConfig(projectName, new File(this.getBaseDir(), projectName), this.filesystemFramework, null);
    }

    @Override
    public boolean existsFrameworkProject(String project) {
        if (null == project) {
            throw new IllegalArgumentException("project paramater was null");
        }
        return this.existsChild(project);
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        return super.childCouldBeLoaded(name) && new File(this.getBaseDir(), name + "/etc/project.properties").exists();
    }

    @Override
    public String toString() {
        return "FrameworkProjectMgr{name=" + this.getName() + ", baseDir=" + this.getBaseDir() + "}";
    }

    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public IFrameworkResource createChild(String projectName) {
        return this.createFSFrameworkProject(projectName);
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        if (this.childCouldBeLoaded(name)) {
            return this.createFrameworkProjectInt(name);
        }
        return null;
    }
}

