/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.dispatcher;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.Predicate;

public class ReplaceTokenReader
extends FilterReader {
    public static final char DEFAULT_TOKEN_START = '@';
    public static final char DEFAULT_TOKEN_END = '@';
    private Map<String, String> tokens;
    boolean blankIfMissing;
    char tokenStart = (char)64;
    char tokenEnd = (char)64;
    private Predicate tokenCharPredicate;
    private static final char[] ALLOWED_CHARS = ".+-_:".toCharArray();
    public static final Predicate DEFAULT_ALLOWED_PREDICATE;
    private StringBuilder replaceBuffer;
    private int replaceBufferIndex;
    private int readBufferIndex;
    private StringBuilder readBuffer;

    public ReplaceTokenReader(Reader reader, Map<String, String> tokens, boolean blankIfMissing) {
        this(reader, tokens, blankIfMissing, '@', '@');
    }

    public ReplaceTokenReader(Reader reader, Map<String, String> tokens, boolean blankIfMissing, char tokenStart, char tokenEnd) {
        super(reader);
        this.tokens = tokens;
        this.blankIfMissing = blankIfMissing;
        this.tokenStart = tokenStart;
        this.tokenEnd = tokenEnd;
        this.replaceBuffer = new StringBuilder();
        this.readBuffer = new StringBuilder();
        this.replaceBufferIndex = -1;
        this.readBufferIndex = -1;
        this.tokenCharPredicate = DEFAULT_ALLOWED_PREDICATE;
    }

    @Override
    public int read(char[] chars, int offset, int len) throws IOException {
        int count;
        for (count = 0; count < len && count + offset < chars.length; ++count) {
            int read = this.read();
            if (read != -1) {
                chars[count + offset] = (char)read;
                continue;
            }
            if (count != 0) break;
            return -1;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        if (this.replaceBufferIndex >= 0 && this.replaceBufferIndex < this.replaceBuffer.length()) {
            return this.replaceBuffer.charAt(this.replaceBufferIndex++);
        }
        if (this.readBufferIndex >= 0 && this.readBufferIndex < this.readBuffer.length()) {
            return this.readBuffer.charAt(this.readBufferIndex++);
        }
        int read = super.read();
        if (read == this.tokenStart) {
            this.readBuffer.append((char)read);
            if (this.readBufferIndex < 0) {
                this.readBufferIndex = 0;
            }
            do {
                if ((read = super.read()) == this.tokenEnd) {
                    String key = this.readBuffer.substring(1);
                    this.replaceBuffer.setLength(0);
                    this.readBuffer.setLength(0);
                    this.appendTokenSubstitute(key, this.replaceBuffer);
                    this.replaceBufferIndex = 0;
                    this.readBufferIndex = -1;
                    return this.read();
                }
                if (read == -1) continue;
                this.readBuffer.append((char)read);
                if (this.readBufferIndex < 0) {
                    this.readBufferIndex = 0;
                }
                if (this.readBuffer.length() <= 1 || this.tokenCharPredicate.evaluate((Object)Character.valueOf((char)read))) continue;
                this.replaceBuffer.setLength(0);
                this.replaceBuffer.append((CharSequence)this.readBuffer);
                this.replaceBufferIndex = 0;
                this.readBuffer.setLength(0);
                this.readBufferIndex = -1;
                return this.read();
            } while (read != -1);
            if (this.readBufferIndex >= 0 && this.readBufferIndex < this.readBuffer.length()) {
                return this.readBuffer.charAt(this.readBufferIndex++);
            }
        }
        return read;
    }

    private void appendTokenSubstitute(String key, StringBuilder replaceBuffer) {
        if (null != this.tokens.get(key)) {
            replaceBuffer.append(this.tokens.get(key));
        } else if (this.blankIfMissing) {
            replaceBuffer.append("");
        } else {
            replaceBuffer.append(this.tokenStart).append(key).append(this.tokenEnd);
        }
    }

    public Predicate getTokenCharPredicate() {
        return this.tokenCharPredicate;
    }

    public void setTokenCharPredicate(Predicate tokenCharPredicate) {
        this.tokenCharPredicate = tokenCharPredicate;
    }

    static {
        Arrays.sort(ALLOWED_CHARS);
        DEFAULT_ALLOWED_PREDICATE = new Predicate(){

            public boolean evaluate(Object o) {
                Character c = (Character)o;
                return Character.isLetterOrDigit((int)c.charValue()) || Arrays.binarySearch(ALLOWED_CHARS, c.charValue()) >= 0;
            }
        };
    }
}

