/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.utils;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;

public class ResolverUtil {
    public static String resolveProperty(String nodeAttribute, String defaultValue, INodeEntry node, IRundeckProject frameworkProject, Framework framework) {
        if (null != node.getAttributes().get(nodeAttribute)) {
            return node.getAttributes().get(nodeAttribute);
        }
        if (frameworkProject.hasProperty("project." + nodeAttribute) && !"".equals(frameworkProject.getProperty("project." + nodeAttribute))) {
            return frameworkProject.getProperty("project." + nodeAttribute);
        }
        if (framework.hasProperty("framework." + nodeAttribute)) {
            return framework.getProperty("framework." + nodeAttribute);
        }
        return defaultValue;
    }

    public static int resolveIntProperty(String attribute, int defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        int value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    public static long resolveLongProperty(String attribute, long defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        long value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean resolveBooleanProperty(String attribute, boolean defaultValue, INodeEntry iNodeEntry, IRundeckProject frameworkProject, Framework framework) {
        boolean value = defaultValue;
        String string = ResolverUtil.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            value = Boolean.parseBoolean(string);
        }
        return value;
    }
}

