/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.PluginScanner;
import com.dtolabs.rundeck.core.plugins.PluginScannerException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

abstract class DirPluginScanner
implements PluginScanner {
    static Logger log = Logger.getLogger((String)DirPluginScanner.class.getName());
    final File extdir;
    final FileCache<ProviderLoader> filecache;
    long lastScanAllCheckTime = -1L;
    HashSet<String> scanned = new HashSet();
    HashMap<String, Boolean> validity = new HashMap();
    long scanintervalMs;

    protected DirPluginScanner(File extdir, FileCache<ProviderLoader> filecache, long rescanIntervalMs) {
        this.extdir = extdir;
        this.filecache = filecache;
        this.scanintervalMs = rescanIntervalMs;
    }

    public abstract boolean isValidPluginFile(File var1);

    boolean cachedFileValidity(File file) {
        String memo = this.memoFile(file);
        if (!this.validity.containsKey(memo)) {
            this.validity.put(memo, this.isValidPluginFile(file));
        }
        return this.validity.get(memo);
    }

    public abstract FileFilter getFileFilter();

    File resolveProviderConflict(Collection<File> matched) {
        HashMap<File, VersionCompare> versions = new HashMap<File, VersionCompare>();
        ArrayList<File> toCompare = new ArrayList<File>();
        for (File file : matched) {
            String vers = this.getVersionForFile(file);
            if (null == vers) continue;
            versions.put(file, VersionCompare.forString(vers));
            toCompare.add(file);
        }
        VersionCompare.fileComparator c = new VersionCompare.fileComparator(versions);
        ArrayList sorted = new ArrayList(toCompare);
        Collections.sort(sorted, c);
        if (sorted.size() > 0) {
            return (File)sorted.get(sorted.size() - 1);
        }
        return null;
    }

    protected abstract String getVersionForFile(File var1);

    @Override
    public final File scanForFile(ProviderIdent ident) throws PluginScannerException {
        this.debug("scanForFile: " + ident);
        if (!this.extdir.exists() || !this.extdir.isDirectory()) {
            return null;
        }
        File[] files = this.extdir.listFiles(this.getFileFilter());
        if (this.shouldScanAll(files)) {
            return this.scanAll(ident, files);
        }
        return this.scanFor(ident, files);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        File[] files;
        try {
            this.doScanAll();
        }
        catch (PluginScannerException e) {
            // empty catch block
        }
        HashSet<ProviderIdent> providerIdentsHash = new HashSet<ProviderIdent>();
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        if (null != this.extdir && this.extdir.isDirectory() && null != (files = this.extdir.listFiles(this.getFileFilter()))) {
            for (File file : files) {
                if (!this.cachedFileValidity(file)) continue;
                providerIdentsHash.addAll(this.listProviders(file));
            }
        }
        providerIdents.addAll(providerIdentsHash);
        return providerIdents;
    }

    @Override
    public boolean isExpired(ProviderIdent ident, File file) {
        return !file.exists() || !this.scanned.contains(this.memoFile(file));
    }

    @Override
    public boolean shouldRescan() {
        return this.shouldScanAll(this.extdir.listFiles(this.getFileFilter()));
    }

    public void doScanAll() throws PluginScannerException {
        File[] files = this.extdir.listFiles(this.getFileFilter());
        if (null == files) {
            files = new File[]{};
        }
        if (this.shouldScanAll(files)) {
            log.debug((Object)"shouldScanAll true: doScanAll");
            this.scanAll(null, files);
        }
    }

    private boolean shouldScanAll(File[] files) {
        if (this.lastScanAllCheckTime > 0L && this.lastScanAllCheckTime + this.scanintervalMs > System.currentTimeMillis()) {
            log.debug((Object)"shouldScanAll: false, interval");
            return false;
        }
        if (this.scanned.size() != files.length) {
            log.debug((Object)("shouldScanAll: yes, count: " + this.scanned.size() + " vs " + files.length));
            this.clearCache(files);
            return true;
        }
        log.debug((Object)("(shouldScanAll: ...: " + this.scanned.size() + " vs " + files.length));
        for (File file : files) {
            String s = this.memoFile(file);
            boolean validPluginFile = this.cachedFileValidity(file);
            if (validPluginFile && !this.scanned.contains(s)) {
                log.debug((Object)("shouldScanAll: yes, file: " + s));
                this.clearCache(files);
                return true;
            }
            if (validPluginFile || !this.scanned.contains(s)) continue;
            log.debug((Object)("shouldScanAll: yes, file: " + s));
            this.clearCache(files);
            return true;
        }
        log.debug((Object)"shouldScanAll: false, no change");
        this.lastScanAllCheckTime = System.currentTimeMillis();
        return false;
    }

    private void clearCache(File[] files) {
        this.scanned.clear();
        for (File file : files) {
            this.filecache.remove(file);
        }
    }

    private String memoFile(File file) {
        return file.getName() + ":" + file.lastModified() + ":" + file.length();
    }

    private File scanFor(ProviderIdent ident, File[] files) throws PluginScannerException {
        ArrayList<File> candidates = new ArrayList<File>();
        for (File file : files) {
            if (!this.cachedFileValidity(file) || !this.test(ident, file)) continue;
            candidates.add(file);
        }
        if (candidates.size() == 1) {
            return (File)candidates.get(0);
        }
        if (candidates.size() > 1) {
            File resolved = this.resolveProviderConflict(candidates);
            if (null == resolved) {
                log.warn((Object)("More than one plugin file matched: " + StringArrayUtil.asString(candidates.toArray(), ",") + ": " + ident));
            } else {
                return resolved;
            }
        }
        return null;
    }

    private boolean test(ProviderIdent ident, File file) {
        ProviderLoader fileProviderLoader = this.filecache.get(file, this);
        boolean loaderFor = null != fileProviderLoader && fileProviderLoader.isLoaderFor(ident);
        this.debug("filecache result: " + fileProviderLoader + ", loaderForIdent: " + loaderFor);
        return null != fileProviderLoader && loaderFor;
    }

    private List<ProviderIdent> listProviders(File file) {
        ProviderLoader fileProviderLoader = this.filecache.get(file, this);
        return fileProviderLoader.listProviders();
    }

    private File scanAll(ProviderIdent ident, File[] files) throws PluginScannerException {
        ArrayList<File> candidates = new ArrayList<File>();
        this.clearCache(files);
        for (File file : files) {
            if (!this.cachedFileValidity(file)) continue;
            this.scanned.add(this.memoFile(file));
            if (null == ident || !this.test(ident, file)) continue;
            candidates.add(file);
        }
        if (null != ident && candidates.size() > 1) {
            this.clearCache(files);
            File resolved = this.resolveProviderConflict(candidates);
            if (null == resolved) {
                throw new PluginScannerException("More than one plugin file matched: " + StringArrayUtil.asString(candidates.toArray(), ","), ident.getService(), ident.getProviderName());
            }
            candidates.clear();
            candidates.add(resolved);
        }
        this.lastScanAllCheckTime = System.currentTimeMillis();
        if (candidates.size() > 0) {
            return (File)candidates.get(0);
        }
        return null;
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }
}

