/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.FilePluginCache;
import com.dtolabs.rundeck.core.plugins.JarPluginScanner;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.PluginCache;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginScanner;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginManagerService
implements FrameworkSupportService,
ServiceProviderLoader {
    private static final Logger log = Logger.getLogger((String)PluginManagerService.class.getName());
    public static final String SERVICE_NAME = "PluginManager";
    private static final Map<File, PluginManagerService> managerRegistry = new HashMap<File, PluginManagerService>();
    private File extdir;
    private File cachedir;
    private PluginCache cache;

    public PluginManagerService() {
    }

    public PluginManagerService(File extdir, File cachedir) {
        this(extdir, cachedir, PluginManagerService.createDefaultCache(extdir, cachedir));
        log.debug((Object)"Create PluginManagerService");
    }

    public static PluginCache createDefaultCache(File extdir, File cachedir) {
        FileCache<ProviderLoader> filecache = PluginManagerService.createProviderLoaderFileCache();
        FilePluginCache cache = new FilePluginCache(filecache);
        int rescanInterval = 5000;
        cache.addScanner(new JarPluginScanner(extdir, cachedir, filecache, 5000));
        cache.addScanner(new ScriptPluginScanner(extdir, cachedir, filecache, 5000));
        return cache;
    }

    public PluginManagerService(File extdir, File cachedir, PluginCache cache) {
        this.setExtdir(extdir);
        this.setCachedir(cachedir);
        this.setCache(cache);
        log.debug((Object)("Create PluginManagerService with cache: " + cache));
    }

    public static FileCache<ProviderLoader> createProviderLoaderFileCache() {
        return new FileCache<ProviderLoader>();
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public static PluginManagerService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            PluginManagerService instanceForExtDir = PluginManagerService.getInstanceForExtDir(framework.getFilesystemFramework().getLibextDir(framework), framework.getFilesystemFramework().getLibextCacheDir(framework));
            framework.setService(SERVICE_NAME, instanceForExtDir);
            return instanceForExtDir;
        }
        return (PluginManagerService)framework.getService(SERVICE_NAME);
    }

    public static synchronized PluginManagerService getInstanceForExtDir(File libextDir, File cachedir) {
        if (null == managerRegistry.get(libextDir)) {
            PluginManagerService service = new PluginManagerService(libextDir, cachedir);
            managerRegistry.put(libextDir, service);
        }
        return managerRegistry.get(libextDir);
    }

    @Override
    public synchronized List<ProviderIdent> listProviders() {
        return this.getCache().listProviders();
    }

    @Override
    public synchronized <T> T loadProvider(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        ProviderLoader loaderForIdent = this.getCache().getLoaderForIdent(ident);
        if (null == loaderForIdent) {
            throw new MissingProviderException("No matching plugin found", service.getName(), providerName);
        }
        T load = loaderForIdent.load(service, providerName);
        if (null != load) {
            return load;
        }
        throw new ProviderLoaderException("Unable to load provider: " + providerName + ", for service: " + service.getName(), service.getName(), providerName);
    }

    public File getExtdir() {
        return this.extdir;
    }

    public void setExtdir(File extdir) {
        this.extdir = extdir;
    }

    public File getCachedir() {
        return this.cachedir;
    }

    public void setCachedir(File cachedir) {
        this.cachedir = cachedir;
    }

    public PluginCache getCache() {
        return this.cache;
    }

    public void setCache(PluginCache cache) {
        this.cache = cache;
    }
}

