/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.CoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dest, boolean overwrite) throws IOException {
        if (!dest.exists() || dest.exists() && overwrite) {
            try (FileInputStream fileInputStream = new FileInputStream(src);){
                FileChannel srcChannel = fileInputStream.getChannel();
                try (FileOutputStream fileOutputStream = new FileOutputStream(dest);){
                    FileChannel dstChannel = fileOutputStream.getChannel();
                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileStreams(File fromFile, File toFile) throws IOException {
        if (!fromFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(fromFile);){
            int read = 0;
            try (FileOutputStream fos = new FileOutputStream(toFile);){
                byte[] buf = new byte[1024];
                while (-1 != read) {
                    read = fis.read(buf);
                    if (read < 0) continue;
                    fos.write(buf, 0, read);
                }
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileRename(File file, String newPath, Class clazz) {
        File newDestFile = new File(newPath);
        File lockFile = new File(newDestFile.getAbsolutePath() + ".lock");
        try {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                block12: {
                    FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
                    FileLock lock = channel.lock();
                    try {
                        FileUtils.copyFileStreams(file, newDestFile);
                        if (!newDestFile.setLastModified(file.lastModified())) {
                            // empty if block
                        }
                        String osName = System.getProperty("os.name");
                        if (file.renameTo(newDestFile)) break block12;
                        if (osName.toLowerCase().indexOf("windows") > -1 && newDestFile.exists()) {
                            if (!newDestFile.delete()) {
                                throw new CoreException("Unable to remove dest file on windows: " + newDestFile.getAbsolutePath());
                            }
                            if (!file.renameTo(newDestFile)) {
                                throw new CoreException("Unable to move file to dest file on windows: " + file + ", " + newDestFile.getAbsolutePath());
                            }
                            break block12;
                        }
                        throw new CoreException("Unable to move file to dest file: " + file + ", " + newDestFile.getAbsolutePath());
                    }
                    finally {
                        lock.release();
                        channel.close();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
            e.printStackTrace(System.err);
            throw new CoreException("Unable to rename file: " + e.getMessage(), e);
        }
    }

    public static void fileRename(File file, String newPath) {
        FileUtils.fileRename(file, newPath, FileUtils.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.isDirectory() && !targetLocation.mkdirs()) {
                throw new CoreException("Failed to create target directory: " + targetLocation);
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }
}

