/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.scm;

import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.jobs.JobReference;
import com.dtolabs.rundeck.plugins.scm.JobFileMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TemplateJobFileMapper
implements JobFileMapper {
    String pathTemplate;
    File baseDir;

    public TemplateJobFileMapper(String pathTemplate, File baseDir) {
        this.pathTemplate = pathTemplate;
        this.baseDir = baseDir;
    }

    @Override
    public File fileForJob(JobReference jobReference) {
        return new File(this.baseDir, this.substitute(this.pathTemplate, jobReference));
    }

    private String substitute(String key, JobReference reference) {
        return this.substitute(key, this.asMap(reference));
    }

    private Map<String, String> asMap(JobReference reference) {
        HashMap<String, String> data = new HashMap<String, String>();
        String group = this.notBlank(reference.getGroupPath()) ? reference.getGroupPath() + '/' : "";
        data.put("project", reference.getProject());
        data.put("id", reference.getId());
        data.put("name", reference.getJobName());
        data.put("group", group);
        return data;
    }

    private boolean notBlank(String groupPath) {
        return groupPath != null && !"".equals(groupPath);
    }

    private String substitute(String key, Map<String, String> data) {
        return DataContextUtils.replaceDataReferences(key, DataContextUtils.addContext("job", data, null));
    }
}

