/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.services;

import com.dtolabs.rundeck.core.dispatcher.IDispatchedScript;
import com.dtolabs.rundeck.core.execution.ExecutionUtils;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class JobDefinitionSerializer {
    public static Document serialize(IDispatchedScript dispatchdef) throws IOException {
        if (null == dispatchdef) {
            throw new IllegalArgumentException("cannot be null");
        }
        Document doc = DocumentFactory.getInstance().createDocument();
        Element root = doc.addElement("joblist");
        String loglevelstr = ExecutionUtils.getMessageLogLevel(dispatchdef.getLoglevel(), "info").toUpperCase();
        Element job = JobDefinitionSerializer.addJobBasic(root, "dispatch commandline job", loglevelstr);
        JobDefinitionSerializer.addScriptDispatch(dispatchdef, job);
        JobDefinitionSerializer.addNodefilters(job, dispatchdef.getNodeThreadcount(), dispatchdef.isKeepgoing(), dispatchdef.getNodeExcludePrecedence(), dispatchdef.getNodeFilter());
        return doc;
    }

    private static Element addJobBasic(Element root, String jobName, String loglevel) {
        Element job = root.addElement("job");
        job.addElement("name").addText(jobName);
        job.addElement("description").addText(jobName);
        job.addElement("additional");
        job.addElement("loglevel").addText(loglevel);
        return job;
    }

    private static void addScriptDispatch(IDispatchedScript dispatchdef, Element job) throws IOException {
        if (null == dispatchdef.getFrameworkProject()) {
            throw new IllegalArgumentException("No project is specified");
        }
        Element ctx = job.addElement("context");
        ctx.addElement("project").addText(dispatchdef.getFrameworkProject());
        InputStream stream = dispatchdef.getScriptAsStream();
        Element seq = job.addElement("sequence");
        Element cmd = seq.addElement("command");
        if (null != dispatchdef.getScript() || null != stream) {
            Element script = cmd.addElement("script");
            if (null != dispatchdef.getScript()) {
                script.addCDATA(dispatchdef.getScript());
            } else {
                StringWriter sw = new StringWriter();
                JobDefinitionSerializer.copyReader(new InputStreamReader(stream), sw, 10240);
                sw.flush();
                script.addCDATA(sw.toString());
            }
            if (null != dispatchdef.getArgs() && dispatchdef.getArgs().length > 0) {
                Element argstring = cmd.addElement("scriptargs");
                argstring.addText(OptsUtil.join(dispatchdef.getArgs()));
            }
        } else if (null != dispatchdef.getServerScriptFilePath()) {
            Element filepath = cmd.addElement("scriptfile");
            filepath.addText(dispatchdef.getServerScriptFilePath());
            if (null != dispatchdef.getArgs() && dispatchdef.getArgs().length > 0) {
                Element argstring = cmd.addElement("scriptargs");
                argstring.addText(OptsUtil.join(dispatchdef.getArgs()));
            }
        } else if (null != dispatchdef.getArgs() && dispatchdef.getArgs().length > 0) {
            Element exec = cmd.addElement("exec");
            exec.addText(OptsUtil.join(dispatchdef.getArgs()));
        } else {
            throw new IllegalArgumentException("Dispatched script did not specify a command, script or filepath");
        }
    }

    private static void addNodefilters(Element job, int threadCount, boolean keepgoing, boolean excludePrecedence, String nodeFilter) {
        int threadcount;
        int n = threadcount = threadCount > 1 ? threadCount : 1;
        if (null != nodeFilter) {
            Element filters = job.addElement("nodefilters");
            filters.addElement("filter").addText(nodeFilter);
            filters.addAttribute("excludeprecedence", Boolean.toString(excludePrecedence));
        }
        Element dispatch = job.addElement("dispatch");
        dispatch.addElement("threadcount").addText(Integer.toString(threadcount));
        dispatch.addElement("keepgoing").addText(Boolean.toString(keepgoing));
    }

    public static void serializeToFile(IDispatchedScript script, File file) throws IOException {
        Document doc = JobDefinitionSerializer.serialize(script);
        JobDefinitionSerializer.serializeDocToFile(file, doc);
    }

    private static void copyReader(Reader in, Writer out, int bufSize) throws IOException {
        char[] buffer = new char[bufSize];
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
            }
            c = in.read(buffer);
        }
    }

    private static void serializeDocToFile(File file, Document doc) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), format);
        writer.write(doc);
        writer.flush();
    }
}

