/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.LdapGroup;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicy;
import com.dtolabs.rundeck.core.authorization.providers.YamlSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YamlPolicyCollection
implements PolicyCollection {
    static Logger logger = Logger.getLogger((String)YamlPolicyCollection.class.getName());
    private final Set<YamlPolicy> all = new HashSet<YamlPolicy>();
    private final Set<AclRule> ruleSet = new HashSet<AclRule>();
    YamlSource source;
    private final Set<Attribute> forcedContext;
    private ValidationSet validation;

    public YamlPolicyCollection(YamlSource source) throws IOException {
        this.source = source;
        this.forcedContext = null;
        this.load(source);
    }

    public YamlPolicyCollection(YamlSource source, Set<Attribute> forcedContext, ValidationSet validation) throws IOException {
        this.source = source;
        this.forcedContext = forcedContext;
        this.validation = validation;
        this.load(source);
    }

    @Override
    public AclRuleSet getRuleSet() {
        return new AclRuleSetImpl(this.ruleSet);
    }

    private void load(YamlSource source) throws IOException {
        Yaml yaml = new Yaml();
        int index = 1;
        try (YamlSource source1 = source;){
            for (Object yamlDoc : source1.loadAll(yaml)) {
                String ident = source.getIdentity() + "[" + index + "]";
                if (null == yamlDoc) continue;
                if (!(yamlDoc instanceof Map)) {
                    String reason = "Expected a policy document Map, but found: " + yamlDoc.getClass().getName();
                    this.validationError(ident, reason);
                }
                try {
                    YamlPolicy yamlPolicy = YamlPolicy.createYamlPolicy(this.forcedContext, (Map)yamlDoc, source.getIdentity() + "[" + index + "]", index, this.validation);
                    this.all.add(yamlPolicy);
                    this.ruleSet.addAll(yamlPolicy.getRuleSet().getRules());
                }
                catch (YamlPolicy.AclPolicySyntaxException e) {
                    this.validationError(ident, e.getMessage());
                    logger.debug((Object)("ERROR parsing a policy in file: " + source.getIdentity() + "[" + index + "]. Reason: " + e.getMessage()), (Throwable)e);
                }
                ++index;
            }
        }
    }

    private void validationError(String ident, String reason) {
        if (null != this.validation) {
            this.validation.addError(ident, reason);
        }
    }

    @Override
    public Collection<String> groupNames() {
        ArrayList<String> groups = new ArrayList<String>();
        for (YamlPolicy policy : this.all) {
            for (String policyGroup : policy.getGroups()) {
                groups.add(policyGroup);
            }
        }
        return groups;
    }

    @Override
    public long countPolicies() {
        return this.all.size();
    }

    @Override
    public Collection<AclContext> matchedContexts(Subject subject, Set<Attribute> environment) {
        return YamlPolicyCollection.policyMatcher(subject, this.all, environment, this.source.getIdentity());
    }

    static Collection<AclContext> policyMatcher(Subject subject, Collection<? extends Policy> policyLister, Set<Attribute> environment, String sourceIdentity) {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        int i = 0;
        Set<Username> userPrincipals = subject.getPrincipals(Username.class);
        HashSet<String> usernamePrincipals = new HashSet<String>();
        if (userPrincipals.size() > 0) {
            for (Username username : userPrincipals) {
                usernamePrincipals.add(username.getName());
            }
        }
        Set<Group> groupPrincipals = subject.getPrincipals(Group.class);
        HashSet<Object> groupNames = new HashSet<Object>();
        if (groupPrincipals.size() > 0) {
            for (Group group : groupPrincipals) {
                if (group instanceof LdapGroup) {
                    try {
                        groupNames.add(new LdapName(group.getName()));
                    }
                    catch (InvalidNameException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                groupNames.add(group.getName());
            }
        }
        for (Policy policy : policyLister) {
            long userMatchStart = System.currentTimeMillis();
            if (null != policy.getEnvironment()) {
                EnvironmentalContext environment1 = policy.getEnvironment();
                if (!environment1.isValid()) {
                    logger.warn((Object)(policy.toString() + ": Context section not valid: " + environment1.toString()));
                }
                if (!environment1.matches(environment)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(policy.toString() + ": environment not matched: " + environment1.toString()));
                    continue;
                }
            } else if (null != environment && environment.size() > 0) {
                logger.debug((Object)(policy.toString() + ": empty environment not matched"));
                continue;
            }
            if (usernamePrincipals.size() > 0) {
                Set<String> policyUsers = policy.getUsernames();
                if (!Collections.disjoint(policyUsers, usernamePrincipals) || YamlPolicyCollection.matchesAnyPatterns(usernamePrincipals, policy.getUsernamePatterns())) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyUsers.size() > 0 && logger.isDebugEnabled()) {
                    logger.debug((Object)(policy.toString() + ": username not matched: " + policyUsers));
                }
            }
            if (groupNames.size() > 0) {
                Set<String> policyGroups = policy.getGroups();
                if (!Collections.disjoint(policyGroups, groupNames) || YamlPolicyCollection.matchesAnyPatterns(groupNames, policy.getGroupPatterns())) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyGroups.size() > 0 && logger.isDebugEnabled()) {
                    logger.debug((Object)(policy.toString() + ": group not matched: " + policyGroups));
                }
            }
            ++i;
        }
        logger.debug((Object)(sourceIdentity + ": matched contexts: " + matchedContexts.size()));
        return matchedContexts;
    }

    static boolean matchesAnyPatterns(Set<?> groupNames, Set<Pattern> groupPatterns) {
        for (Pattern groupPattern : groupPatterns) {
            for (Object groupName : groupNames) {
                if (!groupPattern.matcher(groupName.toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

