/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepContextImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.FileBasedGeneratedScript;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileNodeStepExecutor;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.GeneratedScript;
import com.dtolabs.rundeck.plugins.step.RemoteScriptNodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class RemoteScriptNodeStepPluginAdapter
implements NodeStepExecutor,
Describable {
    private RemoteScriptNodeStepPlugin plugin;
    public static final Convert CONVERTER = new Convert();

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    public RemoteScriptNodeStepPluginAdapter(RemoteScriptNodeStepPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        GeneratedScript script;
        Map<String, Object> instanceConfiguration = this.getStepConfiguration(item);
        if (null != instanceConfiguration) {
            instanceConfiguration = DataContextUtils.replaceDataReferences(instanceConfiguration, context.getDataContext());
        }
        String providerName = item.getNodeStepType();
        PropertyResolver resolver = PropertyResolverFactory.createStepPluginRuntimeResolver(context, instanceConfiguration, "RemoteScriptNodeStep", providerName);
        PluginStepContextImpl pluginContext = PluginStepContextImpl.from(context);
        Description description = this.getDescription();
        Map<String, Object> config = PluginAdapterUtility.configureProperties(resolver, description, this.plugin, PropertyScope.InstanceOnly);
        try {
            script = this.plugin.generateScript(pluginContext, config, node);
        }
        catch (RuntimeException e) {
            return new NodeStepResultImpl(e, StepFailureReason.PluginFailed, e.getMessage(), node);
        }
        Map<String, Object> allconfig = PluginAdapterUtility.mapDescribedProperties(resolver, description);
        HashMap<String, String> stringconfig = new HashMap<String, String>();
        for (Map.Entry<String, Object> objectEntry : allconfig.entrySet()) {
            stringconfig.put(objectEntry.getKey(), objectEntry.getValue().toString());
        }
        return RemoteScriptNodeStepPluginAdapter.executeRemoteScript(ExecutionContextImpl.builder(context).setContext("config", stringconfig).build(), node, script, DataContextUtils.resolve(context.getDataContext(), "job", "execid"), providerName);
    }

    static NodeStepResult executeRemoteScript(StepExecutionContext context, INodeEntry node, GeneratedScript script, String ident, String providerName) throws NodeStepException {
        ExecutionService executionService = context.getFramework().getExecutionService();
        if (null != script.getCommand()) {
            return executionService.executeCommand((ExecutionContext)context, ExecArgList.fromStrings(DataContextUtils.stringContainsPropertyReferencePredicate, script.getCommand()), node);
        }
        if (null != script.getScript()) {
            String filepath;
            String destpath = BaseFileCopier.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), providerName + "-script", null, ident);
            try {
                filepath = executionService.fileCopyScriptContent(context, script.getScript(), node, destpath);
            }
            catch (FileCopierException e) {
                throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
            }
            return ScriptFileNodeStepExecutor.executeRemoteScript(context, context.getFramework(), node, script.getArgs(), filepath);
        }
        if (script instanceof FileBasedGeneratedScript) {
            String filepath;
            FileBasedGeneratedScript fileScript = (FileBasedGeneratedScript)script;
            File scriptFile = fileScript.getScriptFile();
            String destpath = BaseFileCopier.generateRemoteFilepathForNode(node, context.getFramework().getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), context.getFramework(), scriptFile.getName(), null, ident);
            try {
                filepath = executionService.fileCopyFile(context, scriptFile, node, destpath);
            }
            catch (FileCopierException e) {
                throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
            }
            return ScriptFileNodeStepExecutor.executeRemoteScript(context, context.getFramework(), node, script.getArgs(), filepath, fileScript.getScriptInterpreter(), fileScript.isInterpreterArgsQuoted());
        }
        return new NodeStepResultImpl(null, StepFailureReason.ConfigurationFailure, "Generated script must have a command or script defined", node);
    }

    private Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    static class Convert
    implements Converter<RemoteScriptNodeStepPlugin, NodeStepExecutor> {
        Convert() {
        }

        @Override
        public NodeStepExecutor convert(RemoteScriptNodeStepPlugin plugin) {
            return new RemoteScriptNodeStepPluginAdapter(plugin);
        }
    }
}

