/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.PluginCache;
import com.dtolabs.rundeck.core.plugins.PluginScanner;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.utils.PairImpl;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class FilePluginCache
implements PluginCache {
    static Logger log = Logger.getLogger((String)FilePluginCache.class.getName());
    private final HashMap<ProviderIdent, cacheItem> cache = new HashMap();
    private final FileCache<ProviderLoader> filecache;
    private List<PluginScanner> scanners;

    public List<PluginScanner> getScanners() {
        return this.scanners;
    }

    public void setScanners(List<PluginScanner> scanners) {
        this.scanners = scanners;
    }

    FilePluginCache(FileCache<ProviderLoader> filecache) {
        this.filecache = filecache;
        this.scanners = new ArrayList<PluginScanner>();
    }

    @Override
    public void addScanner(PluginScanner scanner) {
        this.getScanners().add(scanner);
    }

    private void remove(ProviderIdent ident) {
        cacheItem cacheItem2 = this.cache.get(ident);
        if (null != cacheItem2) {
            this.filecache.remove((File)cacheItem2.getFirst());
        }
        this.cache.remove(ident);
    }

    @Override
    public synchronized ProviderLoader getLoaderForIdent(ProviderIdent ident) throws ProviderLoaderException {
        cacheItem cacheItem2 = this.cache.get(ident);
        if (null == cacheItem2) {
            log.debug((Object)("getLoaderForIdent! " + ident));
            return this.rescanForItem(ident);
        }
        File file = (File)cacheItem2.getFirst();
        if (((PluginScanner)cacheItem2.getSecond()).isExpired(ident, file) || this.shouldRescan()) {
            this.remove(ident);
            log.debug((Object)("getLoaderForIdent(expired): " + ident));
            return this.rescanForItem(ident);
        }
        log.debug((Object)("getLoaderForIdent: " + ident));
        return this.loadFileProvider(cacheItem2);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        for (PluginScanner scanner : this.getScanners()) {
            providerIdents.addAll(scanner.listProviders());
        }
        return providerIdents;
    }

    private boolean shouldRescan() {
        for (PluginScanner scanner : this.getScanners()) {
            if (!scanner.shouldRescan()) continue;
            return true;
        }
        return false;
    }

    private ProviderLoader loadFileProvider(cacheItem cached) {
        File file = (File)cached.getFirst();
        PluginScanner second = (PluginScanner)cached.getSecond();
        log.debug((Object)("loadFileProvider(filecache): " + file));
        return this.filecache.get(file, second);
    }

    private synchronized ProviderLoader rescanForItem(ProviderIdent ident) throws ProviderLoaderException {
        log.debug((Object)("rescanForItem: " + ident));
        File candidate = null;
        PluginScanner cscanner = null;
        for (PluginScanner scanner : this.getScanners()) {
            File file = scanner.scanForFile(ident);
            if (null != file) {
                log.debug((Object)("saw file: " + file));
                if (null != candidate) {
                    throw new ProviderLoaderException("More than one plugin file matched: " + file + ", and " + candidate, ident.getService(), ident.getProviderName());
                }
                candidate = file;
                cscanner = scanner;
                continue;
            }
            log.debug((Object)("scanner no result: " + scanner));
        }
        if (null != candidate) {
            log.debug((Object)("file scanned:" + candidate));
            cacheItem cacheItem2 = new cacheItem(candidate, cscanner);
            this.cache.put(ident, cacheItem2);
            return this.loadFileProvider(cacheItem2);
        }
        return null;
    }

    static class cacheItem
    extends PairImpl<File, PluginScanner> {
        cacheItem(File first, PluginScanner second) {
            super(first, second);
        }
    }
}

