/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.plugins.BaseProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import java.util.ArrayList;
import java.util.List;

public abstract class PluggableProviderRegistryService<T>
extends BaseProviderRegistryService<T>
implements PluggableService<T> {
    protected PluggableProviderRegistryService(Framework framework) {
        super(framework);
    }

    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        T t = null;
        MissingProviderException caught = null;
        try {
            t = super.providerOfType(providerName);
        }
        catch (MissingProviderException e) {
            caught = e;
        }
        if (null != t) {
            return t;
        }
        ServiceProviderLoader pluginManager = this.framework.getPluginManager();
        if (null != pluginManager) {
            return pluginManager.loadProvider(this, providerName);
        }
        if (null != caught) {
            throw caught;
        }
        throw new MissingProviderException("Provider not found", this.getName(), providerName);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>(super.listProviders());
        ServiceProviderLoader pluginManager = this.framework.getPluginManager();
        if (null != pluginManager) {
            List<ProviderIdent> providerIdents1 = pluginManager.listProviders();
            for (ProviderIdent providerIdent : providerIdents1) {
                if (!this.getName().equals(providerIdent.getService())) continue;
                providerIdents.add(providerIdent);
            }
        }
        return providerIdents;
    }
}

