/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.DirPluginScanner;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoader;
import com.dtolabs.rundeck.core.plugins.metadata.PluginMeta;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class ScriptPluginScanner
extends DirPluginScanner {
    private static final Logger log = Logger.getLogger((String)ScriptPluginScanner.class.getName());
    public static final FileFilter FILENAME_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".zip");
        }
    };
    final File cachedir;

    public ScriptPluginScanner(File extdir, File cachedir, FileCache<ProviderLoader> filecache, int rescanInterval) {
        super(extdir, filecache, rescanInterval);
        this.cachedir = cachedir;
    }

    @Override
    public ProviderLoader createLoader(File file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create ScriptFileProviderLoader: " + file));
        }
        return new ScriptPluginProviderLoader(file, this.cachedir);
    }

    @Override
    public ProviderLoader createCacheItemForFile(File file) {
        return this.createLoader(file);
    }

    @Override
    public FileFilter getFileFilter() {
        return FILENAME_FILTER;
    }

    @Override
    public boolean isValidPluginFile(File file) {
        try {
            ZipInputStream zipinput = new ZipInputStream(new FileInputStream(file));
            PluginMeta metadata = ScriptPluginProviderLoader.loadMeta(file, zipinput);
            zipinput.close();
            boolean valid = false;
            if (null != metadata) {
                valid = ScriptPluginProviderLoader.validatePluginMeta(metadata, file);
            }
            if (!valid) {
                log.error((Object)("Skipping plugin file: metadata was invalid: " + file.getAbsolutePath()));
            }
            return valid;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected String getVersionForFile(File file) {
        return ScriptPluginProviderLoader.getVersionForFile(file);
    }
}

