/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.utils;

import com.dtolabs.client.utils.BaseHttpClientChannel;
import com.dtolabs.client.utils.HttpAuthenticator;
import com.dtolabs.client.utils.WebserviceHttpClient;
import com.dtolabs.rundeck.core.CoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

class WebserviceHttpClientChannel
extends BaseHttpClientChannel
implements WebserviceHttpClient {
    public static Logger logger = Logger.getLogger(WebserviceHttpClientChannel.class);
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    public static final String HTTP_SECURE_PROTOCOL = "https";
    boolean errorResponse = false;
    boolean validResponse = false;
    boolean hasDoc = false;
    String responseMessage = null;
    private Document resultDoc = null;
    private File uploadFile = null;
    private Map<String, ? extends Object> formData = null;
    private String fileparam = null;

    public WebserviceHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query) throws CoreException {
        super(urlSpec, authenticator, query);
    }

    public WebserviceHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, File uploadFile, String fileparam) throws CoreException {
        this(urlSpec, authenticator, query);
        this.setUploadFile(uploadFile);
        this.setFileparam(fileparam);
    }

    public WebserviceHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, Map<String, ? extends Object> formData) throws CoreException {
        this(urlSpec, authenticator, query);
        this.setFormData(formData);
    }

    public WebserviceHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, OutputStream destination, String expectedContentType) {
        super(urlSpec, authenticator, query, destination, expectedContentType);
    }

    public WebserviceHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, File uploadFile, String fileparam, OutputStream destination, String expectedContentType) {
        this(urlSpec, authenticator, query, destination, expectedContentType);
        this.setUploadFile(uploadFile);
        this.setFileparam(fileparam);
    }

    @Override
    protected RequestEntity getRequestEntity(PostMethod method) {
        if (this.uploadFile != null) {
            logger.debug((Object)"attempting to upload file with colony request");
            if (null != this.getFileparam() && this.getFileparam().contains("/")) {
                try {
                    return new InputStreamRequestEntity((InputStream)new FileInputStream(this.uploadFile), this.getFileparam());
                }
                catch (FileNotFoundException e) {
                    throw new CoreException("Could not upload file in request to server: " + this.uploadFile.getAbsolutePath(), e);
                }
            }
            try {
                Part[] parts = new Part[]{new FilePart(null != this.getFileparam() ? this.getFileparam() : "uploadFile", this.uploadFile.getName(), this.uploadFile)};
                return new MultipartRequestEntity(parts, method.getParams());
            }
            catch (FileNotFoundException e) {
                throw new CoreException("Could not upload file in request to server: " + this.uploadFile.getAbsolutePath(), e);
            }
        }
        return null;
    }

    @Override
    protected NameValuePair[] getRequestBody(PostMethod method) {
        if (null != this.formData && this.formData.size() > 0) {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry<String, ? extends Object> stringStringEntry : this.formData.entrySet()) {
                Object value = stringStringEntry.getValue();
                if (value instanceof String) {
                    list.add(new NameValuePair(stringStringEntry.getKey(), (String)value));
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                Collection values = (Collection)value;
                for (Object o : values) {
                    list.add(new NameValuePair(stringStringEntry.getKey(), o.toString()));
                }
            }
            return list.toArray(new NameValuePair[this.formData.size()]);
        }
        return null;
    }

    @Override
    protected boolean isPostMethod() {
        return null != this.uploadFile || null != this.formData && this.formData.size() > 0;
    }

    @Override
    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public boolean isErrorResponse() {
        return this.errorResponse;
    }

    @Override
    public boolean hasResultDoc() {
        if (null == this.getResultDoc()) {
            this.hasDoc = false;
        }
        return this.hasDoc;
    }

    @Override
    public Document getResultDoc() {
        return this.resultDoc;
    }

    @Override
    public boolean isValidResponse() {
        return this.validResponse;
    }

    @Override
    protected void postMakeRequest() {
        this.responseMessage = this.getResponseHeader("X-Rundeck-Result") != null ? this.getResponseHeader("X-Rundeck-Result").getValue() : this.getReasonCode();
        this.validResponse = this.getResultCode() >= 200 && this.getResultCode() < 300;
        this.errorResponse = !this.validResponse;
        String type = this.getResultContentType();
        if (type != null && type.indexOf(";") > 0) {
            type = type.substring(0, type.indexOf(";")).trim();
        }
        if (XML_CONTENT_TYPE.equals(type) || APPLICATION_XML_CONTENT_TYPE.equals(type)) {
            SAXReader reader = new SAXReader();
            try {
                Document document = reader.read(this.getResultStream());
                this.setResultDoc(document);
            }
            catch (DocumentException e) {
                logger.error((Object)("Unable to parse result document: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void setUploadFile(File uploadFile) {
        this.uploadFile = uploadFile;
        if (null != uploadFile) {
            logger.debug((Object)("uploading file: " + uploadFile.getAbsolutePath()));
        }
    }

    public String getFileparam() {
        return this.fileparam;
    }

    public void setFileparam(String fileparam) {
        this.fileparam = fileparam;
    }

    private void setResultDoc(Document resultDoc) {
        this.resultDoc = resultDoc;
    }

    public Map<String, ? extends Object> getFormData() {
        return this.formData;
    }

    public void setFormData(Map<String, ? extends Object> formData) {
        this.formData = formData;
    }
}

